/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform.socket.client;

import com.metamatrix.admin.api.exception.security.InvalidSessionException;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.security.LogonException;
import com.metamatrix.client.ExceptionUtil;
import com.metamatrix.common.api.HostInfo;
import com.metamatrix.common.comm.api.ServerConnection;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.comm.exception.ConnectionException;
import com.metamatrix.common.comm.exception.SingleInstanceCommunicationException;
import com.metamatrix.common.comm.platform.CommPlatformPlugin;
import com.metamatrix.common.comm.platform.socket.client.ServerDiscovery;
import com.metamatrix.common.comm.platform.socket.client.SocketServerInstance;
import com.metamatrix.common.comm.platform.socket.client.SocketServerInstanceFactory;
import com.metamatrix.dqp.client.ClientSideDQP;
import com.metamatrix.dqp.client.ResultsFuture;
import com.metamatrix.platform.security.api.ILogon;
import com.metamatrix.platform.security.api.LogonResult;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SocketServerConnection
implements ServerConnection {
    private static final int RETRY_COUNT = 3;
    private SocketServerInstanceFactory connectionFactory;
    private ServerDiscovery serverDiscovery;
    private static Logger log = Logger.getLogger("org.teiid.client.sockets");
    private boolean secure;
    private Properties connProps;
    private SocketServerInstance serverInstance;
    private volatile LogonResult logonResult;
    private ILogon logon;
    private Timer pingTimer;
    private boolean closed;

    public SocketServerConnection(SocketServerInstanceFactory connectionFactory, boolean secure, ServerDiscovery serverDiscovery, Properties connProps, Timer pingTimer) throws CommunicationException, ConnectionException {
        this.connectionFactory = connectionFactory;
        this.serverDiscovery = serverDiscovery;
        this.connProps = connProps;
        this.secure = secure;
        this.logon = this.getService(ILogon.class);
        this.authenticate();
        this.pingTimer = pingTimer;
        if (this.pingTimer != null && this.logonResult.getPingInterval() > 0L) {
            this.schedulePing();
        }
    }

    public synchronized SocketServerInstance selectServerInstance() throws CommunicationException {
        if (this.closed) {
            throw new CommunicationException(CommPlatformPlugin.Util.getString("SocketServerConnection.closed"));
        }
        if (this.serverInstance != null) {
            if (this.serverInstance.isOpen()) {
                return this.serverInstance;
            }
            this.serverInstance = null;
        }
        ArrayList<HostInfo> hostKeys = new ArrayList<HostInfo>(this.serverDiscovery.getKnownHosts());
        ArrayList<HostInfo> hostCopy = new ArrayList<HostInfo>(hostKeys);
        int knownHosts = hostKeys.size();
        while (hostKeys.size() > 0) {
            HostInfo hostInfo = (HostInfo)hostKeys.remove((int)(Math.random() * (double)hostKeys.size()));
            Object ex = null;
            try {
                SocketServerInstance instance = this.connectionFactory.getServerInstance(hostInfo, this.secure);
                if (this.logonResult != null) {
                    ILogon newLogon = instance.getService(ILogon.class);
                    newLogon.assertIdentity(this.logonResult.getSessionID());
                }
                this.serverDiscovery.connectionSuccessful(hostInfo, instance);
                this.serverInstance = instance;
                return this.serverInstance;
            }
            catch (IOException e) {
                ex = e;
            }
            catch (InvalidSessionException e) {
                this.shutdown();
                throw new CommunicationException((Throwable)((Object)e), CommPlatformPlugin.Util.getString("SocketServerInstance.Connection_Error.Connect_Failed", new Object[]{hostInfo.getHostName(), String.valueOf(hostInfo.getPortNumber()), e.getMessage()}));
            }
            catch (SingleInstanceCommunicationException e) {
                ex = e;
            }
            catch (MetaMatrixComponentException e) {
                ex = e;
            }
            this.serverDiscovery.markInstanceAsBad(hostInfo);
            if (knownHosts == 1) {
                if (ex instanceof UnknownHostException) {
                    throw new SingleInstanceCommunicationException((Throwable)ex, CommPlatformPlugin.Util.getString("SocketServerInstance.Connection_Error.Unknown_Host", new Object[]{hostInfo.getHostName()}));
                }
                throw new SingleInstanceCommunicationException((Throwable)ex, CommPlatformPlugin.Util.getString("SocketServerInstance.Connection_Error.Connect_Failed", new Object[]{hostInfo.getHostName(), String.valueOf(hostInfo.getPortNumber()), ((Throwable)ex).getMessage()}));
            }
            log.log(Level.FINE, "Unable to connect to host", (Throwable)ex);
        }
        throw new CommunicationException(CommPlatformPlugin.Util.getString("SocketServerInstancePool.No_valid_host_available", new Object[]{((Object)hostCopy).toString()}));
    }

    public synchronized void authenticate() throws ConnectionException, CommunicationException {
        this.logonResult = null;
        try {
            this.logonResult = this.logon.logon(this.connProps);
            if (this.serverDiscovery.setLogonResult(this.logonResult)) {
                this.selectNewServerInstance();
            }
            return;
        }
        catch (LogonException e) {
            throw new ConnectionException((Throwable)((Object)e), e.getMessage());
        }
        catch (MetaMatrixComponentException e) {
            if (e.getCause() instanceof CommunicationException) {
                throw (CommunicationException)((Object)e.getCause());
            }
            throw new CommunicationException(e, CommPlatformPlugin.Util.getString("PlatformServerConnectionFactory.Unable_to_find_a_component_used_in_logging_on_to_MetaMatrix"));
        }
    }

    private void schedulePing() {
        this.pingTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    if (SocketServerConnection.this.isOpen()) {
                        SocketServerConnection.this.logon.ping();
                        SocketServerConnection.this.schedulePing();
                    }
                }
                catch (InvalidSessionException e) {
                    SocketServerConnection.this.shutdown();
                }
                catch (MetaMatrixComponentException e) {
                    SocketServerConnection.this.shutdown();
                }
            }
        }, this.logonResult.getPingInterval());
    }

    @Override
    public <T> T getService(Class<T> iface) {
        return (T)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{iface}, (InvocationHandler)new ServerConnectionInvocationHandler(iface));
    }

    @Override
    public synchronized void shutdown() {
        if (this.closed) {
            return;
        }
        try {
            ResultsFuture<?> writeFuture = this.logon.logoff();
            writeFuture.get(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InvalidSessionException e) {
        }
        catch (MetaMatrixComponentException e) {
        }
        catch (InterruptedException e) {
        }
        catch (ExecutionException e) {
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        if (this.serverInstance != null) {
            this.serverInstance.shutdown();
            this.serverInstance = null;
        }
        this.closed = true;
        this.serverDiscovery.shutdown();
    }

    @Override
    public synchronized boolean isOpen() {
        if (this.closed) {
            return false;
        }
        try {
            return this.selectServerInstance().isOpen();
        }
        catch (CommunicationException e) {
            return false;
        }
    }

    @Override
    public LogonResult getLogonResult() {
        return this.logonResult;
    }

    synchronized void selectNewServerInstance() {
        this.serverInstance = null;
    }

    public static boolean isSameInstance(Object service, Object otherService) throws CommunicationException {
        try {
            ServerConnectionInvocationHandler handler = (ServerConnectionInvocationHandler)Proxy.getInvocationHandler(service);
            ServerConnectionInvocationHandler otherHandler = (ServerConnectionInvocationHandler)Proxy.getInvocationHandler(otherService);
            return handler.getInstance().getHostInfo().getInetAddress().equals(otherHandler.getInstance().getHostInfo().getInetAddress());
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        catch (UnknownHostException e) {
            throw new CommunicationException(e);
        }
    }

    public static void selectNewServerInstance(Object service) {
        ServerConnectionInvocationHandler handler = (ServerConnectionInvocationHandler)Proxy.getInvocationHandler(service);
        handler.invalidateTarget();
    }

    class ServerConnectionInvocationHandler
    implements InvocationHandler {
        private Class<?> targetClass;
        private SocketServerInstance instance;
        private Object target;
        private boolean failOver;

        public ServerConnectionInvocationHandler(Class<?> targetClass) {
            this.targetClass = targetClass;
            this.failOver = Boolean.valueOf(SocketServerConnection.this.connProps.getProperty("autoFailover")) != false || !ClientSideDQP.class.isAssignableFrom(targetClass);
        }

        private synchronized Object getTarget() throws CommunicationException {
            if (this.target == null) {
                this.instance = SocketServerConnection.this.selectServerInstance();
                this.target = this.instance.getService(this.targetClass);
            }
            return this.target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Throwable exception = null;
            for (int i = 0; i < 3; ++i) {
                try {
                    return method.invoke(this.getTarget(), args);
                }
                catch (InvocationTargetException t) {
                    exception = t.getTargetException();
                }
                catch (Throwable t) {
                    exception = t;
                }
                if (!(exception instanceof SingleInstanceCommunicationException) && !(exception.getCause() instanceof SingleInstanceCommunicationException) || !this.failOver || !SocketServerConnection.this.isOpen()) break;
                this.invalidateTarget();
            }
            throw ExceptionUtil.convertException(method, exception);
        }

        private synchronized void invalidateTarget() {
            this.target = null;
        }

        synchronized SocketServerInstance getInstance() throws CommunicationException {
            if (this.instance == null) {
                this.getTarget();
            }
            return this.instance;
        }
    }
}

