/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform.socket.client;

import com.metamatrix.admin.api.exception.security.InvalidSessionException;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.api.HostInfo;
import com.metamatrix.common.api.MMURL;
import com.metamatrix.common.comm.api.ServerConnectionFactory;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.comm.exception.ConnectionException;
import com.metamatrix.common.comm.platform.socket.client.AdminApiServerDiscovery;
import com.metamatrix.common.comm.platform.socket.client.ObjectChannelFactory;
import com.metamatrix.common.comm.platform.socket.client.OioOjbectChannelFactory;
import com.metamatrix.common.comm.platform.socket.client.ServerDiscovery;
import com.metamatrix.common.comm.platform.socket.client.SocketServerConnection;
import com.metamatrix.common.comm.platform.socket.client.SocketServerInstance;
import com.metamatrix.common.comm.platform.socket.client.SocketServerInstanceFactory;
import com.metamatrix.common.comm.platform.socket.client.SocketServerInstanceImpl;
import com.metamatrix.common.comm.platform.socket.client.UrlServerDiscovery;
import com.metamatrix.common.util.NetUtils;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.core.MetaMatrixCoreException;
import com.metamatrix.core.util.ReflectionHelper;
import com.metamatrix.dqp.client.ResultsFuture;
import com.metamatrix.platform.security.api.ILogon;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public class SocketServerConnectionFactory
implements ServerConnectionFactory,
SocketServerInstanceFactory {
    private static final String URL = "URL";
    private static SocketServerConnectionFactory INSTANCE;
    private ObjectChannelFactory channelFactory;
    private Timer pingTimer;
    private AtomicInteger instanceCount = new AtomicInteger();
    private Map<CachedInstance, CachedInstance> instancePool = new LinkedHashMap<CachedInstance, CachedInstance>();
    private long synchronousTtl = 120000L;
    private int maxCachedInstances = 16;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized SocketServerConnectionFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SocketServerConnectionFactory();
            Properties props = System.getProperties();
            InputStream is = SocketServerConnectionFactory.class.getResourceAsStream("/teiid-client-settings.properties");
            if (is != null) {
                props = new Properties(props);
                try {
                    props.load(is);
                }
                catch (IOException e) {
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
            }
            INSTANCE.init(props);
        }
        return INSTANCE;
    }

    public void init(Properties props) {
        PropertiesUtils.setBeanProperties((Object)this, (Properties)props, (String)"org.teiid.sockets");
        this.pingTimer = new Timer("SocketPing", true);
        this.channelFactory = new OioOjbectChannelFactory(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketServerInstance getServerInstance(HostInfo info, boolean ssl) throws CommunicationException, IOException {
        boolean useCache;
        CachedInstance key = null;
        CachedInstance instance = null;
        boolean bl = useCache = this.maxCachedInstances > 0;
        if (useCache) {
            key = new CachedInstance(info, ssl);
            Map<CachedInstance, CachedInstance> map = this.instancePool;
            synchronized (map) {
                instance = this.instancePool.remove(key);
            }
            if (instance != null) {
                ILogon logon = instance.actual.getService(ILogon.class);
                boolean valid = false;
                try {
                    ResultsFuture<?> success = logon.ping();
                    success.get(this.channelFactory.getSoTimeout(), TimeUnit.MICROSECONDS);
                    valid = true;
                }
                catch (MetaMatrixComponentException e) {
                }
                catch (InvalidSessionException e) {
                }
                catch (InterruptedException e) {
                }
                catch (ExecutionException e) {
                }
                catch (TimeoutException e) {
                    // empty catch block
                }
                if (valid) {
                    return instance.proxy;
                }
                instance.actual.shutdown();
                while (true) {
                    CachedInstance invalid = null;
                    Map<CachedInstance, CachedInstance> map2 = this.instancePool;
                    synchronized (map2) {
                        invalid = this.instancePool.remove(key);
                    }
                    if (invalid == null) break;
                    invalid.actual.shutdown();
                }
            }
        }
        SocketServerInstanceImpl ssii = new SocketServerInstanceImpl(info, ssl, this.getSynchronousTtl());
        ssii.connect(this.channelFactory);
        if (useCache) {
            key.actual = ssii;
            key.instance = this.instanceCount.getAndIncrement();
            key.proxy = (SocketServerInstance)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{SocketServerInstance.class}, (InvocationHandler)new ShutdownHandler(key));
            return key.proxy;
        }
        return ssii;
    }

    @Override
    public SocketServerConnection createConnection(Properties connectionProperties) throws CommunicationException, ConnectionException {
        ServerDiscovery discovery;
        SocketServerConnectionFactory.updateConnectionProperties(connectionProperties);
        MMURL url = new MMURL(connectionProperties.getProperty("serverURL"));
        String discoveryStrategyName = connectionProperties.getProperty("discoveryStategy", AdminApiServerDiscovery.class.getName());
        if (URL.equalsIgnoreCase(discoveryStrategyName)) {
            discovery = new UrlServerDiscovery();
        } else {
            try {
                discovery = (ServerDiscovery)ReflectionHelper.create((String)discoveryStrategyName, null, (ClassLoader)Thread.currentThread().getContextClassLoader());
            }
            catch (MetaMatrixCoreException e) {
                throw new ConnectionException(e);
            }
        }
        discovery.init(url, connectionProperties);
        return new SocketServerConnection(this, url.isUsingSSL(), discovery, connectionProperties, this.pingTimer);
    }

    static void updateConnectionProperties(Properties connectionProperties) {
        try {
            InetAddress addr = NetUtils.getInstance().getInetAddress();
            connectionProperties.put("clientIpAddress", addr.getHostAddress());
            connectionProperties.put("clientHostName", addr.getCanonicalHostName());
        }
        catch (UnknownHostException err1) {
            connectionProperties.put("clientIpAddress", "UnknownClientAddress");
        }
    }

    public long getSynchronousTtl() {
        return this.synchronousTtl;
    }

    public void setSynchronousTtl(long synchronousTTL) {
        this.synchronousTtl = synchronousTTL;
    }

    public int getMaxCachedInstances() {
        return this.maxCachedInstances;
    }

    public void setMaxCachedInstances(int maxCachedInstances) {
        this.maxCachedInstances = maxCachedInstances;
    }

    private static class CachedInstance {
        HostInfo info;
        Integer instance;
        boolean ssl;
        SocketServerInstance actual;
        SocketServerInstance proxy;

        public CachedInstance(HostInfo info, boolean ssl) {
            this.info = info;
            this.ssl = ssl;
        }

        public int hashCode() {
            return this.info.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CachedInstance)) {
                return false;
            }
            CachedInstance other = (CachedInstance)obj;
            if (!this.info.equals(other.info) || this.ssl != other.ssl) {
                return false;
            }
            if (this.instance == null || other.instance == null) {
                return true;
            }
            return this.instance.equals(other.instance);
        }
    }

    private final class ShutdownHandler
    implements InvocationHandler {
        private final CachedInstance key;

        private ShutdownHandler(CachedInstance key) {
            this.key = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object arg0, Method arg1, Object[] arg2) throws Throwable {
            if (arg1.getName().equals("shutdown")) {
                CachedInstance purge = null;
                if (!this.key.actual.isOpen()) {
                    return null;
                }
                Map map = SocketServerConnectionFactory.this.instancePool;
                synchronized (map) {
                    SocketServerConnectionFactory.this.instancePool.put(this.key, this.key);
                    if (SocketServerConnectionFactory.this.instancePool.size() > SocketServerConnectionFactory.this.maxCachedInstances) {
                        Iterator iter = SocketServerConnectionFactory.this.instancePool.keySet().iterator();
                        purge = (CachedInstance)iter.next();
                        iter.remove();
                    }
                }
                if (purge != null) {
                    purge.actual.shutdown();
                }
                return null;
            }
            try {
                return arg1.invoke((Object)this.key.actual, arg2);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
    }
}

