/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform.socket.client;

import com.metamatrix.client.ExceptionUtil;
import com.metamatrix.common.api.HostInfo;
import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.comm.api.ResultsReceiver;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.comm.exception.ExceptionHolder;
import com.metamatrix.common.comm.exception.SingleInstanceCommunicationException;
import com.metamatrix.common.comm.platform.CommPlatformPlugin;
import com.metamatrix.common.comm.platform.socket.Handshake;
import com.metamatrix.common.comm.platform.socket.ObjectChannel;
import com.metamatrix.common.comm.platform.socket.client.ObjectChannelFactory;
import com.metamatrix.common.comm.platform.socket.client.ServiceInvocationStruct;
import com.metamatrix.common.comm.platform.socket.client.SocketServerInstance;
import com.metamatrix.common.util.crypto.CryptoException;
import com.metamatrix.common.util.crypto.Cryptor;
import com.metamatrix.common.util.crypto.DhKeyGenerator;
import com.metamatrix.common.util.crypto.NullCryptor;
import com.metamatrix.core.util.MetaMatrixProductVersion;
import com.metamatrix.dqp.client.ClientSideDQP;
import com.metamatrix.dqp.client.ResultsFuture;
import java.io.EOFException;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SocketServerInstanceImpl
implements SocketServerInstance {
    private AtomicInteger MESSAGE_ID = new AtomicInteger();
    private HostInfo hostInfo;
    private boolean ssl;
    private ObjectChannel socketChannel;
    private static Logger log = Logger.getLogger("org.teiid.client.sockets");
    private long synchTimeout;
    private Cryptor cryptor;
    private Map<Serializable, ResultsReceiver<Object>> asynchronousListeners = new ConcurrentHashMap<Serializable, ResultsReceiver<Object>>();

    public SocketServerInstanceImpl() {
    }

    public SocketServerInstanceImpl(HostInfo host, boolean ssl, long synchTimeout) {
        this.hostInfo = host;
        this.ssl = ssl;
        this.synchTimeout = synchTimeout;
    }

    public void connect(ObjectChannelFactory channelFactory) throws CommunicationException, IOException {
        InetSocketAddress address = new InetSocketAddress(this.hostInfo.getInetAddress(), this.hostInfo.getPortNumber());
        this.socketChannel = channelFactory.createObjectChannel(address, this.ssl);
        try {
            this.doHandshake();
        }
        catch (CommunicationException e) {
            this.socketChannel.close();
            throw e;
        }
        catch (IOException e) {
            this.socketChannel.close();
            throw e;
        }
    }

    @Override
    public HostInfo getHostInfo() {
        return this.hostInfo;
    }

    static String getVersionInfo() {
        return MetaMatrixProductVersion.VERSION_NUMBER;
    }

    private void doHandshake() throws IOException, CommunicationException {
        Handshake handshake;
        try {
            Object obj = this.socketChannel.read();
            if (!(obj instanceof Handshake)) {
                throw new CommunicationException(CommPlatformPlugin.Util.getString("SocketServerInstanceImpl.handshake_error"));
            }
            handshake = (Handshake)obj;
        }
        catch (ClassNotFoundException e1) {
            throw new CommunicationException(e1);
        }
        try {
            if (!SocketServerInstanceImpl.getVersionInfo().equals(handshake.getVersion())) {
                throw new CommunicationException(CommPlatformPlugin.Util.getString("SocketServerInstanceImpl.version_mismatch", new Object[]{SocketServerInstanceImpl.getVersionInfo(), handshake.getVersion()}));
            }
            handshake.setVersion(SocketServerInstanceImpl.getVersionInfo());
            byte[] serverPublicKey = handshake.getPublicKey();
            if (serverPublicKey != null) {
                DhKeyGenerator keyGen = new DhKeyGenerator();
                byte[] publicKey = keyGen.createPublicKey();
                this.cryptor = keyGen.getSymmetricCryptor(serverPublicKey);
                handshake.setPublicKey(publicKey);
            } else {
                this.cryptor = new NullCryptor();
            }
            this.socketChannel.write(handshake);
        }
        catch (CryptoException err) {
            throw new CommunicationException(err);
        }
    }

    @Override
    public boolean isOpen() {
        return this.socketChannel.isOpen();
    }

    public void send(Message message, ResultsReceiver<Object> listener, Serializable messageKey) throws CommunicationException, InterruptedException {
        if (listener != null) {
            this.asynchronousListeners.put(messageKey, listener);
        }
        message.setMessageKey(messageKey);
        boolean success = false;
        try {
            Future<?> writeFuture = this.socketChannel.write(message);
            writeFuture.get();
            success = true;
        }
        catch (ExecutionException e) {
            throw new SingleInstanceCommunicationException(e);
        }
        finally {
            if (!success) {
                this.asynchronousListeners.remove(messageKey);
            }
        }
    }

    public void exceptionOccurred(Throwable e) {
        if (e instanceof CommunicationException) {
            if (e.getCause() instanceof InvalidClassException) {
                log.log(Level.SEVERE, "Unknown class or incorrect class version:", (Throwable)e);
            } else {
                log.log(Level.FINE, "Unable to read: socket was already closed.", (Throwable)e);
            }
        } else if (e instanceof EOFException) {
            log.log(Level.FINE, "Unable to read: socket was already closed.", (Throwable)e);
        } else {
            log.log(Level.WARNING, "Unable to read: unexpected exception", (Throwable)e);
        }
        if (!(e instanceof SingleInstanceCommunicationException)) {
            e = new SingleInstanceCommunicationException((Throwable)e);
        }
        Set<Map.Entry<Serializable, ResultsReceiver<Object>>> entries = this.asynchronousListeners.entrySet();
        Iterator<Map.Entry<Serializable, ResultsReceiver<Object>>> iterator = entries.iterator();
        while (iterator.hasNext()) {
            Map.Entry<Serializable, ResultsReceiver<Object>> entry = iterator.next();
            iterator.remove();
            entry.getValue().exceptionOccurred((Throwable)e);
        }
    }

    public void receivedMessage(Object packet) {
        log.log(Level.FINE, "reading packet");
        if (packet instanceof Message) {
            Message messagePacket = (Message)packet;
            Serializable messageKey = messagePacket.getMessageKey();
            log.log(Level.FINE, "read asynch message:" + messageKey);
            ResultsReceiver<Object> listener = this.asynchronousListeners.remove(messageKey);
            if (listener != null) {
                listener.receiveResults(messagePacket.getContents());
            }
        } else {
            log.log(Level.FINE, "packet ignored:" + packet);
        }
    }

    @Override
    public void shutdown() {
        this.socketChannel.close();
    }

    @Override
    public Cryptor getCryptor() {
        return this.cryptor;
    }

    @Override
    public <T> T getService(Class<T> iface) {
        return (T)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{iface}, (InvocationHandler)new RemoteInvocationHandler(iface));
    }

    public class RemoteInvocationHandler
    implements InvocationHandler {
        private boolean secure;
        private Class<?> targetClass;

        public RemoteInvocationHandler(Class<?> targetClass) {
            this.targetClass = targetClass;
            this.secure = !ClientSideDQP.class.isAssignableFrom(targetClass);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object t = null;
            try {
                Message message = new Message();
                message.setContents(new ServiceInvocationStruct(args, method.getName(), this.targetClass));
                if (this.secure) {
                    message.setContents(SocketServerInstanceImpl.this.getCryptor().sealObject(message.getContents()));
                }
                ResultsFuture<Object> results = new ResultsFuture<Object>(){

                    @Override
                    protected Object convertResult() throws ExecutionException {
                        try {
                            Serializable result = SocketServerInstanceImpl.this.getCryptor().unsealObject((Serializable)super.convertResult());
                            if (result instanceof ExceptionHolder) {
                                throw new ExecutionException(((ExceptionHolder)result).convertException());
                            }
                            if (result instanceof Throwable) {
                                throw new ExecutionException((Throwable)result);
                            }
                            return result;
                        }
                        catch (CryptoException e) {
                            throw new ExecutionException(e);
                        }
                    }

                    @Override
                    public synchronized Object get() throws InterruptedException, ExecutionException {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public synchronized Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                        int timeoutMillis = (int)Math.min(unit.toMillis(timeout), Integer.MAX_VALUE);
                        while (!this.isDone()) {
                            if (timeoutMillis <= 0) {
                                throw new TimeoutException();
                            }
                            long start = System.currentTimeMillis();
                            try {
                                SocketServerInstanceImpl.this.receivedMessage(SocketServerInstanceImpl.this.socketChannel.read());
                            }
                            catch (IOException e) {
                                if (e instanceof SocketTimeoutException) {
                                    timeoutMillis = (int)((long)timeoutMillis - (System.currentTimeMillis() - start));
                                    continue;
                                }
                                SocketServerInstanceImpl.this.exceptionOccurred(e);
                            }
                            catch (ClassNotFoundException e) {
                                SocketServerInstanceImpl.this.exceptionOccurred(e);
                            }
                        }
                        return super.get(timeout, unit);
                    }
                };
                ResultsReceiver<Object> receiver = results.getResultsReceiver();
                SocketServerInstanceImpl.this.send(message, receiver, Integer.valueOf(SocketServerInstanceImpl.this.MESSAGE_ID.getAndIncrement()));
                if (ResultsFuture.class.isAssignableFrom(method.getReturnType())) {
                    return results;
                }
                return results.get(SocketServerInstanceImpl.this.synchTimeout, TimeUnit.MILLISECONDS);
            }
            catch (ExecutionException e) {
                t = e.getCause();
            }
            catch (TimeoutException e) {
                t = new SingleInstanceCommunicationException(e);
            }
            catch (Throwable e) {
                t = e;
            }
            throw ExceptionUtil.convertException(method, t);
        }
    }
}

