/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.lob;

import com.metamatrix.common.lob.LobChunk;
import com.metamatrix.common.lob.LobChunkProducer;
import com.metamatrix.core.CorePlugin;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class ByteLobChunkStream
implements LobChunkProducer {
    private PushbackInputStream stream;
    private int chunkSize;
    private boolean closed;

    public ByteLobChunkStream(InputStream stream, int chunkSize) {
        this.stream = new PushbackInputStream(stream);
        this.chunkSize = chunkSize;
    }

    @Override
    public LobChunk getNextChunk() throws IOException {
        int next;
        if (this.closed) {
            throw new IllegalStateException(CorePlugin.Util.getString("stream_closed"));
        }
        byte[] cbuf = new byte[this.chunkSize];
        int read = this.stream.read(cbuf);
        if (read == -1) {
            return new LobChunk(new byte[0], true);
        }
        boolean isLast = false;
        if (read != this.chunkSize) {
            byte[] buf = new byte[read];
            System.arraycopy(cbuf, 0, buf, 0, read);
            cbuf = buf;
        }
        if ((next = this.stream.read()) == -1) {
            isLast = true;
        } else {
            this.stream.unread(next);
        }
        return new LobChunk(cbuf, isLast);
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.stream.close();
    }
}

