/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.lob;

import com.metamatrix.common.lob.LobChunk;
import com.metamatrix.common.lob.LobChunkProducer;
import com.metamatrix.core.CorePlugin;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;

public class LobChunkInputStream
extends InputStream {
    LobChunkProducer reader;
    byte[] byteData = null;
    int currentCounter = 0;
    boolean lastChunk = false;
    int availableCounter = 0;
    boolean closed = false;
    byte[] contents = null;

    public LobChunkInputStream(LobChunkProducer reader) {
        this.reader = reader;
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            throw new IllegalStateException(CorePlugin.Util.getString("stream_closed"));
        }
        if (this.availableCounter == 0) {
            if (this.lastChunk) {
                return -1;
            }
            this.fetchNextChunk();
        }
        int ret = -1;
        if (this.availableCounter > 0) {
            ret = this.byteData[this.currentCounter++] & 0xFF;
            --this.availableCounter;
        }
        return ret;
    }

    void fetchNextChunk() throws IOException {
        LobChunk value = this.reader.getNextChunk();
        if (value == null) {
            throw new IOException(CorePlugin.Util.getString("lob.invaliddata"));
        }
        this.lastChunk = value.isLast();
        this.byteData = value.getBytes();
        this.currentCounter = 0;
        this.availableCounter = this.byteData.length;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.reader.close();
    }

    public byte[] getByteContents() throws IOException {
        if (this.contents == null) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(102400);
            byte[] buf = new byte[102400];
            int read = this.read(buf);
            while (read != -1) {
                bos.write(buf, 0, read);
                read = this.read(buf);
            }
            this.close();
            this.contents = bos.toByteArray();
            bos.close();
        }
        return this.contents;
    }

    public Reader getUTF16Reader() {
        return new InputStreamReader((InputStream)this, Charset.forName("UTF-16"));
    }
}

