/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.lob;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;

public class ReaderInputStream
extends InputStream {
    private static final int DEFAULT_BUFFER_SIZE = 102400;
    private final Reader reader;
    private final Charset charSet;
    private final int bufferSize;
    private boolean hasMore = true;
    private ByteBuffer currentBuffer;
    private int prefixBytes;
    private boolean needsPrefix = true;

    public ReaderInputStream(Reader reader, Charset charSet) {
        this(reader, charSet, 102400);
    }

    public ReaderInputStream(Reader reader, Charset charSet, int bufferSize) {
        this.reader = reader;
        this.charSet = charSet;
        this.bufferSize = bufferSize;
        if (charSet.displayName().equalsIgnoreCase("UTF-16")) {
            this.prefixBytes = 2;
        }
    }

    @Override
    public int read() throws IOException {
        if (this.currentBuffer == null || !this.currentBuffer.hasRemaining()) {
            if (!this.hasMore) {
                return -1;
            }
            char[] charBuffer = new char[this.bufferSize];
            int charsRead = this.reader.read(charBuffer);
            if (charsRead == -1) {
                this.hasMore = false;
                return -1;
            }
            if (charsRead != charBuffer.length) {
                char[] buf = new char[charsRead];
                System.arraycopy(charBuffer, 0, buf, 0, charsRead);
                charBuffer = buf;
            }
            this.currentBuffer = this.charSet.encode(CharBuffer.wrap(charBuffer));
            if (!this.needsPrefix) {
                this.currentBuffer.position(this.prefixBytes);
            }
            this.needsPrefix = false;
        }
        return this.currentBuffer.get() & 0xFF;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

