/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.xa;

import java.io.Serializable;
import java.math.BigInteger;
import javax.transaction.xa.Xid;

public class MMXid
implements Xid,
Serializable {
    private static final long serialVersionUID = -7078441828703404308L;
    private int formatID;
    private byte[] globalTransactionId;
    private byte[] branchQualifier;
    private String toString;

    public MMXid(Xid xid) {
        this.formatID = xid.getFormatId();
        this.globalTransactionId = xid.getGlobalTransactionId();
        this.branchQualifier = xid.getBranchQualifier();
    }

    public MMXid(int formatID, byte[] globalTransactionId, byte[] branchQualifier) {
        this.formatID = formatID;
        this.globalTransactionId = globalTransactionId;
        this.branchQualifier = branchQualifier;
    }

    @Override
    public int getFormatId() {
        return this.formatID;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this.globalTransactionId;
    }

    @Override
    public byte[] getBranchQualifier() {
        return this.branchQualifier;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof MMXid)) {
            return false;
        }
        MMXid that = (MMXid)obj;
        if (this.formatID != that.formatID) {
            return false;
        }
        if (!this.areByteArraysEqual(this.globalTransactionId, that.globalTransactionId)) {
            return false;
        }
        return this.areByteArraysEqual(this.branchQualifier, that.branchQualifier);
    }

    private boolean areByteArraysEqual(byte[] firstByteArray, byte[] secondByteArray) {
        if (firstByteArray == null || secondByteArray == null) {
            return false;
        }
        if (firstByteArray.length != secondByteArray.length) {
            return false;
        }
        for (int i = 0; i < firstByteArray.length; ++i) {
            if (firstByteArray[i] == secondByteArray[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.toString == null) {
            StringBuffer sb = new StringBuffer();
            sb.append("MMXid global:");
            sb.append(MMXid.getByteArrayString(this.globalTransactionId));
            sb.append(" branch:");
            sb.append(MMXid.getByteArrayString(this.branchQualifier));
            sb.append(" format:");
            sb.append(this.getFormatId());
            this.toString = sb.toString();
        }
        return this.toString;
    }

    static String getByteArrayString(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        return new BigInteger(bytes).toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

