/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.client.impl;

import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.common.comm.CommonCommPlugin;
import com.metamatrix.common.lob.LobChunk;
import com.metamatrix.common.lob.LobChunkProducer;
import com.metamatrix.common.types.Streamable;
import com.metamatrix.dqp.client.ClientSideDQP;
import com.metamatrix.dqp.client.ResultsFuture;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;

public class StreamingLobChunckProducer
implements LobChunkProducer {
    private static AtomicInteger REQUEST_SEQUENCE = new AtomicInteger(0);
    private final Streamable streamable;
    private final ClientSideDQP dqp;
    private final long requestId;
    private final int streamRequestId = REQUEST_SEQUENCE.getAndIncrement();

    public StreamingLobChunckProducer(ClientSideDQP dqp, long requestId, Streamable streamable) {
        this.dqp = dqp;
        this.requestId = requestId;
        this.streamable = streamable;
    }

    @Override
    public LobChunk getNextChunk() throws IOException {
        try {
            ResultsFuture<LobChunk> result = this.dqp.requestNextLobChunk(this.streamRequestId, this.requestId, this.streamable.getReferenceStreamId());
            return (LobChunk)result.get();
        }
        catch (Exception e) {
            IOException ex = new IOException(CommonCommPlugin.Util.getString("StreamImpl.Unable_to_read_data_from_stream", new Object[]{e.getMessage()}));
            ex.initCause(e);
            throw ex;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.dqp.closeLobChunkStream(this.streamRequestId, this.requestId, this.streamable.getReferenceStreamId());
        }
        catch (MetaMatrixException e) {
            IOException ex = new IOException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    public static class Factory {
        private final Streamable streamable;
        private final ClientSideDQP dqp;
        private final long requestId;

        public Factory(ClientSideDQP dqp, long requestId, Streamable streamable) {
            this.dqp = dqp;
            this.requestId = requestId;
            this.streamable = streamable;
        }

        public StreamingLobChunckProducer getLobChunkProducer() {
            return new StreamingLobChunckProducer(this.dqp, this.requestId, this.streamable);
        }
    }
}

