/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.exception;

import com.metamatrix.api.exception.MetaMatrixException;

public class SourceWarning
extends MetaMatrixException {
    private String modelName = "UNKNOWN";
    private String connectorBindingName = "UNKNOWN";
    private boolean partialResults;

    public SourceWarning(String model, String connectorBinding, Throwable ex, boolean partialResults) {
        super(ex);
        if (model != null) {
            this.modelName = model;
        }
        if (connectorBinding != null) {
            this.connectorBindingName = connectorBinding;
        }
        this.partialResults = partialResults;
    }

    public String getModelName() {
        return this.modelName;
    }

    public String getConnectorBindingName() {
        return this.connectorBindingName;
    }

    public boolean isPartialResultsError() {
        return this.partialResults;
    }

    public String toString() {
        StringBuffer warningBuf = new StringBuffer();
        if (this.partialResults) {
            warningBuf.append("Error ");
        } else {
            warningBuf.append("Warning ");
        }
        warningBuf.append("querying the connector with binding name ");
        warningBuf.append(this.connectorBindingName);
        warningBuf.append(" for the model ");
        warningBuf.append(this.modelName);
        warningBuf.append(" : ");
        warningBuf.append(this.getCause());
        return warningBuf.toString();
    }
}

