/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.message;

import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.common.comm.CommonCommPlugin;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class RequestMessage
implements Serializable {
    static final long serialVersionUID = 2258063872049251854L;
    public static final int DEFAULT_FETCH_SIZE = 2000;
    private String[] commands;
    private boolean isBatchedUpdate;
    private int fetchSize = 2000;
    private int cursorType;
    private boolean partialResultsFlag;
    private boolean isPreparedStatement;
    private boolean isCallableStatement;
    private boolean isPreparedBatchUpdate;
    private List parameterValues;
    private boolean validationMode;
    private String txnAutoWrapMode;
    private String XMLFormat;
    private String styleSheet;
    private Boolean requireResultSet;
    private Date submittedTimestamp;
    private Date processingTimestamp;
    private boolean useResultSetCache;
    private boolean dblQuotedVariableAllowed = false;
    private boolean queryPlanAllowed = true;
    private boolean showPlan = false;
    private int rowLimit;
    private Serializable executionPayload;
    private long executionId;

    public RequestMessage() {
    }

    public RequestMessage(String command) {
        this();
        this.setCommands(command);
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public boolean supportsPartialResults() {
        return this.partialResultsFlag;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public void setPartialResults(boolean partial) {
        this.partialResultsFlag = partial;
    }

    public boolean isPreparedStatement() {
        return this.isPreparedStatement;
    }

    public boolean isCallableStatement() {
        return this.isCallableStatement;
    }

    public void setPreparedStatement(boolean isPreparedStatement) {
        this.isPreparedStatement = isPreparedStatement;
    }

    public void setCallableStatement(boolean isCallableStatement) {
        this.isCallableStatement = isCallableStatement;
    }

    public List getParameterValues() {
        if (this.parameterValues == null) {
            return Collections.EMPTY_LIST;
        }
        return this.parameterValues;
    }

    public void setParameterValues(List values) {
        this.parameterValues = values;
    }

    public int getCursorType() {
        return this.cursorType;
    }

    public void setCursorType(int cursorType) {
        this.cursorType = cursorType;
    }

    public boolean getValidationMode() {
        return this.validationMode;
    }

    public String getXMLFormat() {
        return this.XMLFormat;
    }

    public void setValidationMode(boolean validationMode) {
        this.validationMode = validationMode;
    }

    public void setXMLFormat(String xMLFormat) {
        this.XMLFormat = xMLFormat;
    }

    public String getTxnAutoWrapMode() {
        if (this.txnAutoWrapMode == null) {
            return "OPTIMISTIC";
        }
        return this.txnAutoWrapMode;
    }

    public void setTxnAutoWrapMode(String txnAutoWrapMode) throws MetaMatrixProcessingException {
        if (!(txnAutoWrapMode == null || (txnAutoWrapMode = txnAutoWrapMode.toUpperCase()).equals("OFF") || txnAutoWrapMode.equals("ON") || txnAutoWrapMode.equals("OPTIMISTIC") || txnAutoWrapMode.equals("PESSIMISTIC"))) {
            throw new MetaMatrixProcessingException(CommonCommPlugin.Util.getString("RequestMessage.invalid_txnAutoWrap", new Object[]{txnAutoWrapMode}));
        }
        this.txnAutoWrapMode = txnAutoWrapMode;
    }

    public String getStyleSheet() {
        return this.styleSheet;
    }

    public void setStyleSheet(String styleSheet) {
        this.styleSheet = styleSheet;
    }

    public Date getSubmittedTimestamp() {
        return this.submittedTimestamp;
    }

    public void setSubmittedTimestamp(Date submittedTimestamp) {
        this.submittedTimestamp = submittedTimestamp;
    }

    public void markSubmissionStart() {
        this.setSubmittedTimestamp(new Date());
    }

    public Date getProcessingTimestamp() {
        return this.processingTimestamp;
    }

    public void setProcessingTimestamp(Date processingTimestamp) {
        this.processingTimestamp = processingTimestamp;
    }

    public void markProcessingStart() {
        this.setProcessingTimestamp(new Date());
    }

    public boolean useResultSetCache() {
        return this.useResultSetCache;
    }

    public void setUseResultSetCache(boolean useResultSetCacse) {
        this.useResultSetCache = useResultSetCacse;
    }

    public String getCommandString() {
        if (this.commands.length == 1) {
            return this.commands[0];
        }
        return Arrays.deepToString(this.commands);
    }

    public void setDoubleQuotedVariableAllowed(boolean allowed) {
        this.dblQuotedVariableAllowed = allowed;
    }

    public boolean isDoubleQuotedVariableAllowed() {
        return this.dblQuotedVariableAllowed;
    }

    public void setQueryPlanAllowed(boolean allowed) {
        this.queryPlanAllowed = allowed;
    }

    public boolean isQueryPlanAllowed() {
        return this.queryPlanAllowed;
    }

    public boolean getShowPlan() {
        return this.showPlan;
    }

    public void setShowPlan(boolean showPlan) {
        this.showPlan = showPlan;
    }

    public int getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(int rowLimit) {
        this.rowLimit = rowLimit;
    }

    public String[] getCommands() {
        return this.commands;
    }

    public void setCommands(String ... batchedCommands) {
        this.commands = batchedCommands;
    }

    public boolean isPreparedBatchUpdate() {
        return this.isPreparedBatchUpdate;
    }

    public void setPreparedBatchUpdate(boolean isPreparedBatchUpdate) {
        this.isPreparedBatchUpdate = isPreparedBatchUpdate;
    }

    public void setExecutionPayload(Serializable executionPayload) {
        this.executionPayload = executionPayload;
    }

    public Serializable getExecutionPayload() {
        return this.executionPayload;
    }

    public long getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(long executionId) {
        this.executionId = executionId;
    }

    public void setBatchedUpdate(boolean isBatchedUpdate) {
        this.isBatchedUpdate = isBatchedUpdate;
    }

    public boolean isBatchedUpdate() {
        return this.isBatchedUpdate;
    }

    public Boolean getRequireResultSet() {
        return this.requireResultSet;
    }

    public void setRequireResultSet(Boolean requireResultSet) {
        this.requireResultSet = requireResultSet;
    }
}

