/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.message;

import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.common.batch.BatchSerializer;
import com.metamatrix.core.util.ExternalizeUtil;
import com.metamatrix.dqp.message.RequestMessage;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class ResultsMessage
implements Externalizable {
    static final long serialVersionUID = 3546924172976187793L;
    private List[] results = null;
    private String[] columnNames = null;
    private String[] dataTypes = null;
    private Map planDescription;
    private MetaMatrixException exception;
    private List<Exception> warnings;
    private Collection schemas;
    private int firstRow = 0;
    private int lastRow;
    private boolean partialResultsFlag;
    private int finalRow = -1;
    private List parameters;
    private Date processingTimestamp;
    private Date completedTimestamp;
    private int fetchSize;
    private int cursorType;
    private String debugLog;
    private Collection annotations;
    private boolean isUpdateResult;

    public ResultsMessage() {
    }

    public ResultsMessage(RequestMessage requestMsg) {
        if (requestMsg != null) {
            this.processingTimestamp = requestMsg.getProcessingTimestamp();
            this.completedTimestamp = new Date();
            this.fetchSize = requestMsg.getFetchSize();
            this.cursorType = requestMsg.getCursorType();
        }
        this.results = new ArrayList[0];
    }

    public ResultsMessage(RequestMessage requestMsg, List[] results, String[] columnNames, String[] dataTypes) {
        this(requestMsg);
        this.setResults(results);
        this.setFirstRow(1);
        this.setLastRow(results.length);
        this.setPartialResults(false);
        this.columnNames = columnNames;
        this.dataTypes = dataTypes;
    }

    public List[] getResults() {
        return this.results;
    }

    public void setResults(List[] results) {
        this.results = results;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public String[] getDataTypes() {
        return this.dataTypes;
    }

    public MetaMatrixException getException() {
        return this.exception;
    }

    public int getFinalRow() {
        return this.finalRow;
    }

    public int getFirstRow() {
        return this.firstRow;
    }

    public int getLastRow() {
        return this.lastRow;
    }

    public boolean isPartialResults() {
        return this.partialResultsFlag;
    }

    public Map getPlanDescription() {
        return this.planDescription;
    }

    public Collection getSchemas() {
        return this.schemas;
    }

    public List getWarnings() {
        return this.warnings;
    }

    public void setException(Throwable e) {
        this.exception = e instanceof MetaMatrixException ? (MetaMatrixException)e : new MetaMatrixException(e, e.getMessage());
    }

    public void setFinalRow(int i) {
        this.finalRow = i;
    }

    public void setFirstRow(int i) {
        this.firstRow = i;
    }

    public void setLastRow(int i) {
        this.lastRow = i;
    }

    public void setPartialResults(boolean b) {
        this.partialResultsFlag = b;
    }

    public void setPlanDescription(Map object) {
        this.planDescription = object;
    }

    public void setSchemas(Collection collection) {
        this.schemas = collection;
    }

    public void setWarnings(List<Exception> list) {
        this.warnings = list;
    }

    public List getParameters() {
        return this.parameters;
    }

    public void setParameters(List list) {
        this.parameters = list;
    }

    public Date getProcessingTimestamp() {
        return this.processingTimestamp;
    }

    public Date getCompletedTimestamp() {
        return this.completedTimestamp;
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
    }

    public void setDataTypes(String[] dataTypes) {
        this.dataTypes = dataTypes;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public int getCursorType() {
        return this.cursorType;
    }

    public void setCursorType(int cursorType) {
        this.cursorType = cursorType;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.columnNames = ExternalizeUtil.readStringArray((ObjectInput)in);
        this.dataTypes = ExternalizeUtil.readStringArray((ObjectInput)in);
        this.results = BatchSerializer.readBatch(in, this.dataTypes);
        this.planDescription = ExternalizeUtil.readMap((ObjectInput)in);
        this.exception = (MetaMatrixException)ExternalizeUtil.readThrowable((ObjectInput)in);
        this.warnings = ExternalizeUtil.readList((ObjectInput)in);
        this.schemas = ExternalizeUtil.readList((ObjectInput)in);
        this.firstRow = in.readInt();
        this.lastRow = in.readInt();
        this.partialResultsFlag = in.readBoolean();
        this.finalRow = in.readInt();
        this.parameters = ExternalizeUtil.readList((ObjectInput)in);
        this.processingTimestamp = (Date)in.readObject();
        this.completedTimestamp = (Date)in.readObject();
        this.fetchSize = in.readInt();
        this.cursorType = in.readInt();
        this.debugLog = (String)in.readObject();
        this.annotations = (Collection)in.readObject();
        this.isUpdateResult = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ExternalizeUtil.writeArray((ObjectOutput)out, (Object[])this.columnNames);
        ExternalizeUtil.writeArray((ObjectOutput)out, (Object[])this.dataTypes);
        BatchSerializer.writeBatch(out, this.dataTypes, this.results);
        ExternalizeUtil.writeMap((ObjectOutput)out, (Map)this.planDescription);
        ExternalizeUtil.writeThrowable((ObjectOutput)out, (Throwable)this.exception);
        ExternalizeUtil.writeList((ObjectOutput)out, this.warnings);
        ExternalizeUtil.writeCollection((ObjectOutput)out, (Collection)this.schemas);
        out.writeInt(this.firstRow);
        out.writeInt(this.lastRow);
        out.writeBoolean(this.partialResultsFlag);
        out.writeInt(this.finalRow);
        ExternalizeUtil.writeList((ObjectOutput)out, (List)this.parameters);
        out.writeObject(this.processingTimestamp);
        out.writeObject(this.completedTimestamp);
        out.writeInt(this.fetchSize);
        out.writeInt(this.cursorType);
        out.writeObject(this.debugLog);
        out.writeObject(this.annotations);
        out.writeBoolean(this.isUpdateResult);
    }

    public Collection getAnnotations() {
        return this.annotations;
    }

    public String getDebugLog() {
        return this.debugLog;
    }

    public void setAnnotations(Collection collection) {
        this.annotations = collection;
    }

    public void setDebugLog(String string) {
        this.debugLog = string;
    }

    public String toString() {
        return new StringBuffer("ResultsMessage rowCount=").append(this.results == null ? 0 : this.results.length).append(" finalRow=").append(this.finalRow).toString();
    }

    public void setUpdateResult(boolean isUpdateResult) {
        this.isUpdateResult = isUpdateResult;
    }

    public boolean isUpdateResult() {
        return this.isUpdateResult;
    }
}

