/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.api;

import com.metamatrix.jdbc.api.DisplayHelper;
import com.metamatrix.jdbc.api.PlanNode;
import com.metamatrix.jdbc.api.PlanVisitor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TextOutputVisitor
extends PlanVisitor {
    private DisplayHelper displayHelper;
    private int tabs = 0;
    private Map nodeLevels = new HashMap();
    private StringBuffer text = new StringBuffer();

    public TextOutputVisitor(DisplayHelper displayHelper, int initialTabs) {
        this.displayHelper = displayHelper;
        this.tabs = initialTabs;
    }

    public String getText() {
        return this.text.toString();
    }

    @Override
    protected void visitNode(PlanNode node) {
        Integer nodeLevel;
        PlanNode parent = node.getParent();
        if (parent == null) {
            nodeLevel = new Integer(0);
        } else {
            Integer parentLevel = (Integer)this.nodeLevels.get(parent);
            nodeLevel = new Integer(parentLevel + 1);
        }
        this.nodeLevels.put(node, nodeLevel);
        int numTabs = nodeLevel + this.tabs;
        for (int i = 0; i < numTabs; ++i) {
            this.text.append("  ");
        }
        String name = this.displayHelper.getName(node);
        this.text.append(name);
        this.text.append("\n");
        int propTabs = numTabs + 1;
        List orderedProps = this.displayHelper.getOrderedProperties(node);
        for (int i = 0; i < orderedProps.size(); ++i) {
            String propName = (String)orderedProps.get(i);
            Object propObject = node.getProperties().get(propName);
            for (int t = 0; t < propTabs; ++t) {
                this.text.append("  ");
            }
            if (propObject instanceof Collection) {
                this.printCollectionValue(propTabs, propName, propObject);
                continue;
            }
            if (propObject instanceof PlanNode) {
                this.printNodeValue(numTabs, propName, propObject);
                continue;
            }
            this.printScalarValue(node, propName);
        }
    }

    private void printScalarValue(PlanNode node, String propName) {
        this.text.append("+ ");
        this.text.append(this.displayHelper.getPropertyName(propName));
        this.text.append(": ");
        this.text.append(node.getProperties().get(propName));
        this.text.append("\n");
    }

    private void printNodeValue(int numTabs, String propName, Object propObject) {
        this.text.append("+ ");
        this.text.append(this.displayHelper.getPropertyName(propName));
        this.text.append(":\n");
        TextOutputVisitor nestedVisitor = new TextOutputVisitor(this.displayHelper, numTabs + 2);
        PlanNode nestedNode = (PlanNode)propObject;
        nestedVisitor.visit(nestedNode);
        this.text.append(nestedVisitor.getText());
    }

    private void printCollectionValue(int propTabs, String propName, Object propObject) {
        this.text.append("+ ");
        this.text.append(this.displayHelper.getPropertyName(propName));
        this.text.append(":\n");
        Collection collection = (Collection)propObject;
        Iterator collectionIter = collection.iterator();
        int v = 1;
        while (collectionIter.hasNext()) {
            Object collectionValue = collectionIter.next();
            for (int t = 0; t < propTabs + 2; ++t) {
                this.text.append("  ");
            }
            this.text.append(v);
            this.text.append(": ");
            this.text.append(collectionValue);
            this.text.append("\n");
            ++v;
        }
    }

    @Override
    protected void visitPropertyValue(PlanNode node, String propertyName, Object propertyValue) {
    }

    @Override
    protected void visitContainerProperty(PlanNode node, String propertyName, Collection propertyValue) {
    }
}

