/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.api;

import com.metamatrix.admin.api.exception.security.InvalidSessionException;
import com.metamatrix.core.CorePlugin;
import com.metamatrix.platform.security.api.MetaMatrixPrincipal;
import com.metamatrix.platform.security.api.MetaMatrixPrincipalName;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class BasicMetaMatrixPrincipal
implements MetaMatrixPrincipal,
Serializable {
    private int type;
    private String name;
    private Set unmodifiableGroupNames;

    public BasicMetaMatrixPrincipal(String name, int type, Set groupNames) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException(CorePlugin.Util.getString("ERR.014.407.0013"));
        }
        if (name.trim().length() > 1024) {
            throw new IllegalArgumentException(CorePlugin.Util.getString("ERR.014.407.0014", new Object[]{1024}));
        }
        if (type < 0 || type > 2) {
            throw new IllegalArgumentException(CorePlugin.Util.getString("ERR.014.407.0015"));
        }
        this.name = name;
        this.type = type;
        this.unmodifiableGroupNames = Collections.unmodifiableSet(groupNames);
    }

    public BasicMetaMatrixPrincipal(String name, int type) {
        this(name, type, Collections.EMPTY_SET);
    }

    protected BasicMetaMatrixPrincipal(BasicMetaMatrixPrincipal obj) {
        if (obj == null) {
            throw new IllegalArgumentException(CorePlugin.Util.getString("ERR.014.407.0016"));
        }
        this.type = obj.getType();
        this.name = obj.getName();
        this.unmodifiableGroupNames = Collections.unmodifiableSet(obj.getGroupNames());
    }

    @Override
    public MetaMatrixPrincipalName getMetaMatrixPrincipalName() {
        return new MetaMatrixPrincipalName(this.name, this.type);
    }

    @Override
    public Set getGroupNames() {
        return this.unmodifiableGroupNames;
    }

    @Override
    public boolean equals(Object par1) {
        boolean result = false;
        if (this == par1) {
            return true;
        }
        if (par1 instanceof BasicMetaMatrixPrincipal && this.type == ((BasicMetaMatrixPrincipal)par1).getType() && this.name.compareTo(((BasicMetaMatrixPrincipal)par1).getName()) == 0) {
            result = true;
        }
        return result;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public String getTypeLabel() {
        return TYPE_NAMES[this.type];
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Name=\"");
        sb.append(this.getName());
        sb.append("\", Type=");
        sb.append(TYPE_NAMES[this.type]);
        sb.append(", Groups=");
        sb.append(this.getGroupNames());
        return sb.toString();
    }

    @Override
    public Object clone() {
        return new BasicMetaMatrixPrincipal(this);
    }

    public static MetaMatrixPrincipal merge(MetaMatrixPrincipal p1, MetaMatrixPrincipal p2) throws InvalidSessionException {
        if (p1 == null || p2 == null) {
            throw new IllegalArgumentException(CorePlugin.Util.getString("ERR.014.407.0017"));
        }
        if (p1.getType() != p2.getType()) {
            throw new IllegalArgumentException(CorePlugin.Util.getString("ERR.014.407.0018", new Object[]{TYPE_NAMES[p1.getType()], TYPE_NAMES[p2.getType()]}));
        }
        if (!p1.getName().equals(p2.getName())) {
            throw new InvalidSessionException("ERR.014.407.0019", CorePlugin.Util.getString("ERR.014.407.0019", new Object[]{p1.getName(), p2.getName()}));
        }
        HashSet groups = new HashSet(p1.getGroupNames());
        groups.addAll(p2.getGroupNames());
        return new BasicMetaMatrixPrincipal(p1.getName(), p1.getType(), groups);
    }
}

