/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.api;

import com.metamatrix.platform.security.api.MetaMatrixPrincipal;
import java.io.Serializable;

public class MetaMatrixPrincipalName
implements Serializable {
    private int type;
    private String name;

    public MetaMatrixPrincipalName(String name, int type) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("illegal name " + name);
        }
        if (name.trim().length() > 1024) {
            throw new IllegalArgumentException("name too long " + name);
        }
        if (type < 0 || type > 2) {
            throw new IllegalArgumentException("invalid type " + type);
        }
        this.name = name;
        this.type = type;
    }

    protected MetaMatrixPrincipalName(MetaMatrixPrincipalName obj) {
        if (obj == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        this.type = obj.getType();
        this.name = obj.getName();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MetaMatrixPrincipalName)) {
            return false;
        }
        MetaMatrixPrincipalName that = (MetaMatrixPrincipalName)obj;
        return this.type == that.type && this.name.compareTo(that.name) == 0;
    }

    public int compareTo(Object obj) {
        MetaMatrixPrincipalName that = (MetaMatrixPrincipalName)obj;
        int comp = this.name.compareTo(that.name);
        if (comp == 0) {
            comp = this.type - that.type;
        }
        return comp;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeLabel() {
        return MetaMatrixPrincipal.TYPE_NAMES[this.type];
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[Name=\"");
        sb.append(this.getName());
        sb.append("\" - Type=\"");
        sb.append(MetaMatrixPrincipal.TYPE_NAMES[this.type]);
        sb.append("\"]");
        return sb.toString();
    }
}

