/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.api;

import com.metamatrix.platform.security.api.MetaMatrixSessionID;
import com.metamatrix.platform.security.api.SessionToken;
import java.io.Serializable;
import java.util.Properties;

public class MetaMatrixSessionInfo
implements Serializable,
Cloneable {
    public static final long serialVersionUID = -9120197553960136239L;
    private SessionToken sessionToken;
    private long lastPingTime;
    private long timeCreated;
    private long timeStateChanged;
    private String applicationName;
    private int state;
    private String product;
    private Properties productInfo;
    private String clientIp;
    private String clientHostname;
    private Serializable trustedToken;

    public MetaMatrixSessionInfo(MetaMatrixSessionID sessionID, String userName, long timeCreated, String applicationName, int state, String clusterName, Properties productInfo, String product, String clientIp, String clientHostname) {
        this.timeCreated = timeCreated;
        this.lastPingTime = timeCreated;
        this.applicationName = applicationName;
        this.state = state;
        this.product = product;
        this.sessionToken = new SessionToken(sessionID, userName);
        this.productInfo = productInfo;
        this.clientIp = clientIp;
        this.clientHostname = clientHostname;
    }

    public MetaMatrixSessionID getSessionID() {
        return this.sessionToken.getSessionID();
    }

    public String getUserName() {
        return this.sessionToken.getUsername();
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public long getTimeCreated() {
        return this.timeCreated;
    }

    public long getLastPingTime() {
        return this.lastPingTime;
    }

    public void setLastPingTime(long lastPingTime) {
        this.lastPingTime = lastPingTime;
    }

    public String getProductName() {
        return this.product;
    }

    public boolean isOpen() {
        return this.state == 1;
    }

    public SessionToken getSessionToken() {
        return this.sessionToken;
    }

    public int getState() {
        return this.state;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("MetaMatrixSessionInfo[ ");
        s.append(this.sessionToken.toString());
        s.append(", ");
        s.append("application:");
        s.append(this.applicationName);
        s.append(", state:");
        s.append(this.state);
        s.append(", created:");
        s.append(this.timeCreated);
        s.append(", state changed:");
        s.append(this.timeStateChanged);
        s.append(", last pinged server:");
        s.append(this.lastPingTime);
        s.append("]");
        return s.toString();
    }

    public String getProductInfo(String key) {
        return this.productInfo.getProperty(key);
    }

    public Properties getProductInfo() {
        return this.productInfo;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public String getClientHostname() {
        return this.clientHostname;
    }

    public void setTrustedToken(Serializable trustedToken) {
        this.trustedToken = trustedToken;
    }

    public Serializable getTrustedToken() {
        return this.trustedToken;
    }
}

