/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.server.serverapi;

import com.metamatrix.dqp.message.RequestID;
import com.metamatrix.platform.security.api.SessionToken;
import java.io.Serializable;
import java.util.Date;

public class RequestInfo
implements Serializable {
    private RequestID requestID;
    private String command;
    private SessionToken token;
    private Date submittedTimestamp;
    private Date processingTimestamp;
    private boolean isSubscription;
    private int nodeID = Integer.MIN_VALUE;
    private String connectorBindingUUID;
    private String transactionId;

    public RequestInfo(RequestID requestId, String originalCommand, Date submittedTime, Date processingTime) {
        this.requestID = requestId;
        this.command = originalCommand;
        this.submittedTimestamp = submittedTime;
        this.processingTimestamp = processingTime;
    }

    public RequestID getRequestID() {
        return this.requestID;
    }

    public SessionToken getSessionToken() {
        return this.token;
    }

    public Date getSubmittedTimestamp() {
        return this.submittedTimestamp;
    }

    public Date getProcessingTimestamp() {
        return this.processingTimestamp;
    }

    public boolean isSubscription() {
        return this.isSubscription;
    }

    public boolean isAtomicQuery() {
        return this.connectorBindingUUID != null;
    }

    public int getNodeID() {
        return this.nodeID;
    }

    public void setNodeID(int nodeID) {
        this.nodeID = nodeID;
    }

    public String getCommand() {
        return this.command;
    }

    public void setSessionToken(SessionToken token) {
        this.token = token;
    }

    public void setConnectorBindingUUID(String connBindUUID) {
        this.connectorBindingUUID = connBindUUID;
    }

    public String getConnectorBindingUUID() {
        return this.connectorBindingUUID;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RequestInfo)) {
            return false;
        }
        RequestInfo value = (RequestInfo)obj;
        if (this.connectorBindingUUID == null) {
            return this.requestID.equals(value.getRequestID());
        }
        return this.requestID.equals(value.getRequestID()) && this.connectorBindingUUID.equals(value.getConnectorBindingUUID()) && this.nodeID == value.nodeID;
    }

    public int hashCode() {
        return this.requestID.hashCode();
    }
}

