/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.serialization;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.StreamCorruptedException;
import org.jboss.netty.handler.codec.serialization.CompactObjectInputStream;

public class ObjectDecoderInputStream
extends ObjectInputStream {
    private final DataInputStream in;
    private final ClassLoader classLoader;
    private final int maxObjectSize;

    public ObjectDecoderInputStream(DataInputStream in, ClassLoader classLoader, int maxObjectSize) throws SecurityException, IOException {
        this.in = in;
        this.classLoader = classLoader;
        this.maxObjectSize = maxObjectSize;
    }

    @Override
    protected final Object readObjectOverride() throws IOException, ClassNotFoundException {
        int dataLen = this.in.readInt();
        if (dataLen <= 0) {
            throw new StreamCorruptedException("invalid data length: " + dataLen);
        }
        if (dataLen > this.maxObjectSize) {
            throw new StreamCorruptedException("data length too big: " + dataLen + " (max: " + this.maxObjectSize + ')');
        }
        return new CompactObjectInputStream(this.in, this.classLoader).readObject();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

