/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.serialization;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.jboss.netty.handler.codec.serialization.CompactObjectOutputStream;

public class ObjectEncoderOutputStream
extends ObjectOutputStream {
    private final DataOutputStream out;
    private final int estimatedLength;

    public ObjectEncoderOutputStream(DataOutputStream out, int estimatedLength) throws SecurityException, IOException {
        this.out = out;
        this.estimatedLength = estimatedLength;
    }

    @Override
    protected final void writeObjectOverride(Object obj) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(this.estimatedLength);
        CompactObjectOutputStream oout = new CompactObjectOutputStream(baos);
        oout.writeObject(obj);
        oout.flush();
        oout.close();
        this.out.writeInt(baos.size());
        this.out.write(baos.toByteArray());
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void reset() throws IOException {
    }
}

