/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.teiid.client.BatchSerializer;

public class TestBatchSerializer
extends TestCase {
    private static final String[] sampleBatchTypes = new String[]{"bigdecimal", "biginteger", "boolean", "byte", "char", "date", "double", "float", "integer", "long", "short", "string", "time", "timestamp"};

    private static void assertEqual(List[] expectedBatch, List[] batch) {
        if (expectedBatch == null) {
            TestBatchSerializer.assertNull((Object)batch);
            return;
        }
        TestBatchSerializer.assertEquals((int)expectedBatch.length, (int)batch.length);
        if (expectedBatch.length > 0) {
            int columns = expectedBatch[0].size();
            for (int row = 0; row < expectedBatch.length; ++row) {
                for (int col = 0; col < columns; ++col) {
                    TestBatchSerializer.assertEquals(expectedBatch[row].get(col), batch[row].get(col));
                }
            }
        }
    }

    private static void helpTestSerialization(String[] types, List[] batch) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(byteStream);
        BatchSerializer.writeBatch((ObjectOutput)out, (String[])types, (List[])batch);
        out.flush();
        byte[] bytes = byteStream.toByteArray();
        ByteArrayInputStream bytesIn = new ByteArrayInputStream(bytes);
        ObjectInputStream in = new ObjectInputStream(bytesIn);
        List[] newBatch = BatchSerializer.readBatch((ObjectInput)in, (String[])types);
        out.close();
        in.close();
        TestBatchSerializer.assertEqual(batch, newBatch);
    }

    private static String sampleString(int length) {
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = (char)i;
        }
        return new String(chars);
    }

    private static List[] sampleBatch(int rows) {
        List[] batch = new List[rows];
        for (int i = 0; i < rows; ++i) {
            long currentTime = System.currentTimeMillis();
            Object[] data = new Object[]{new BigDecimal("" + i), new BigInteger(Integer.toString(i)), i % 2 == 0 ? Boolean.FALSE : Boolean.TRUE, new Byte((byte)i), new Character((char)i), new Date(currentTime), new Double(i), new Float(i), new Integer(i), new Long(i), new Short((short)i), TestBatchSerializer.sampleString(i), new Time(currentTime), new Timestamp(currentTime)};
            batch[i] = Arrays.asList(data);
        }
        return batch;
    }

    private static List[] sampleBatchWithNulls(int rows) {
        List[] batch = new List[rows];
        for (int i = 0; i < rows; ++i) {
            long currentTime = System.currentTimeMillis();
            int mod = i % 14;
            Object[] objectArray = new Object[14];
            objectArray[0] = mod == 0 ? null : new BigDecimal("" + i);
            Object object = objectArray[1] = mod == 1 ? null : new BigInteger(Integer.toString(i));
            objectArray[2] = mod == 2 ? null : (i % 2 == 0 ? Boolean.FALSE : Boolean.TRUE);
            objectArray[3] = mod == 3 ? null : new Byte((byte)i);
            objectArray[4] = mod == 4 ? null : new Character((char)i);
            objectArray[5] = mod == 5 ? null : new Date(currentTime);
            objectArray[6] = mod == 6 ? null : new Double(i);
            objectArray[7] = mod == 7 ? null : new Float(i);
            objectArray[8] = mod == 8 ? null : new Integer(i);
            objectArray[9] = mod == 9 ? null : new Long(i);
            objectArray[10] = mod == 10 ? null : new Short((short)i);
            objectArray[11] = mod == 11 ? null : TestBatchSerializer.sampleString(i);
            objectArray[12] = mod == 12 ? null : new Time(currentTime);
            objectArray[13] = mod == 13 ? null : new Timestamp(currentTime);
            Object[] data = objectArray;
            batch[i] = Arrays.asList(data);
        }
        return batch;
    }

    public void testSerializeBasicTypes() throws Exception {
        TestBatchSerializer.helpTestSerialization(sampleBatchTypes, TestBatchSerializer.sampleBatch(1));
        TestBatchSerializer.helpTestSerialization(sampleBatchTypes, TestBatchSerializer.sampleBatch(8));
        TestBatchSerializer.helpTestSerialization(sampleBatchTypes, TestBatchSerializer.sampleBatch(17));
        TestBatchSerializer.helpTestSerialization(sampleBatchTypes, TestBatchSerializer.sampleBatch(120));
        TestBatchSerializer.helpTestSerialization(sampleBatchTypes, TestBatchSerializer.sampleBatch(833));
    }

    public void testSerializeBasicTypes_NoTypeHints() throws Exception {
        TestBatchSerializer.helpTestSerialization(null, TestBatchSerializer.sampleBatch(1));
        TestBatchSerializer.helpTestSerialization(null, TestBatchSerializer.sampleBatch(8));
        TestBatchSerializer.helpTestSerialization(null, TestBatchSerializer.sampleBatch(17));
        TestBatchSerializer.helpTestSerialization(null, TestBatchSerializer.sampleBatch(120));
        TestBatchSerializer.helpTestSerialization(null, TestBatchSerializer.sampleBatch(833));
    }

    public void testSerializeBasicTypesWithNulls() throws Exception {
        TestBatchSerializer.helpTestSerialization(sampleBatchTypes, TestBatchSerializer.sampleBatchWithNulls(1));
        TestBatchSerializer.helpTestSerialization(sampleBatchTypes, TestBatchSerializer.sampleBatchWithNulls(8));
        TestBatchSerializer.helpTestSerialization(sampleBatchTypes, TestBatchSerializer.sampleBatchWithNulls(17));
        TestBatchSerializer.helpTestSerialization(sampleBatchTypes, TestBatchSerializer.sampleBatchWithNulls(120));
        TestBatchSerializer.helpTestSerialization(sampleBatchTypes, TestBatchSerializer.sampleBatchWithNulls(833));
    }

    public void testSerializeLargeStrings() throws Exception {
        List<Object> row = Arrays.asList(TestBatchSerializer.sampleString(66666));
        TestBatchSerializer.helpTestSerialization(new String[]{"string"}, new List[]{row});
    }

    public void testSerializeNoData() throws Exception {
        TestBatchSerializer.helpTestSerialization(sampleBatchTypes, null);
        TestBatchSerializer.helpTestSerialization(null, null);
        TestBatchSerializer.helpTestSerialization(sampleBatchTypes, new List[0]);
        TestBatchSerializer.helpTestSerialization(null, new List[0]);
    }

    public void testSerializeDatatypeMismatch() throws Exception {
        try {
            TestBatchSerializer.helpTestSerialization(new String[]{"double"}, new List[]{Arrays.asList("Hello!")});
        }
        catch (IOException e) {
            TestBatchSerializer.assertEquals((String)"The modeled datatype double for column 0 doesn't match the runtime type \"java.lang.String\". Please ensure that the column's modeled datatype matches the expected data.", (String)e.getMessage());
        }
    }
}

