/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.jdbc.BatchResults;

public class TestBatchResults {
    private static List[] createBatch(int begin, int end) {
        List[] results = new List[end - begin + 1];
        for (int i = 0; i < end - begin + 1; ++i) {
            results[i] = new ArrayList();
            results[i].add(new Integer(i + begin));
        }
        return results;
    }

    private List[] createEmptyBatch() {
        List[] results = new List[]{};
        return results;
    }

    @Test
    public void testGetCurrentRow1() throws Exception {
        BatchResults batchResults = new BatchResults(this.createEmptyBatch(), 0, 0, true);
        Assert.assertNull((Object)batchResults.getCurrentRow());
        batchResults.next();
        Assert.assertNull((Object)batchResults.getCurrentRow());
    }

    @Test
    public void testGetCurrentRow2() throws Exception {
        BatchResults batchResults = new BatchResults(TestBatchResults.createBatch(1, 10), 1, 10, true);
        Assert.assertNull((Object)batchResults.getCurrentRow());
        batchResults.next();
        ArrayList<Integer> expectedResult = new ArrayList<Integer>();
        expectedResult.add(new Integer(1));
        Assert.assertEquals((Object)batchResults.getCurrentRow(), expectedResult);
    }

    @Test
    public void testHasNext1() throws Exception {
        BatchResults batchResults = new BatchResults(this.createEmptyBatch(), 0, 0, true);
        Assert.assertFalse((boolean)batchResults.hasNext());
    }

    @Test
    public void testHasNext2() throws Exception {
        BatchResults batchResults = new BatchResults(TestBatchResults.createBatch(1, 1), 1, 1, true);
        Assert.assertTrue((boolean)batchResults.hasNext());
    }

    @Test
    public void testHasNext3() throws Exception {
        BatchResults batchResults = new BatchResults(TestBatchResults.createBatch(1, 10), 1, 10, true);
        Assert.assertTrue((boolean)batchResults.hasNext());
    }

    @Test
    public void testNext1() throws Exception {
        BatchResults batchResults = new BatchResults(this.createEmptyBatch(), 0, 0, true);
        Assert.assertFalse((boolean)batchResults.next());
    }

    @Test
    public void testNext2() throws Exception {
        BatchResults batchResults = new BatchResults(TestBatchResults.createBatch(1, 1), 1, 1, true);
        Assert.assertTrue((boolean)batchResults.next());
        ArrayList<Integer> expectedResult = new ArrayList<Integer>();
        expectedResult.add(new Integer(1));
        Assert.assertEquals((Object)batchResults.getCurrentRow(), expectedResult);
        Assert.assertFalse((boolean)batchResults.next());
    }

    @Test
    public void testNext3() throws Exception {
        BatchResults batchResults = new BatchResults(TestBatchResults.createBatch(1, 1), 1, 1, false);
        batchResults.setBatchFetcher((BatchResults.BatchFetcher)new MockBatchFetcher());
        Assert.assertTrue((boolean)batchResults.next());
        Assert.assertTrue((boolean)batchResults.next());
        ArrayList<Integer> expectedResult = new ArrayList<Integer>();
        expectedResult.add(new Integer(2));
        Assert.assertEquals((Object)batchResults.getCurrentRow(), expectedResult);
    }

    @Test
    public void testNext4() throws Exception {
        ArrayList<Integer> expectedResult;
        int i;
        BatchResults batchResults = new BatchResults(TestBatchResults.createBatch(1, 10), 1, 10, false);
        batchResults.setBatchFetcher((BatchResults.BatchFetcher)new MockBatchFetcher());
        for (i = 0; i < 10; ++i) {
            Assert.assertTrue((boolean)batchResults.next());
            expectedResult = new ArrayList<Integer>();
            expectedResult.add(new Integer(i + 1));
            Assert.assertEquals((Object)batchResults.getCurrentRow(), expectedResult);
        }
        while (batchResults.next()) {
            expectedResult = new ArrayList();
            expectedResult.add(new Integer(i++ + 1));
            Assert.assertEquals((Object)batchResults.getCurrentRow(), expectedResult);
        }
        Assert.assertFalse((boolean)batchResults.next());
    }

    @Test
    public void testHasPrevious1() throws Exception {
        BatchResults batchResults = new BatchResults(this.createEmptyBatch(), 0, 0, true);
        Assert.assertFalse((boolean)batchResults.hasPrevious());
    }

    @Test
    public void testHasPrevious2() throws Exception {
        BatchResults batchResults = new BatchResults(TestBatchResults.createBatch(1, 1), 1, 1, true);
        Assert.assertFalse((boolean)batchResults.hasPrevious());
        batchResults.next();
        Assert.assertFalse((boolean)batchResults.hasPrevious());
        batchResults.next();
        Assert.assertTrue((boolean)batchResults.hasPrevious());
    }

    @Test
    public void testPrevious1() throws Exception {
        BatchResults batchResults = new BatchResults(this.createEmptyBatch(), 0, 0, true);
        Assert.assertFalse((boolean)batchResults.previous());
    }

    @Test
    public void testPrevious2() throws Exception {
        BatchResults batchResults = new BatchResults(TestBatchResults.createBatch(1, 1), 1, 1, true);
        Assert.assertTrue((boolean)batchResults.next());
        Assert.assertFalse((boolean)batchResults.previous());
        ArrayList<Integer> expectedResult = new ArrayList<Integer>();
        expectedResult.add(new Integer(1));
        while (batchResults.next()) {
        }
        Assert.assertTrue((boolean)batchResults.previous());
        Assert.assertEquals((Object)batchResults.getCurrentRow(), expectedResult);
    }

    @Test
    public void testPrevious3() throws Exception {
        BatchResults batchResults = new BatchResults(TestBatchResults.createBatch(1, 1), 1, 1, false);
        batchResults.setBatchFetcher((BatchResults.BatchFetcher)new MockBatchFetcher());
        Assert.assertFalse((boolean)batchResults.previous());
        Assert.assertTrue((boolean)batchResults.next());
        Assert.assertFalse((boolean)batchResults.previous());
        while (batchResults.next()) {
        }
        Assert.assertTrue((boolean)batchResults.previous());
        while (batchResults.previous()) {
        }
        batchResults.next();
        batchResults.next();
        batchResults.next();
        batchResults.previous();
        ArrayList<Integer> expectedResult = new ArrayList<Integer>();
        expectedResult.add(new Integer(2));
        Assert.assertEquals((Object)batchResults.getCurrentRow(), expectedResult);
    }

    @Test
    public void testPrevious4() throws Exception {
        int i;
        BatchResults batchResults = new BatchResults(TestBatchResults.createBatch(1, 10), 1, 10, false);
        batchResults.setBatchFetcher((BatchResults.BatchFetcher)new MockBatchFetcher());
        for (i = 0; i <= 10; ++i) {
            Assert.assertTrue((boolean)batchResults.next());
        }
        for (i = 10; i > 0; --i) {
            batchResults.previous();
            ArrayList<Integer> expectedResult = new ArrayList<Integer>();
            expectedResult.add(new Integer(i));
            Assert.assertEquals((Object)batchResults.getCurrentRow(), expectedResult);
        }
    }

    @Test
    public void testAbsolute1() throws Exception {
        BatchResults batchResults = new BatchResults(this.createEmptyBatch(), 0, 0, true);
        Assert.assertFalse((boolean)batchResults.absolute(0));
        Assert.assertFalse((boolean)batchResults.absolute(1));
    }

    @Test
    public void testAbsolute2() throws Exception {
        BatchResults batchResults = new BatchResults(TestBatchResults.createBatch(1, 1), 1, 1, true);
        batchResults.setBatchFetcher((BatchResults.BatchFetcher)new MockBatchFetcher());
        Assert.assertFalse((boolean)batchResults.absolute(0));
        Assert.assertTrue((boolean)batchResults.absolute(1));
        Assert.assertTrue((boolean)batchResults.absolute(1));
        ArrayList<Integer> expectedResult = new ArrayList<Integer>();
        expectedResult.add(new Integer(1));
        Assert.assertEquals((Object)batchResults.getCurrentRow(), expectedResult);
    }

    @Test
    public void testAbsolute3() throws Exception {
        BatchResults batchResults = new BatchResults(TestBatchResults.createBatch(1, 10), 1, 10, false);
        batchResults.setBatchFetcher((BatchResults.BatchFetcher)new MockBatchFetcher(200));
        Assert.assertFalse((boolean)batchResults.absolute(0));
        Assert.assertTrue((boolean)batchResults.absolute(11));
        ArrayList<Integer> expectedResult = new ArrayList<Integer>();
        expectedResult.add(new Integer(11));
        Assert.assertEquals((Object)batchResults.getCurrentRow(), expectedResult);
        Assert.assertTrue((boolean)batchResults.absolute(1));
        expectedResult = new ArrayList();
        expectedResult.add(new Integer(1));
        Assert.assertEquals((Object)batchResults.getCurrentRow(), expectedResult);
        Assert.assertTrue((boolean)batchResults.absolute(100));
        expectedResult = new ArrayList();
        expectedResult.add(new Integer(100));
        Assert.assertEquals((Object)batchResults.getCurrentRow(), expectedResult);
    }

    @Test
    public void testAbsolute4() throws Exception {
        BatchResults batchResults = new BatchResults(TestBatchResults.createBatch(1, 1), 1, 1, false);
        batchResults.setBatchFetcher((BatchResults.BatchFetcher)new MockBatchFetcher());
        Assert.assertTrue((boolean)batchResults.absolute(10));
        Assert.assertTrue((boolean)batchResults.absolute(2));
        ArrayList<Integer> expectedResult = new ArrayList<Integer>();
        expectedResult.add(new Integer(2));
        Assert.assertEquals((Object)batchResults.getCurrentRow(), expectedResult);
    }

    @Test
    public void testAbsolute5() throws Exception {
        BatchResults batchResults = new BatchResults(TestBatchResults.createBatch(1, 1), 1, 1, false);
        batchResults.setBatchFetcher((BatchResults.BatchFetcher)new MockBatchFetcher());
        Assert.assertTrue((boolean)batchResults.absolute(-1));
        ArrayList<Integer> expectedResult = new ArrayList<Integer>();
        expectedResult.add(new Integer(50));
        Assert.assertEquals((Object)batchResults.getCurrentRow(), expectedResult);
        Assert.assertFalse((boolean)batchResults.absolute(-100));
    }

    @Test
    public void testCurrentRowNumber() throws Exception {
        BatchResults batchResults = new BatchResults(TestBatchResults.createBatch(1, 1), 1, 1, true);
        Assert.assertEquals((long)0L, (long)batchResults.getCurrentRowNumber());
        batchResults.next();
        Assert.assertEquals((long)1L, (long)batchResults.getCurrentRowNumber());
        batchResults.next();
        Assert.assertEquals((long)2L, (long)batchResults.getCurrentRowNumber());
        Assert.assertFalse((boolean)batchResults.next());
        Assert.assertEquals((long)2L, (long)batchResults.getCurrentRowNumber());
    }

    @Test
    public void testSetException() throws Exception {
        BatchResults batchResults = new BatchResults(TestBatchResults.createBatch(1, 1), 1, 1, false);
        MockBatchFetcher batchFetcher = new MockBatchFetcher();
        batchResults.setBatchFetcher((BatchResults.BatchFetcher)batchFetcher);
        batchFetcher.throwException();
        batchResults.next();
        try {
            batchResults.hasNext();
            Assert.fail((String)"Expected exception, but did not get.");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Test
    public void testBatching() throws Exception {
        int i;
        BatchResults batchResults = new BatchResults(TestBatchResults.createBatch(1, 10), 1, 10, false);
        MockBatchFetcher batchFetcher = new MockBatchFetcher(60);
        batchResults.setBatchFetcher((BatchResults.BatchFetcher)batchFetcher);
        for (i = 0; i < 45; ++i) {
            Assert.assertTrue((boolean)batchResults.next());
        }
        for (i = 0; i < 44; ++i) {
            Assert.assertTrue((boolean)batchResults.previous());
            Assert.assertEquals((Object)new Integer(44 - i), batchResults.getCurrentRow().get(0));
        }
        this.checkResults(new int[]{11, 21, 31, 41, 20, 10}, batchFetcher.batchCalls);
        Assert.assertTrue((boolean)batchResults.absolute(50));
        Assert.assertEquals((Object)new Integer(50), batchResults.getCurrentRow().get(0));
    }

    private void checkResults(int[] expectedCalls, List<Integer> batchCalls) {
        Assert.assertEquals((long)expectedCalls.length, (long)batchCalls.size());
        for (int i = 0; i < batchCalls.size(); ++i) {
            int range = batchCalls.get(i);
            int expected = expectedCalls[i];
            Assert.assertEquals((String)("On call " + i + " expected different begin"), (long)expected, (long)range);
        }
    }

    static class MockBatchFetcher
    implements BatchResults.BatchFetcher {
        private int totalRows = 50;
        private boolean throwException;
        List<Integer> batchCalls = new ArrayList<Integer>();

        public MockBatchFetcher() {
        }

        public MockBatchFetcher(int totalRows) {
            this.totalRows = totalRows;
        }

        public BatchResults.Batch requestBatch(int beginRow) throws SQLException {
            this.batchCalls.add(beginRow);
            if (this.throwException) {
                throw new SQLException();
            }
            boolean isLast = false;
            int endRow = beginRow + 9;
            if (beginRow % 10 == 0) {
                endRow = beginRow - 9;
            }
            if (beginRow > endRow) {
                if (endRow < 1) {
                    endRow = 1;
                }
                int i = beginRow;
                beginRow = endRow;
                endRow = i;
            } else if (endRow > this.totalRows) {
                endRow = this.totalRows;
                isLast = true;
            }
            return new BatchResults.Batch(TestBatchResults.createBatch(beginRow, endRow), beginRow, endRow, isLast);
        }

        public void throwException() {
            this.throwException = true;
        }
    }
}

