/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.teiid.client.DQP;
import org.teiid.client.RequestMessage;
import org.teiid.client.ResultsMessage;
import org.teiid.client.security.LogonResult;
import org.teiid.client.util.ResultsFuture;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.PreparedStatementImpl;
import org.teiid.jdbc.TeiidSQLException;
import org.teiid.net.ServerConnection;

public class TestPreparedStatement {
    @Test(expected=TeiidSQLException.class)
    public void testUpdateException() throws Exception {
        PreparedStatementImpl statement = this.getMMPreparedStatement("delete from table");
        statement.execute();
    }

    @Test
    public void testBatchedUpdateExecution() throws Exception {
        ConnectionImpl conn = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        DQP dqp = (DQP)Mockito.mock(DQP.class);
        ServerConnection serverConn = (ServerConnection)Mockito.mock(ServerConnection.class);
        LogonResult logonResult = (LogonResult)Mockito.mock(LogonResult.class);
        Mockito.stub((Object)conn.getServerConnection()).toReturn((Object)serverConn);
        Mockito.stub((Object)serverConn.getLogonResult()).toReturn((Object)logonResult);
        Mockito.stub((Object)logonResult.getTimeZone()).toReturn((Object)TimeZone.getDefault());
        ResultsFuture results = new ResultsFuture();
        Mockito.stub((Object)dqp.executeRequest(Matchers.anyLong(), (RequestMessage)Matchers.anyObject())).toReturn((Object)results);
        ResultsMessage rm = new ResultsMessage();
        rm.setResults(new List[]{Arrays.asList(0), Arrays.asList(0), Arrays.asList(0)});
        rm.setUpdateResult(true);
        results.getResultsReceiver().receiveResults((Object)rm);
        Mockito.stub((Object)conn.getDQP()).toReturn((Object)dqp);
        String sqlCommand = "delete from table where col=?";
        TestableMMPreparedStatement statement = (TestableMMPreparedStatement)this.getMMPreparedStatement(conn, sqlCommand);
        ArrayList<ArrayList<Object>> expectedParameterValues = new ArrayList<ArrayList<Object>>(3);
        expectedParameterValues.add(new ArrayList<Object>(Arrays.asList(new Integer(1))));
        statement.setInt(1, new Integer(1));
        statement.addBatch();
        expectedParameterValues.add(new ArrayList<Object>(Arrays.asList(new Integer(2))));
        statement.setInt(1, new Integer(2));
        statement.addBatch();
        expectedParameterValues.add(new ArrayList<Object>(Arrays.asList(new Integer(3))));
        statement.setInt(1, new Integer(3));
        statement.addBatch();
        Assert.assertTrue((boolean)Arrays.equals(new int[]{0, 0, 0}, statement.executeBatch()));
        Assert.assertEquals((String)"Command does not match", (Object)sqlCommand, (Object)statement.requestMessage.getCommandString());
        Assert.assertEquals((String)"Parameter values do not match", expectedParameterValues, (Object)statement.requestMessage.getParameterValues());
        Assert.assertTrue((String)"RequestMessage.isBatchedUpdate should be true", (boolean)statement.requestMessage.isBatchedUpdate());
        Assert.assertFalse((String)"RequestMessage.isCallableStatement should be false", (boolean)statement.requestMessage.isCallableStatement());
        Assert.assertTrue((String)"RequestMessage.isPreparedStatement should be true", (boolean)statement.requestMessage.isPreparedStatement());
    }

    @Test
    public void testClearBatch() throws Exception {
        PreparedStatementImpl statement = this.getMMPreparedStatement("delete from table where col=?");
        statement.setInt(1, new Integer(1).intValue());
        statement.addBatch();
        statement.setInt(1, new Integer(2).intValue());
        statement.addBatch();
        Assert.assertTrue((String)"MMPreparedStatement.ParameterValuesList should not be empty", (statement.getParameterValuesList().size() > 0 ? 1 : 0) != 0);
        statement.clearBatch();
        Assert.assertTrue((String)"MMPreparedStatement.ParameterValuesList should be empty", (statement.getParameterValuesList().size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testClearBatchAddBatch() throws Exception {
        PreparedStatementImpl statement = this.getMMPreparedStatement("delete from table where col=?");
        statement.setInt(1, new Integer(1).intValue());
        statement.addBatch();
        statement.setInt(1, new Integer(2).intValue());
        statement.addBatch();
        Assert.assertTrue((String)"MMPreparedStatement.ParameterValuesList should not be empty", (statement.getParameterValuesList().size() > 0 ? 1 : 0) != 0);
        statement.clearBatch();
        Assert.assertTrue((String)"MMPreparedStatement.ParameterValuesList should be empty", (statement.getParameterValuesList().size() == 0 ? 1 : 0) != 0);
        ArrayList<ArrayList<Object>> expectedParameterValues = new ArrayList<ArrayList<Object>>(1);
        expectedParameterValues.add(new ArrayList<Object>(Arrays.asList(new Integer(5))));
        statement.setInt(1, new Integer(5).intValue());
        statement.addBatch();
        Assert.assertEquals((String)"MMPreparedStatement.ParameterValuesList does not match", expectedParameterValues, (Object)statement.getParameterValuesList());
    }

    @Test
    public void testAddBatch() throws Exception {
        PreparedStatementImpl statement = this.getMMPreparedStatement("delete from table where col=?");
        ArrayList<ArrayList<Object>> expectedParameterValues = new ArrayList<ArrayList<Object>>(1);
        expectedParameterValues.add(new ArrayList<Object>(Arrays.asList(new Integer(1))));
        statement.setInt(1, new Integer(1).intValue());
        statement.addBatch();
        Assert.assertEquals((String)"MMPreparedStatement.ParameterValuesList does not match", expectedParameterValues, (Object)statement.getParameterValuesList());
        expectedParameterValues.add(new ArrayList<Object>(Arrays.asList(new Integer(3))));
        expectedParameterValues.add(new ArrayList<Object>(Arrays.asList(new Integer(5))));
        statement.setInt(1, new Integer(3).intValue());
        statement.addBatch();
        statement.setInt(1, new Integer(5).intValue());
        statement.addBatch();
        Assert.assertEquals((String)"MMPreparedStatement.ParameterValuesList does not match", expectedParameterValues, (Object)statement.getParameterValuesList());
    }

    @Test
    public void testAddBatchNoParameterValues() throws Exception {
        PreparedStatementImpl statement = this.getMMPreparedStatement("delete from table where col=?");
        ArrayList<ArrayList<Object>> expectedParameterValues = new ArrayList<ArrayList<Object>>(1);
        expectedParameterValues.add(new ArrayList(Collections.emptyList()));
        statement.addBatch();
        expectedParameterValues.add(new ArrayList<Object>(Arrays.asList(new Integer(1))));
        statement.setInt(1, new Integer(1).intValue());
        statement.addBatch();
        Assert.assertEquals((String)"MMPreparedStatement.ParameterValuesList does not match", expectedParameterValues, (Object)statement.getParameterValuesList());
    }

    protected PreparedStatementImpl getMMPreparedStatement(String sql) throws SQLException {
        ConnectionImpl conn = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        ServerConnection serverConn = (ServerConnection)Mockito.mock(ServerConnection.class);
        LogonResult logonResult = (LogonResult)Mockito.mock(LogonResult.class);
        Mockito.stub((Object)conn.getServerConnection()).toReturn((Object)serverConn);
        Mockito.stub((Object)serverConn.getLogonResult()).toReturn((Object)logonResult);
        Mockito.stub((Object)logonResult.getTimeZone()).toReturn((Object)TimeZone.getDefault());
        return this.getMMPreparedStatement(conn, sql);
    }

    protected PreparedStatementImpl getMMPreparedStatement(ConnectionImpl conn, String sql) throws SQLException {
        TestableMMPreparedStatement statement = new TestableMMPreparedStatement(conn, sql, 1003, 1007);
        Assert.assertTrue((String)"MMPreparedStatement.ParameterValuesList should be empty", (statement.getParameterValuesList().size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"MMPreparedStatement.ParameterValues should be empty", (statement.getParameterValues().size() == 0 ? 1 : 0) != 0);
        return statement;
    }

    class TestableMMPreparedStatement
    extends PreparedStatementImpl {
        public RequestMessage requestMessage;

        protected RequestMessage createRequestMessage(String[] commands, boolean isBatchedCommand, RequestMessage.ResultsMode resultsMode) {
            this.requestMessage = super.createRequestMessage(commands, isBatchedCommand, resultsMode);
            return this.requestMessage;
        }

        public TestableMMPreparedStatement(ConnectionImpl connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            super(connection, sql, resultSetType, resultSetConcurrency);
        }
    }
}

