/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.net.socket;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;
import org.mockito.Mockito;
import org.teiid.adminapi.Admin;
import org.teiid.adminapi.ProcessObject;
import org.teiid.client.security.LogonResult;
import org.teiid.net.HostInfo;
import org.teiid.net.TeiidURL;
import org.teiid.net.socket.AdminApiServerDiscovery;
import org.teiid.net.socket.SocketServerInstance;

public class TestAdminApiServerDiscovery
extends TestCase {
    public void testFirewallHost() throws Exception {
        AdminApiServerDiscovery discovery = new AdminApiServerDiscovery();
        Properties p = new Properties();
        p.setProperty("AdminApiServerDiscovery.useUrlHost", Boolean.TRUE.toString());
        TeiidURL mmurl = new TeiidURL("foo", 1, false);
        discovery.init(mmurl, p);
        HostInfo knownHost = (HostInfo)mmurl.getHostInfo().get(0);
        TestAdminApiServerDiscovery.assertEquals((int)1, (int)discovery.getKnownHosts(null, null).size());
        SocketServerInstance instance = (SocketServerInstance)Mockito.mock(SocketServerInstance.class);
        Admin serverAdmin = (Admin)Mockito.mock(Admin.class);
        ArrayList<ProcessObject> processes = new ArrayList<ProcessObject>();
        ProcessObject p1 = (ProcessObject)Mockito.mock(ProcessObject.class);
        Mockito.stub((Object)p1.getPort()).toReturn((Object)5);
        processes.add(p1);
        ProcessObject p2 = (ProcessObject)Mockito.mock(ProcessObject.class);
        Mockito.stub((Object)p2.isEnabled()).toReturn((Object)true);
        Mockito.stub((Object)p2.isRunning()).toReturn((Object)true);
        Mockito.stub((Object)p2.getPort()).toReturn((Object)6);
        Mockito.stub((Object)p2.getInetAddress()).toReturn((Object)InetAddress.getByName("0.0.0.0"));
        processes.add(p2);
        Mockito.stub((Object)serverAdmin.getProcesses("*")).toReturn(processes);
        Mockito.stub((Object)instance.getService(Admin.class)).toReturn((Object)serverAdmin);
        Mockito.stub((Object)instance.getHostInfo()).toReturn((Object)knownHost);
        discovery.connectionSuccessful(knownHost);
        List knownHosts = discovery.getKnownHosts(new LogonResult(), instance);
        TestAdminApiServerDiscovery.assertEquals((int)1, (int)knownHosts.size());
        HostInfo h = (HostInfo)knownHosts.get(0);
        TestAdminApiServerDiscovery.assertEquals((String)"foo", (String)h.getHostName());
        TestAdminApiServerDiscovery.assertEquals((int)6, (int)h.getPortNumber());
    }
}

