/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.net.socket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Properties;
import junit.framework.TestCase;
import org.mockito.Mockito;
import org.teiid.client.security.ILogon;
import org.teiid.client.security.InvalidSessionException;
import org.teiid.client.security.LogonException;
import org.teiid.client.security.LogonResult;
import org.teiid.client.security.SessionToken;
import org.teiid.client.util.ResultsFuture;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.crypto.NullCryptor;
import org.teiid.net.CommunicationException;
import org.teiid.net.ConnectionException;
import org.teiid.net.HostInfo;
import org.teiid.net.ServerConnection;
import org.teiid.net.TeiidURL;
import org.teiid.net.socket.ServerDiscovery;
import org.teiid.net.socket.SingleInstanceCommunicationException;
import org.teiid.net.socket.SocketServerConnection;
import org.teiid.net.socket.SocketServerConnectionFactory;
import org.teiid.net.socket.SocketServerInstance;
import org.teiid.net.socket.SocketServerInstanceFactory;
import org.teiid.net.socket.UrlServerDiscovery;

public class TestSocketServerConnection
extends TestCase {
    public void testSocketServerConnection_PropertiesClientHost() throws Throwable {
        Properties p = new Properties();
        SocketServerConnectionFactory.updateConnectionProperties((Properties)p);
        TestSocketServerConnection.assertTrue((boolean)p.containsKey("clientHostName"));
        TestSocketServerConnection.assertTrue((boolean)p.containsKey("clientIpAddress"));
    }

    public void testLogonFailsWithMultipleHosts() throws Exception {
        Properties p = new Properties();
        SocketServerInstanceFactory instanceFactory = new SocketServerInstanceFactory(){

            public SocketServerInstance getServerInstance(HostInfo info, boolean ssl) throws CommunicationException, IOException {
                throw new SingleInstanceCommunicationException();
            }
        };
        UrlServerDiscovery discovery = new UrlServerDiscovery(new TeiidURL("mm://host1:1,host2:2"));
        try {
            new SocketServerConnection(instanceFactory, false, (ServerDiscovery)discovery, p, null);
            TestSocketServerConnection.fail((String)"exception expected");
        }
        catch (CommunicationException e) {
            TestSocketServerConnection.assertEquals((String)"No valid host available. Attempted connections to: [host1:1, host2:2]", (String)e.getMessage());
        }
    }

    public void testLogon() throws Exception {
        SocketServerConnection connection = this.createConnection(null);
        TestSocketServerConnection.assertEquals((String)String.valueOf(1), (String)connection.getLogonResult().getSessionID());
    }

    public void testRetry() throws Exception {
        SocketServerConnection connection = this.createConnection((Throwable)new SingleInstanceCommunicationException());
        connection.setFailOver(true);
        ILogon logon = (ILogon)connection.getService(ILogon.class);
        logon.ping();
    }

    public void testImmediateFail() throws Exception {
        SocketServerConnection connection = this.createConnection(new CommunicationException());
        ILogon logon = (ILogon)connection.getService(ILogon.class);
        try {
            logon.ping();
            TestSocketServerConnection.fail((String)"expected exception");
        }
        catch (TeiidComponentException teiidComponentException) {
            // empty catch block
        }
    }

    public void testImmediateFail1() throws Exception {
        SocketServerConnection connection = this.createConnection(new CommunicationException());
        connection.setFailOver(true);
        ILogon logon = (ILogon)connection.getService(ILogon.class);
        try {
            logon.ping();
            TestSocketServerConnection.fail((String)"expected exception");
        }
        catch (TeiidComponentException teiidComponentException) {
            // empty catch block
        }
    }

    private SocketServerConnection createConnection(Throwable throwException) throws CommunicationException, ConnectionException {
        return this.createConnection(throwException, new HostInfo("0.0.0.2", 1));
    }

    private SocketServerConnection createConnection(final Throwable t, HostInfo hostInfo) throws CommunicationException, ConnectionException {
        Properties p = new Properties();
        UrlServerDiscovery discovery = new UrlServerDiscovery(new TeiidURL(hostInfo.getHostName(), hostInfo.getPortNumber(), false));
        SocketServerInstanceFactory instanceFactory = new SocketServerInstanceFactory(){

            public SocketServerInstance getServerInstance(HostInfo info, boolean ssl) throws CommunicationException, IOException {
                SocketServerInstance instance = (SocketServerInstance)Mockito.mock(SocketServerInstance.class);
                Mockito.stub((Object)instance.getCryptor()).toReturn((Object)new NullCryptor());
                Mockito.stub((Object)instance.getRemoteAddress()).toReturn((Object)new InetSocketAddress(info.getInetAddress(), info.getPortNumber()));
                FakeILogon logon = new FakeILogon();
                logon.t = t;
                Mockito.stub((Object)instance.getService(ILogon.class)).toReturn((Object)logon);
                Mockito.stub((Object)instance.isOpen()).toReturn((Object)true);
                return instance;
            }
        };
        SocketServerConnection connection = new SocketServerConnection(instanceFactory, false, (ServerDiscovery)discovery, p, null);
        return connection;
    }

    public void testIsSameInstance() throws Exception {
        SocketServerConnection conn = this.createConnection(null, new HostInfo("0.0.0.0", 1));
        SocketServerConnection conn1 = this.createConnection(null, new HostInfo("0.0.0.1", 1));
        TestSocketServerConnection.assertFalse((boolean)conn.isSameInstance((ServerConnection)conn1));
        TestSocketServerConnection.assertTrue((boolean)conn.isSameInstance((ServerConnection)conn));
    }

    private static final class FakeILogon
    implements ILogon {
        Throwable t;

        private FakeILogon() {
        }

        public void assertIdentity(SessionToken sessionId) throws InvalidSessionException, TeiidComponentException {
        }

        public ResultsFuture<?> logoff() throws InvalidSessionException {
            return null;
        }

        public LogonResult logon(Properties connectionProperties) throws LogonException, TeiidComponentException {
            return new LogonResult(new SessionToken(1L, "fooUser"), "foo", 1, "fake");
        }

        public ResultsFuture<?> ping() throws InvalidSessionException, TeiidComponentException {
            if (this.t != null) {
                TeiidComponentException e = new TeiidComponentException(this.t);
                this.t = null;
                throw e;
            }
            return null;
        }
    }
}

