/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.netty.handler.codec.serialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.netty.handler.codec.serialization.ObjectDecoderInputStream;
import org.teiid.netty.handler.codec.serialization.ObjectEncoderOutputStream;

public class TestObjectDecoderInputStream {
    @Test
    public void testTimeoutException() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectEncoderOutputStream oeos = new ObjectEncoderOutputStream(new DataOutputStream(baos), 512);
        List<Integer> obj = Arrays.asList(1, 2, 3);
        oeos.writeObject(obj);
        oeos.close();
        final ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        InputStream is = new InputStream(){
            int count;

            @Override
            public int read() throws IOException {
                if (this.count++ % 2 == 0) {
                    throw new SocketTimeoutException();
                }
                return bais.read();
            }
        };
        ObjectDecoderInputStream odis = new ObjectDecoderInputStream((InputStream)new DataInputStream(is), Thread.currentThread().getContextClassLoader(), 1024);
        Object result = null;
        do {
            try {
                result = odis.readObject();
            }
            catch (IOException e) {
                // empty catch block
            }
        } while (result == null);
        Assert.assertEquals(obj, (Object)result);
    }

    @Test
    public void testLargeIntConversion() throws Exception {
        int testValue = 204503404;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeInt(testValue);
        dos.close();
        Assert.assertEquals((long)testValue, (long)ObjectDecoderInputStream.getIntFromBytes((byte[])baos.toByteArray()));
    }
}

