/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.adminapi.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.teiid.adminapi.AdminObject;
import org.teiid.adminapi.impl.KeyBuilder;
import org.teiid.adminapi.impl.ListOverMap;
import org.teiid.adminapi.impl.PropertyMetadata;

@XmlAccessorType(value=XmlAccessType.NONE)
public abstract class AdminObjectImpl
implements AdminObject,
Serializable {
    private static final long serialVersionUID = -6381303538713462682L;
    private String name;
    private ListOverMap<PropertyMetadata> properties = new ListOverMap<PropertyMetadata>(new KeyBuilder<PropertyMetadata>(){
        private static final long serialVersionUID = 3687928367250819142L;

        @Override
        public String getKey(PropertyMetadata entry) {
            return entry.getName();
        }
    });
    private transient Map<String, Object> attachments = Collections.synchronizedMap(new HashMap());

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Properties getProperties() {
        Properties props = new Properties();
        for (PropertyMetadata p : this.properties.getMap().values()) {
            props.setProperty(p.getName(), p.getValue());
        }
        return props;
    }

    public void setProperties(Properties props) {
        this.properties.clear();
        if (props != null) {
            for (String key : props.stringPropertyNames()) {
                this.addProperty(key, props.getProperty(key));
            }
        }
    }

    public List<PropertyMetadata> getJAXBProperties() {
        return this.properties;
    }

    public void setJAXBProperties(List<PropertyMetadata> props) {
        this.properties.clear();
        if (props != null) {
            for (PropertyMetadata prop : props) {
                this.addProperty(prop.getName(), prop.getValue());
            }
        }
    }

    @Override
    public String getPropertyValue(String name) {
        PropertyMetadata prop = this.properties.getMap().get(name);
        if (prop == null) {
            return null;
        }
        return prop.getValue();
    }

    public void addProperty(String key, String value) {
        this.properties.getMap().put(key, new PropertyMetadata(key, value));
    }

    public <T> T addAttchment(Class<T> type, T attachment) {
        if (type == null) {
            throw new IllegalArgumentException("Null type");
        }
        Object result = this.attachments.put(type.getName(), attachment);
        if (result == null) {
            return null;
        }
        return type.cast(result);
    }

    public Object addAttchment(String key, Object attachment) {
        if (key == null) {
            throw new IllegalArgumentException("Null type");
        }
        Object result = this.attachments.put(key, attachment);
        if (result == null) {
            return null;
        }
        return result;
    }

    public <T> T removeAttachment(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("Null type");
        }
        Object result = this.attachments.remove(type.getName());
        if (result == null) {
            return null;
        }
        return type.cast(result);
    }

    public Object removeAttachment(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Null type");
        }
        Object result = this.attachments.remove(key);
        if (result == null) {
            return null;
        }
        return result;
    }

    public <T> T getAttachment(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("Null type");
        }
        Object result = this.attachments.get(type.getName());
        if (result == null) {
            return null;
        }
        return type.cast(result);
    }

    public Object getAttachment(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Null type");
        }
        Object result = this.attachments.get(key);
        if (result == null) {
            return null;
        }
        return result;
    }
}

