/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.client.security;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.TimeZone;
import org.teiid.client.security.SessionToken;

public class LogonResult
implements Externalizable {
    private static final long serialVersionUID = 4481443514871448269L;
    private TimeZone timeZone = TimeZone.getDefault();
    private String clusterName;
    private SessionToken sessionToken;
    private String vdbName;
    private int vdbVersion;

    public LogonResult() {
    }

    public LogonResult(SessionToken token, String vdbName, int vdbVersion, String clusterName) {
        this.clusterName = clusterName;
        this.sessionToken = token;
        this.vdbName = vdbName;
        this.vdbVersion = vdbVersion;
    }

    public String getSessionID() {
        return this.sessionToken.getSessionID();
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public String getUserName() {
        return this.sessionToken.getUsername();
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public SessionToken getSessionToken() {
        return this.sessionToken;
    }

    public String getVdbName() {
        return this.vdbName;
    }

    public int getVdbVersion() {
        return this.vdbVersion;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.vdbName = (String)in.readObject();
        this.sessionToken = (SessionToken)in.readObject();
        this.timeZone = (TimeZone)in.readObject();
        this.clusterName = (String)in.readObject();
        this.vdbVersion = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.vdbName);
        out.writeObject(this.sessionToken);
        out.writeObject(this.timeZone);
        out.writeObject(this.clusterName);
        out.writeInt(this.vdbVersion);
    }
}

