/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.adminapi.impl;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.adminapi.DataPolicy;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.Translator;
import org.teiid.adminapi.impl.DataPolicyMetadata;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.TranslatorMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.util.PropertiesUtils;

public class TestVDBMetaData {
    @Test
    public void testMarshellUnmarshell() throws Exception {
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName("myVDB");
        vdb.setDescription("vdb description");
        vdb.setVersion(1);
        vdb.addProperty("vdb-property", "vdb-value");
        ModelMetaData modelOne = new ModelMetaData();
        modelOne.setName("model-one");
        modelOne.addSourceMapping("s1", "translator", "java:mybinding");
        modelOne.setModelType(Model.Type.PHYSICAL);
        modelOne.addProperty("model-prop", "model-value");
        modelOne.addProperty("model-prop", "model-value-override");
        modelOne.setVisible(Boolean.valueOf(false));
        modelOne.addError("ERROR", "There is an error in VDB");
        modelOne.setDescription("model description");
        vdb.addModel(modelOne);
        ModelMetaData modelTwo = new ModelMetaData();
        modelTwo.setName("model-two");
        modelTwo.addSourceMapping("s1", "translator", "java:binding-one");
        modelTwo.addSourceMapping("s2", "translator", "java:binding-two");
        modelTwo.setModelType(Model.Type.VIRTUAL);
        modelTwo.addProperty("model-prop", "model-value");
        vdb.addModel(modelTwo);
        TranslatorMetaData t1 = new TranslatorMetaData();
        t1.setName("oracleOverride");
        t1.setType("oracle");
        t1.setDescription("hello world");
        t1.addProperty("my-property", "my-value");
        ArrayList<TranslatorMetaData> list = new ArrayList<TranslatorMetaData>();
        list.add(t1);
        vdb.setOverrideTranslators(list);
        DataPolicyMetadata roleOne = new DataPolicyMetadata();
        roleOne.setName("roleOne");
        roleOne.setDescription("roleOne described");
        roleOne.setAllowCreateTemporaryTables(Boolean.valueOf(true));
        DataPolicyMetadata.PermissionMetaData perm1 = new DataPolicyMetadata.PermissionMetaData();
        perm1.setResourceName("myTable.T1");
        perm1.setAllowRead(Boolean.valueOf(true));
        roleOne.addPermission(new DataPolicyMetadata.PermissionMetaData[]{perm1});
        DataPolicyMetadata.PermissionMetaData perm2 = new DataPolicyMetadata.PermissionMetaData();
        perm2.setResourceName("myTable.T2");
        perm2.setAllowRead(Boolean.valueOf(false));
        perm2.setAllowDelete(Boolean.valueOf(true));
        roleOne.addPermission(new DataPolicyMetadata.PermissionMetaData[]{perm2});
        roleOne.setMappedRoleNames(Arrays.asList("ROLE1", "ROLE2"));
        vdb.addDataPolicy(roleOne);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(VDBMetaData.class.getResource("/vdb-deployer.xsd"));
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{VDBMetaData.class});
        Marshaller marshell = jc.createMarshaller();
        marshell.setSchema(schema);
        marshell.setProperty("jaxb.formatted.output", (Object)new Boolean(true));
        StringWriter sw = new StringWriter();
        marshell.marshal((Object)vdb, (Writer)sw);
        Unmarshaller un = jc.createUnmarshaller();
        un.setSchema(schema);
        vdb = (VDBMetaData)un.unmarshal((Reader)new StringReader(sw.toString()));
        Assert.assertEquals((Object)"myVDB", (Object)vdb.getName());
        Assert.assertEquals((Object)"vdb description", (Object)vdb.getDescription());
        Assert.assertEquals((long)1L, (long)vdb.getVersion());
        Assert.assertEquals((Object)"vdb-value", (Object)vdb.getPropertyValue("vdb-property"));
        Assert.assertNotNull((Object)vdb.getModel("model-one"));
        Assert.assertNotNull((Object)vdb.getModel("model-two"));
        Assert.assertNull((Object)vdb.getModel("model-unknown"));
        modelOne = vdb.getModel("model-one");
        Assert.assertEquals((Object)"model-one", (Object)modelOne.getName());
        Assert.assertEquals((Object)"s1", modelOne.getSourceNames().get(0));
        Assert.assertEquals((Object)Model.Type.PHYSICAL, (Object)modelOne.getModelType());
        Assert.assertEquals((Object)"model-value-override", (Object)modelOne.getPropertyValue("model-prop"));
        Assert.assertFalse((boolean)modelOne.isVisible());
        Assert.assertEquals((Object)"model description", (Object)modelOne.getDescription());
        modelTwo = vdb.getModel("model-two");
        Assert.assertEquals((Object)"model-two", (Object)modelTwo.getName());
        Assert.assertTrue((boolean)modelTwo.getSourceNames().contains("s1"));
        Assert.assertTrue((boolean)modelTwo.getSourceNames().contains("s2"));
        Assert.assertEquals((Object)Model.Type.VIRTUAL, (Object)modelTwo.getModelType());
        Assert.assertEquals((Object)"model-value", (Object)modelTwo.getPropertyValue("model-prop"));
        Assert.assertTrue((boolean)vdb.getValidityErrors().contains("There is an error in VDB"));
        List translators = vdb.getOverrideTranslators();
        Assert.assertTrue((translators.size() == 1 ? 1 : 0) != 0);
        Translator translator = (Translator)translators.get(0);
        Assert.assertEquals((Object)"oracleOverride", (Object)translator.getName());
        Assert.assertEquals((Object)"oracle", (Object)translator.getType());
        Assert.assertEquals((Object)"my-value", (Object)translator.getPropertyValue("my-property"));
        Assert.assertEquals((Object)"hello world", (Object)translator.getDescription());
        List roles = vdb.getDataPolicies();
        Assert.assertTrue((roles.size() == 1 ? 1 : 0) != 0);
        DataPolicyMetadata role = vdb.getDataPolicy("roleOne");
        Assert.assertTrue((boolean)role.isAllowCreateTemporaryTables());
        Assert.assertEquals((Object)"roleOne described", (Object)role.getDescription());
        Assert.assertNotNull((Object)role.getMappedRoleNames());
        Assert.assertTrue((boolean)role.getMappedRoleNames().contains("ROLE1"));
        Assert.assertTrue((boolean)role.getMappedRoleNames().contains("ROLE2"));
        List permissions = role.getPermissions();
        Assert.assertEquals((long)2L, (long)permissions.size());
        for (DataPolicy.DataPermission p : permissions) {
            if (p.getResourceName().equalsIgnoreCase("myTable.T1")) {
                Assert.assertTrue((boolean)p.getAllowRead());
                Assert.assertNull((Object)p.getAllowDelete());
                continue;
            }
            Assert.assertFalse((boolean)p.getAllowRead());
            Assert.assertTrue((boolean)p.getAllowDelete());
        }
    }

    @Test
    public void testAdminMOCreation() {
        VDBMetaData vdb = new VDBMetaData();
        PropertiesUtils.setBeanProperty((Object)vdb, (String)"url", (Object)"http://teiid.org/myvdb.vdb");
        Assert.assertEquals((Object)"http://teiid.org/myvdb.vdb", (Object)vdb.getUrl());
    }

    @Test
    public void testSetUrlVersion() throws MalformedURLException {
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName("foo");
        vdb.setUrl(new URL("file:///x/foo.2.vdb"));
        Assert.assertEquals((long)2L, (long)vdb.getVersion());
    }
}

