/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;
import org.teiid.client.RequestMessage;
import org.teiid.core.util.SqlUtil;
import org.teiid.core.util.TimestampWithTimezone;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.DataTypeTransformer;
import org.teiid.jdbc.JDBCPlugin;
import org.teiid.jdbc.PreparedStatementImpl;
import org.teiid.jdbc.TeiidSQLException;

public class CallableStatementImpl
extends PreparedStatementImpl
implements CallableStatement {
    private Object parameterValue;

    static CallableStatementImpl newInstance(ConnectionImpl connection, String procedureCall, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new CallableStatementImpl(connection, procedureCall, resultSetType, resultSetConcurrency);
    }

    CallableStatementImpl(ConnectionImpl connection, String procedureCall, int resultSetType, int resultSetConcurrency) throws SQLException {
        super(connection, procedureCall, resultSetType, resultSetConcurrency);
        this.prepareSql = procedureCall;
    }

    @Override
    protected void resetExecutionState() throws SQLException {
        super.resetExecutionState();
        this.parameterValue = null;
    }

    @Override
    protected RequestMessage createRequestMessage(String[] commands, boolean isBatchedCommand, RequestMessage.ResultsMode resultsMode) {
        RequestMessage message = super.createRequestMessage(commands, isBatchedCommand, resultsMode);
        message.setStatementType(RequestMessage.StatementType.CALLABLE);
        return message;
    }

    @Override
    public void close() throws SQLException {
        this.prepareSql = null;
        super.close();
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        BigDecimal bigDecimalParam = DataTypeTransformer.getBigDecimal(this.getObject(parameterIndex));
        return bigDecimalParam.setScale(scale);
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        return DataTypeTransformer.getBigDecimal(this.getObject(parameterIndex));
    }

    @Override
    public Blob getBlob(int parameterIndex) throws SQLException {
        return DataTypeTransformer.getBlob(this.getObject(parameterIndex));
    }

    @Override
    public boolean getBoolean(int parameterIndex) throws SQLException {
        return DataTypeTransformer.getBoolean(this.getObject(parameterIndex));
    }

    @Override
    public byte getByte(int parameterIndex) throws SQLException {
        return DataTypeTransformer.getByte(this.getObject(parameterIndex));
    }

    @Override
    public Clob getClob(int parameterIndex) throws SQLException {
        return DataTypeTransformer.getClob(this.getObject(parameterIndex));
    }

    @Override
    public Date getDate(int parameterIndex) throws SQLException {
        return this.getDate(parameterIndex, null);
    }

    @Override
    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        Object val = this.getObject(parameterIndex);
        return this.getDate(cal, val);
    }

    private Date getDate(Calendar cal, Object val) throws SQLException {
        Date value = DataTypeTransformer.getDate(val);
        if (value == null) {
            return null;
        }
        if (cal != null) {
            value = TimestampWithTimezone.createDate((java.util.Date)value, (TimeZone)this.getDefaultCalendar().getTimeZone(), (Calendar)cal);
        }
        return value;
    }

    @Override
    public double getDouble(int parameterIndex) throws SQLException {
        return DataTypeTransformer.getDouble(this.getObject(parameterIndex));
    }

    @Override
    public float getFloat(int parameterIndex) throws SQLException {
        return DataTypeTransformer.getFloat(this.getObject(parameterIndex));
    }

    @Override
    public int getInt(int parameterIndex) throws SQLException {
        return DataTypeTransformer.getInteger(this.getObject(parameterIndex));
    }

    @Override
    public long getLong(int parameterIndex) throws SQLException {
        return DataTypeTransformer.getLong(this.getObject(parameterIndex));
    }

    @Override
    public Object getObject(int parameterIndex) throws SQLException {
        return this.getObject((Object)parameterIndex);
    }

    Object getObject(Object parameterIndex) throws SQLException {
        Integer indexInResults = null;
        indexInResults = parameterIndex instanceof String ? (Integer)this.outParamByName.get(parameterIndex) : (Integer)this.outParamIndexMap.get(parameterIndex);
        if (indexInResults == null) {
            throw new TeiidSQLException(JDBCPlugin.Util.getString("MMCallableStatement.Param_not_found", new Object[]{parameterIndex}));
        }
        this.checkStatement();
        this.parameterValue = this.resultSet.getOutputParamValue(indexInResults);
        return this.parameterValue;
    }

    @Override
    public short getShort(int parameterIndex) throws SQLException {
        return DataTypeTransformer.getShort(this.getObject(parameterIndex));
    }

    @Override
    public String getString(int parameterIndex) throws SQLException {
        return DataTypeTransformer.getString(this.getObject(parameterIndex));
    }

    @Override
    public Time getTime(int parameterIndex) throws SQLException {
        return this.getTime(parameterIndex, null);
    }

    @Override
    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        Object val = this.getObject(parameterIndex);
        return this.getTime(cal, val);
    }

    private Time getTime(Calendar cal, Object val) throws SQLException {
        Time value = DataTypeTransformer.getTime(val);
        if (value == null) {
            return null;
        }
        if (cal != null) {
            value = TimestampWithTimezone.createTime((java.util.Date)value, (TimeZone)this.getDefaultCalendar().getTimeZone(), (Calendar)cal);
        }
        return value;
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        return this.getTimestamp(parameterIndex, null);
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        Object val = this.getObject(parameterIndex);
        return this.getTimestamp(cal, val);
    }

    private Timestamp getTimestamp(Calendar cal, Object val) throws SQLException {
        Timestamp value = DataTypeTransformer.getTimestamp(val);
        if (value == null) {
            return null;
        }
        if (cal != null) {
            value = TimestampWithTimezone.createTimestamp((java.util.Date)value, (TimeZone)this.getDefaultCalendar().getTimeZone(), (Calendar)cal);
        }
        return value;
    }

    @Override
    public void registerOutParameter(int parameterIndex, int jdbcSqlType) throws SQLException {
    }

    @Override
    public void registerOutParameter(int parameterIndex, int jdbcSqlType, int scale) throws SQLException {
    }

    @Override
    public void registerOutParameter(int parameterIndex, int jdbcSqlType, String typeName) throws SQLException {
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkStatement();
        return this.parameterValue == null;
    }

    @Override
    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        return DataTypeTransformer.getSQLXML(this.getObject(parameterIndex));
    }

    @Override
    public Array getArray(int parameterIndex) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public Array getArray(String parameterName) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        return DataTypeTransformer.getBigDecimal(this.getObject(parameterName));
    }

    @Override
    public Blob getBlob(String parameterName) throws SQLException {
        return DataTypeTransformer.getBlob(this.getObject(parameterName));
    }

    @Override
    public boolean getBoolean(String parameterName) throws SQLException {
        return DataTypeTransformer.getBoolean(this.getObject(parameterName));
    }

    @Override
    public byte getByte(String parameterName) throws SQLException {
        return DataTypeTransformer.getByte(this.getObject(parameterName));
    }

    @Override
    public byte[] getBytes(int parameterIndex) throws SQLException {
        return DataTypeTransformer.getBytes(this.getObject(parameterIndex));
    }

    @Override
    public byte[] getBytes(String parameterName) throws SQLException {
        return DataTypeTransformer.getBytes(this.getObject(parameterName));
    }

    @Override
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        return DataTypeTransformer.getCharacterStream(this.getObject(parameterIndex));
    }

    @Override
    public Reader getCharacterStream(String parameterName) throws SQLException {
        return DataTypeTransformer.getCharacterStream(this.getObject(parameterName));
    }

    @Override
    public Clob getClob(String parameterName) throws SQLException {
        return DataTypeTransformer.getClob(this.getObject(parameterName));
    }

    @Override
    public Date getDate(String parameterName) throws SQLException {
        return DataTypeTransformer.getDate(this.getObject(parameterName));
    }

    @Override
    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        return this.getDate(cal, this.getObject(parameterName));
    }

    @Override
    public double getDouble(String parameterName) throws SQLException {
        return DataTypeTransformer.getDouble(this.getObject(parameterName));
    }

    @Override
    public float getFloat(String parameterName) throws SQLException {
        return DataTypeTransformer.getFloat(this.getObject(parameterName));
    }

    @Override
    public int getInt(String parameterName) throws SQLException {
        return DataTypeTransformer.getInteger(this.getObject(parameterName));
    }

    @Override
    public long getLong(String parameterName) throws SQLException {
        return DataTypeTransformer.getLong(this.getObject(parameterName));
    }

    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        return DataTypeTransformer.getCharacterStream(this.getObject(parameterIndex));
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        return DataTypeTransformer.getCharacterStream(this.getObject(parameterName));
    }

    @Override
    public NClob getNClob(int parameterIndex) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        return DataTypeTransformer.getNClob(this.getObject(parameterName));
    }

    @Override
    public String getNString(int parameterIndex) throws SQLException {
        return DataTypeTransformer.getString(this.getObject(parameterIndex));
    }

    @Override
    public String getNString(String parameterName) throws SQLException {
        return DataTypeTransformer.getString(this.getObject(parameterName));
    }

    @Override
    public Object getObject(String parameterName) throws SQLException {
        return this.getObject((Object)parameterName);
    }

    @Override
    public Object getObject(int parameterIndex, Map<String, Class<?>> map) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public Object getObject(String parameterName, Map<String, Class<?>> map) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public Ref getRef(int parameterIndex) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public Ref getRef(String parameterName) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public RowId getRowId(int parameterIndex) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public RowId getRowId(String parameterName) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public SQLXML getSQLXML(String parameterName) throws SQLException {
        return DataTypeTransformer.getSQLXML(this.getObject(parameterName));
    }

    @Override
    public short getShort(String parameterName) throws SQLException {
        return DataTypeTransformer.getShort(this.getObject(parameterName));
    }

    @Override
    public String getString(String parameterName) throws SQLException {
        return DataTypeTransformer.getString(this.getObject(parameterName));
    }

    @Override
    public Time getTime(String parameterName) throws SQLException {
        return DataTypeTransformer.getTime(this.getObject(parameterName));
    }

    @Override
    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        return this.getTime(cal, this.getObject(parameterName));
    }

    @Override
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        return DataTypeTransformer.getTimestamp(this.getObject(parameterName));
    }

    @Override
    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        return this.getTimestamp(cal, this.getObject(parameterName));
    }

    @Override
    public URL getURL(int parameterIndex) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        this.setAsciiStream((Object)parameterName, x);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        this.setAsciiStream((Object)parameterName, x);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
        this.setAsciiStream((Object)parameterName, x);
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        this.setObject(parameterName, (Object)x);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        this.setBlob((Object)parameterName, x);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        this.setBinaryStream(parameterName, x);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
        this.setBinaryStream(parameterName, x);
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
        this.setObject(parameterName, (Object)x);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        this.setBlob((Object)parameterName, inputStream);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        this.setBlob((Object)parameterName, inputStream);
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
        this.setObject((Object)parameterName, (Object)x);
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
        this.setObject((Object)parameterName, (Object)x);
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
        this.setObject((Object)parameterName, (Object)x);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        this.setClob(parameterName, reader);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        this.setClob(parameterName, reader);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        this.setClob(parameterName, reader);
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
        this.setObject((Object)parameterName, (Object)x);
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        this.setClob((Object)parameterName, reader);
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        this.setClob((Object)parameterName, reader);
    }

    @Override
    public void setDate(String parameterName, Date x) throws SQLException {
        this.setObject((Object)parameterName, (Object)x);
    }

    @Override
    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        this.setDate((Object)parameterName, x, cal);
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
        this.setObject((Object)parameterName, (Object)x);
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
        this.setObject((Object)parameterName, (Object)Float.valueOf(x));
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
        this.setObject((Object)parameterName, (Object)x);
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
        this.setObject((Object)parameterName, (Object)x);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        this.setClob((Object)parameterName, value);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        this.setClob((Object)parameterName, value);
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
        this.setObject((Object)parameterName, (Object)value);
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        this.setClob((Object)parameterName, reader);
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        this.setClob((Object)parameterName, reader);
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        this.setObject((Object)parameterName, null);
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        this.setObject((Object)parameterName, null);
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        this.setObject((Object)parameterName, null);
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
        this.setObject((Object)parameterName, x);
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        this.setObject((Object)parameterName, x, targetSqlType);
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        this.setObject((Object)parameterName, x, targetSqlType, scale);
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        this.setObject((Object)parameterName, (Object)xmlObject);
    }

    @Override
    public void setShort(String parameterName, short x) throws SQLException {
        this.setObject((Object)parameterName, (Object)x);
    }

    @Override
    public void setString(String parameterName, String x) throws SQLException {
        this.setObject((Object)parameterName, (Object)x);
    }

    @Override
    public void setTime(String parameterName, Time x) throws SQLException {
        this.setObject((Object)parameterName, (Object)x);
    }

    @Override
    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        this.setTime((Object)parameterName, x, cal);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        this.setObject((Object)parameterName, (Object)x);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        this.setTimestamp((Object)parameterName, x, cal);
    }

    @Override
    public void setURL(String parameterName, URL val) throws SQLException {
        this.setObject((Object)parameterName, (Object)val);
    }
}

