/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import java.sql.SQLException;
import org.teiid.client.ProcedureErrorInstructionException;
import org.teiid.client.security.InvalidSessionException;
import org.teiid.client.security.LogonException;
import org.teiid.client.util.ExceptionUtil;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.jdbc.SQLStates;
import org.teiid.net.CommunicationException;
import org.teiid.net.ConnectionException;

public class TeiidSQLException
extends SQLException {
    private static final long serialVersionUID = 3672305321346173922L;

    public TeiidSQLException() {
    }

    public TeiidSQLException(String reason) {
        super(reason, "38000");
    }

    public TeiidSQLException(String reason, String state) {
        super(reason, state);
    }

    public static TeiidSQLException create(Throwable exception) {
        if (exception instanceof TeiidSQLException) {
            return (TeiidSQLException)exception;
        }
        return TeiidSQLException.create(exception, exception.getMessage());
    }

    public TeiidSQLException(Throwable ex, String reason, String sqlState) {
        super(reason, sqlState);
        this.initCause(ex);
    }

    private TeiidSQLException(SQLException ex, String message, boolean addChildren) {
        super(message, ex.getSQLState() == null ? "38000" : ex.getSQLState(), ex.getErrorCode());
        if (addChildren) {
            for (SQLException childException = ex; childException != null; childException = childException.getNextException()) {
                if (childException instanceof TeiidSQLException) {
                    super.setNextException(ex);
                    break;
                }
                super.setNextException(new TeiidSQLException(childException, TeiidSQLException.getMessage(childException, null), false));
            }
        }
    }

    public static TeiidSQLException create(Throwable exception, String message) {
        message = TeiidSQLException.getMessage(exception, message);
        Throwable origException = exception;
        if (exception instanceof TeiidSQLException && message.equals(exception.getMessage())) {
            return (TeiidSQLException)exception;
        }
        if (exception instanceof SQLException) {
            return new TeiidSQLException((SQLException)exception, message, true);
        }
        String sqlState = "38000";
        TeiidException te = ExceptionUtil.getExceptionOfType(exception, TeiidException.class);
        if (te != null && te.getCode() != null) {
            sqlState = te.getCode();
        } else {
            exception = TeiidSQLException.findRootException(exception);
            sqlState = TeiidSQLException.determineSQLState(exception, sqlState);
        }
        return new TeiidSQLException(origException, message, sqlState);
    }

    private static String determineSQLState(Throwable exception, String sqlState) {
        if (exception instanceof InvalidSessionException) {
            sqlState = "08S01";
        } else if (exception instanceof LogonException) {
            sqlState = "28000";
        } else if (exception instanceof ProcedureErrorInstructionException) {
            sqlState = "50001";
        } else if (exception instanceof TeiidProcessingException) {
            sqlState = "50000";
        } else if (exception instanceof UnknownHostException || exception instanceof ConnectException || exception instanceof MalformedURLException || exception instanceof NoRouteToHostException || exception instanceof ConnectionException) {
            sqlState = "08001";
        } else if (exception instanceof IOException) {
            sqlState = "08S01";
        } else if (exception instanceof TeiidException) {
            if (exception instanceof CommunicationException) {
                sqlState = "08S01";
            }
            Throwable originalException = exception;
            exception = originalException.getCause();
            if ((exception = TeiidSQLException.findRootException(exception)) instanceof CommunicationException) {
                sqlState = "50000";
                exception = exception.getCause();
            }
            if (exception != null && exception != originalException) {
                sqlState = TeiidSQLException.determineSQLState(exception, sqlState);
            }
        }
        return sqlState;
    }

    private static Throwable findRootException(Throwable exception) {
        if (exception instanceof TeiidRuntimeException) {
            while (exception.getCause() != exception && exception.getCause() != null) {
                exception = exception.getCause();
            }
            if (exception instanceof TeiidRuntimeException) {
                TeiidRuntimeException runtimeException = (TeiidRuntimeException)exception;
                while (runtimeException.getChild() != exception && runtimeException.getChild() != null) {
                    if (runtimeException.getChild() instanceof TeiidRuntimeException) {
                        runtimeException = (TeiidRuntimeException)runtimeException.getChild();
                        continue;
                    }
                    exception = runtimeException.getChild();
                    break;
                }
            }
        }
        return exception;
    }

    private static String getMessage(Throwable exception, String message) {
        if (message == null && (message = exception.getMessage()) == null) {
            message = exception.getClass().getName();
        }
        return message;
    }

    @Override
    public Throwable getCause() {
        if (this.getNextException() != null) {
            return this.getNextException();
        }
        return super.getCause();
    }

    public boolean isSystemErrorState() {
        return SQLStates.isSystemErrorState(this.getSQLState());
    }

    public boolean isUsageErrorState() {
        return SQLStates.isUsageErrorState(this.getSQLState());
    }
}

