/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import org.teiid.core.types.BinaryType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.TransformationException;
import org.teiid.core.util.ReaderInputStream;
import org.teiid.jdbc.JDBCPlugin;
import org.teiid.jdbc.TeiidSQLException;

final class DataTypeTransformer {
    private DataTypeTransformer() {
    }

    static final BigDecimal getBigDecimal(Object value) throws SQLException {
        return DataTypeTransformer.transform(value, BigDecimal.class, "BigDecimal");
    }

    private static final <T> T transform(Object value, Class<T> type, String typeName) throws SQLException {
        return DataTypeTransformer.transform(value, type, type, typeName);
    }

    private static final <T> T transform(Object value, Class<T> targetType, Class<?> runtimeType, String typeName) throws SQLException {
        if (value == null || targetType.isAssignableFrom(value.getClass())) {
            return targetType.cast(value);
        }
        try {
            return targetType.cast(DataTypeManager.transformValue((Object)DataTypeManager.convertToRuntimeType((Object)value), runtimeType));
        }
        catch (TransformationException e) {
            String valueStr = value.toString();
            if (valueStr.length() > 20) {
                valueStr = valueStr.substring(0, 20) + "...";
            }
            String msg = JDBCPlugin.Util.getString("DataTypeTransformer.Err_converting", new Object[]{valueStr, typeName});
            throw TeiidSQLException.create(e, msg);
        }
    }

    static final boolean getBoolean(Object value) throws SQLException {
        if (value == null) {
            return false;
        }
        return DataTypeTransformer.transform(value, Boolean.class, "Boolean");
    }

    static final byte getByte(Object value) throws SQLException {
        if (value == null) {
            return 0;
        }
        return DataTypeTransformer.transform(value, Byte.class, "Byte");
    }

    static final byte[] getBytes(Object value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        if (value instanceof Blob) {
            Blob blob = (Blob)value;
            long length = blob.length();
            if (length > Integer.MAX_VALUE) {
                throw new TeiidSQLException(JDBCPlugin.Util.getString("DataTypeTransformer.blob_too_big"));
            }
            return blob.getBytes(1L, (int)length);
        }
        if (value instanceof String) {
            return ((String)value).getBytes();
        }
        if (value instanceof BinaryType) {
            return ((BinaryType)value).getBytesDirect();
        }
        throw new TeiidSQLException(JDBCPlugin.Util.getString("DataTypeTransformer.cannot_get_bytes"));
    }

    static final Character getCharacter(Object value) throws SQLException {
        return DataTypeTransformer.transform(value, Character.class, "Character");
    }

    static final Date getDate(Object value) throws SQLException {
        return DataTypeTransformer.transform(value, Date.class, "Date");
    }

    static final double getDouble(Object value) throws SQLException {
        if (value == null) {
            return 0.0;
        }
        return DataTypeTransformer.transform(value, Double.class, "Double");
    }

    static final float getFloat(Object value) throws SQLException {
        if (value == null) {
            return 0.0f;
        }
        return DataTypeTransformer.transform(value, Float.class, "Float").floatValue();
    }

    static final int getInteger(Object value) throws SQLException {
        if (value == null) {
            return 0;
        }
        return DataTypeTransformer.transform(value, Integer.class, "Integer");
    }

    static final long getLong(Object value) throws SQLException {
        if (value == null) {
            return 0L;
        }
        return DataTypeTransformer.transform(value, Long.class, "Long");
    }

    static final short getShort(Object value) throws SQLException {
        if (value == null) {
            return 0;
        }
        return DataTypeTransformer.transform(value, Short.class, "Short");
    }

    static final Time getTime(Object value) throws SQLException {
        return DataTypeTransformer.transform(value, Time.class, "Time");
    }

    static final Timestamp getTimestamp(Object value) throws SQLException {
        return DataTypeTransformer.transform(value, Timestamp.class, "Timestamp");
    }

    static final String getString(Object value) throws SQLException {
        if (value instanceof SQLXML) {
            return ((SQLXML)value).getString();
        }
        if (value instanceof Clob) {
            Clob c;
            return c.getSubString(1L, (c = (Clob)value).length() > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)c.length());
        }
        return DataTypeTransformer.transform(value, String.class, "String");
    }

    static final Blob getBlob(Object value) throws SQLException {
        return DataTypeTransformer.transform(value, Blob.class, DataTypeManager.DefaultDataClasses.BLOB, "Blob");
    }

    static final Clob getClob(Object value) throws SQLException {
        return DataTypeTransformer.transform(value, Clob.class, DataTypeManager.DefaultDataClasses.CLOB, "Clob");
    }

    static final SQLXML getSQLXML(Object value) throws SQLException {
        return DataTypeTransformer.transform(value, SQLXML.class, DataTypeManager.DefaultDataClasses.XML, "SQLXML");
    }

    static final Reader getCharacterStream(Object value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value instanceof Clob) {
            return ((Clob)value).getCharacterStream();
        }
        if (value instanceof SQLXML) {
            return ((SQLXML)value).getCharacterStream();
        }
        return new StringReader(DataTypeTransformer.getString(value));
    }

    static final InputStream getAsciiStream(Object value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value instanceof Clob) {
            return ((Clob)value).getAsciiStream();
        }
        if (value instanceof SQLXML) {
            return new ReaderInputStream(((SQLXML)value).getCharacterStream(), Charset.forName("ASCII"));
        }
        return new ByteArrayInputStream(DataTypeTransformer.getString(value).getBytes(Charset.forName("ASCII")));
    }

    static final NClob getNClob(Object value) throws SQLException {
        final Clob clob = DataTypeTransformer.getClob(value);
        if (clob == null) {
            return null;
        }
        return (NClob)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{NClob.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                try {
                    return method.invoke((Object)clob, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }
        });
    }
}

