/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import junit.framework.TestCase;
import org.teiid.client.RequestMessage;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.jdbc.TeiidDataSource;
import org.teiid.jdbc.TeiidSQLException;

public class TestTeiidDataSource
extends TestCase {
    protected static final boolean VALID = true;
    protected static final boolean INVALID = false;
    private TeiidDataSource dataSource;
    protected static final String STD_SERVER_NAME = "unitTestServerName";
    protected static final String STD_DATABASE_NAME = "unitTestVdbName";
    protected static final String STD_DATABASE_VERSION = "unitTestVdbVersion";
    protected static final String STD_DATA_SOURCE_NAME = "unitTestDataSourceName";
    protected static final int STD_PORT_NUMBER = 7001;
    protected static final String STD_LOG_FILE = UnitTestUtil.getTestScratchPath() + "/unitTestLogFile";
    protected static final int STD_LOG_LEVEL = 2;
    protected static final String STD_TXN_WRAP = "DETECT";
    protected static final String STD_PARTIAL_MODE = "false";
    protected static final String STD_CONFIG_FILE = UnitTestUtil.getTestDataPath() + "/bqt/bqt.properties";
    protected static final String STD_ALTERNATE_SERVERS = "unitTestServerName2:7001,unitTestServerName2:7002,unitTestServerName3:7001";

    public TestTeiidDataSource(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.dataSource = new TeiidDataSource();
        this.dataSource.setServerName(STD_SERVER_NAME);
        this.dataSource.setDatabaseVersion(STD_DATABASE_VERSION);
        this.dataSource.setDatabaseName(STD_DATABASE_NAME);
        this.dataSource.setPortNumber(7001);
        this.dataSource.setDataSourceName(STD_DATA_SOURCE_NAME);
        this.dataSource.setTransactionAutoWrap(STD_TXN_WRAP);
        this.dataSource.setPartialResultsMode(STD_PARTIAL_MODE);
        this.dataSource.setSecure(true);
        this.dataSource.setAlternateServers(STD_ALTERNATE_SERVERS);
        this.dataSource.setUseJDBC4ColumnNameAndLabelSemantics(true);
    }

    protected String getReasonWhyInvalid(String propertyName, String value) {
        if (propertyName.equals("DatabaseName")) {
            return TeiidDataSource.reasonWhyInvalidDatabaseName((String)value);
        }
        if (propertyName.equals("DatabaseVersion")) {
            return TeiidDataSource.reasonWhyInvalidDatabaseVersion((String)value);
        }
        if (propertyName.equals("DataSourceName")) {
            return TeiidDataSource.reasonWhyInvalidDataSourceName((String)value);
        }
        if (propertyName.equals("Description")) {
            return TeiidDataSource.reasonWhyInvalidDescription((String)value);
        }
        if (propertyName.equals("ServerName")) {
            return TeiidDataSource.reasonWhyInvalidServerName((String)value);
        }
        if (propertyName.equals("TransactionAutoWrap")) {
            return TeiidDataSource.reasonWhyInvalidTransactionAutoWrap((String)value);
        }
        if (propertyName.equals("partialResultsMode")) {
            return TeiidDataSource.reasonWhyInvalidPartialResultsMode((String)value);
        }
        if (propertyName.equals("socketsPerVM")) {
            return TeiidDataSource.reasonWhyInvalidSocketsPerVM((String)value);
        }
        if (propertyName.equals("stickyConnections")) {
            return TeiidDataSource.reasonWhyInvalidStickyConnections((String)value);
        }
        TestTeiidDataSource.fail((String)("Unknown property name \"" + propertyName + "\""));
        return null;
    }

    protected String getReasonWhyInvalid(String propertyName, int value) {
        if (propertyName.equals("PortNumber")) {
            return TeiidDataSource.reasonWhyInvalidPortNumber((int)value);
        }
        TestTeiidDataSource.fail((String)("Unknown property name \"" + propertyName + "\""));
        return null;
    }

    public void helpTestReasonWhyInvalid(String propertyName, String value, boolean shouldBeValid) {
        String reason = this.getReasonWhyInvalid(propertyName, value);
        if (shouldBeValid) {
            TestTeiidDataSource.assertNull((String)("Unexpectedly considered invalid value \"" + value + "\"; reason = " + reason), (Object)reason);
        } else {
            TestTeiidDataSource.assertNotNull((String)("Unexpectedly found no reason for value \"" + value + "\""), (Object)reason);
        }
    }

    public void helpTestReasonWhyInvalid(String propertyName, int value, boolean shouldBeValid) {
        String reason = this.getReasonWhyInvalid(propertyName, value);
        if (shouldBeValid) {
            TestTeiidDataSource.assertNull((String)("Unexpectedly considered invalid value " + value + "; reason = " + reason), (Object)reason);
        } else {
            TestTeiidDataSource.assertNotNull((String)("Unexpectedly found no reason for value " + value), (Object)reason);
        }
    }

    public void helpTestBuildingURL(String vdbName, String vdbVersion, String serverName, int portNumber, String alternateServers, String txnAutoWrap, String partialMode, int fetchSize, boolean showPlan, boolean secure, String expectedURL) {
        this.helpTestBuildingURL2(vdbName, vdbVersion, serverName, portNumber, alternateServers, txnAutoWrap, partialMode, fetchSize, showPlan, secure, true, expectedURL);
    }

    public void helpTestBuildingURL2(String vdbName, String vdbVersion, String serverName, int portNumber, String alternateServers, String txnAutoWrap, String partialMode, int fetchSize, boolean showPlan, boolean secure, boolean useJDBC4Semantics, String expectedURL) {
        String url;
        TeiidDataSource ds = new TeiidDataSource();
        ds.setServerName(serverName);
        ds.setDatabaseVersion(vdbVersion);
        ds.setDatabaseName(vdbName);
        ds.setPortNumber(portNumber);
        ds.setFetchSize(fetchSize);
        ds.setTransactionAutoWrap(txnAutoWrap);
        ds.setPartialResultsMode(partialMode);
        if (showPlan) {
            ds.setShowPlan(RequestMessage.ShowPlan.ON.toString());
        }
        ds.setSecure(secure);
        ds.setAlternateServers(alternateServers);
        ds.setUseJDBC4ColumnNameAndLabelSemantics(useJDBC4Semantics);
        try {
            url = ds.buildURL().getJDBCURL();
        }
        catch (TeiidSQLException e) {
            throw new RuntimeException(e);
        }
        TestTeiidDataSource.assertEquals((String)expectedURL, (String)url);
    }

    public Connection helpTestConnection(String vdbName, String vdbVersion, String serverName, int portNumber, String alternateServers, String user, String password, String dataSourceName, String txnAutoWrap, String partialMode, String configFile) throws SQLException {
        TeiidDataSource ds = new TeiidDataSource();
        ds.setServerName(serverName);
        ds.setDatabaseVersion(vdbVersion);
        ds.setDatabaseName(vdbName);
        ds.setPortNumber(portNumber);
        ds.setUser(user);
        ds.setPassword(password);
        ds.setDataSourceName(dataSourceName);
        ds.setTransactionAutoWrap(txnAutoWrap);
        ds.setPartialResultsMode(partialMode);
        ds.setAlternateServers(alternateServers);
        ds.setUseJDBC4ColumnNameAndLabelSemantics(true);
        return ds.getConnection();
    }

    public void testGetServerName() {
        String result = this.dataSource.getServerName();
        TestTeiidDataSource.assertEquals((String)result, (String)STD_SERVER_NAME);
    }

    public void testGetDatabaseVersion() {
        String result = this.dataSource.getDatabaseVersion();
        TestTeiidDataSource.assertEquals((String)result, (String)STD_DATABASE_VERSION);
    }

    public void testGetDatabaseName() {
        String result = this.dataSource.getDatabaseName();
        TestTeiidDataSource.assertEquals((String)result, (String)STD_DATABASE_NAME);
    }

    public void testGetDefaultApplicationName() {
        String result = this.dataSource.getApplicationName();
        TestTeiidDataSource.assertEquals((String)result, (String)"JDBC");
    }

    public void testGetApplicationName() {
        this.dataSource.setApplicationName("ClientApp");
        String result = this.dataSource.getApplicationName();
        TestTeiidDataSource.assertEquals((String)result, (String)"ClientApp");
    }

    public void testGetPortNumber() {
        int result = this.dataSource.getPortNumber();
        TestTeiidDataSource.assertEquals((int)result, (int)7001);
    }

    public void testGetDataSourceName() {
        String result = this.dataSource.getDataSourceName();
        TestTeiidDataSource.assertEquals((String)result, (String)STD_DATA_SOURCE_NAME);
    }

    public void testGetLoginTimeout() {
        try {
            int actual = 1000;
            this.dataSource.setLoginTimeout(1000);
            int result = this.dataSource.getLoginTimeout();
            TestTeiidDataSource.assertEquals((int)result, (int)1000);
        }
        catch (SQLException e) {
            TestTeiidDataSource.fail((String)"Error obtaining login timeout");
        }
    }

    public void testGetLogWriter() {
        try {
            PrintWriter actual = new PrintWriter(new ByteArrayOutputStream());
            this.dataSource.setLogWriter(actual);
            PrintWriter result = this.dataSource.getLogWriter();
            TestTeiidDataSource.assertEquals((Object)result, (Object)actual);
        }
        catch (SQLException e) {
            TestTeiidDataSource.fail((String)"Error obtaining login timeout");
        }
    }

    public void testGetTransactionAutoWrap() {
        String result = this.dataSource.getTransactionAutoWrap();
        TestTeiidDataSource.assertEquals((String)result, (String)STD_TXN_WRAP);
    }

    public void testGetSecure() {
        TestTeiidDataSource.assertTrue((boolean)this.dataSource.isSecure());
        this.dataSource.setSecure(false);
        TestTeiidDataSource.assertFalse((boolean)this.dataSource.isSecure());
    }

    public void testGetAlternateServers() {
        String result = this.dataSource.getAlternateServers();
        TestTeiidDataSource.assertEquals((String)result, (String)STD_ALTERNATE_SERVERS);
        this.dataSource.setAlternateServers(null);
        result = this.dataSource.getAlternateServers();
        TestTeiidDataSource.assertNull((Object)result);
        this.dataSource.setAlternateServers(STD_ALTERNATE_SERVERS);
        result = this.dataSource.getAlternateServers();
        TestTeiidDataSource.assertEquals((String)result, (String)STD_ALTERNATE_SERVERS);
    }

    public void testReasonWhyInvalidDatabaseName1() {
        this.helpTestReasonWhyInvalid("DatabaseName", "Valid VDB Name", true);
    }

    public void testReasonWhyInvalidDatabaseName2() {
        this.helpTestReasonWhyInvalid("DatabaseName", "", false);
    }

    public void testReasonWhyInvalidDatabaseName3() {
        this.helpTestReasonWhyInvalid("DatabaseName", null, false);
    }

    public void testReasonWhyInvalidDatabaseVersion1() {
        this.helpTestReasonWhyInvalid("DatabaseVersion", "Valid VDB Version", true);
    }

    public void testReasonWhyInvalidDatabaseVersion2() {
        this.helpTestReasonWhyInvalid("DatabaseVersion", "1", true);
    }

    public void testReasonWhyInvalidDatabaseVersion3() {
        this.helpTestReasonWhyInvalid("DatabaseVersion", "1.2.3", true);
    }

    public void testReasonWhyInvalidDatabaseVersion4() {
        this.helpTestReasonWhyInvalid("DatabaseVersion", "1 2 3", true);
    }

    public void testReasonWhyInvalidDatabaseVersion5() {
        this.helpTestReasonWhyInvalid("DatabaseVersion", "", true);
    }

    public void testReasonWhyInvalidDatabaseVersion6() {
        this.helpTestReasonWhyInvalid("DatabaseVersion", null, true);
    }

    public void testReasonWhyInvalidDataSourceName1() {
        this.helpTestReasonWhyInvalid("DataSourceName", "Valid Data Source Name", true);
    }

    public void testReasonWhyInvalidDataSourceName2() {
        this.helpTestReasonWhyInvalid("DataSourceName", "", true);
    }

    public void testReasonWhyInvalidDataSourceName3() {
        this.helpTestReasonWhyInvalid("DataSourceName", "", true);
    }

    public void testReasonWhyInvalidDescription1() {
        this.helpTestReasonWhyInvalid("Description", "Valid App Name", true);
    }

    public void testReasonWhyInvalidDescription2() {
        this.helpTestReasonWhyInvalid("Description", "", true);
    }

    public void testReasonWhyInvalidDescription3() {
        this.helpTestReasonWhyInvalid("Description", null, true);
    }

    public void testReasonWhyInvalidPortNumber1() {
        this.helpTestReasonWhyInvalid("PortNumber", 1, true);
    }

    public void testReasonWhyInvalidPortNumber2() {
        this.helpTestReasonWhyInvalid("PortNumber", 9999999, false);
    }

    public void testReasonWhyInvalidPortNumber3() {
        this.helpTestReasonWhyInvalid("PortNumber", 0, true);
    }

    public void testReasonWhyInvalidPortNumber4() {
        this.helpTestReasonWhyInvalid("PortNumber", -1, false);
    }

    public void testReasonWhyInvalidServerName1() {
        this.helpTestReasonWhyInvalid("ServerName", "Valid Server Name", true);
    }

    public void testReasonWhyInvalidServerName2() {
        this.helpTestReasonWhyInvalid("ServerName", "Valid Server Name", true);
    }

    public void testReasonWhyInvalidServerName3() {
        this.helpTestReasonWhyInvalid("ServerName", "", false);
    }

    public void testReasonWhyInvalidServerName4() {
        this.helpTestReasonWhyInvalid("ServerName", null, false);
    }

    public void testReasonWhyInvalidTransactionAutoWrap1() {
        this.helpTestReasonWhyInvalid("TransactionAutoWrap", "OFF", true);
    }

    public void testReasonWhyInvalidTransactionAutoWrap2() {
        this.helpTestReasonWhyInvalid("TransactionAutoWrap", "ON", true);
    }

    public void testReasonWhyInvalidTransactionAutoWrap3() {
        this.helpTestReasonWhyInvalid("TransactionAutoWrap", STD_TXN_WRAP, true);
    }

    public void testReasonWhyInvalidTransactionAutoWrap5() {
        this.helpTestReasonWhyInvalid("TransactionAutoWrap", "off", false);
    }

    public void testReasonWhyInvalidTransactionAutoWrap6() {
        this.helpTestReasonWhyInvalid("TransactionAutoWrap", "Invalid AutoWrap", false);
    }

    public void testreasonWhyInvalidPartialResultsMode1() {
        this.helpTestReasonWhyInvalid("partialResultsMode", "Invalid partial mode", false);
    }

    public void testreasonWhyInvalidPartialResultsMode2() {
        this.helpTestReasonWhyInvalid("partialResultsMode", "true", true);
    }

    public void testReasonWhyInvalidSocketsPerVM1() {
        this.helpTestReasonWhyInvalid("socketsPerVM", null, true);
    }

    public void testReasonWhyInvalidSocketsPerVM2() {
        this.helpTestReasonWhyInvalid("socketsPerVM", "4", true);
    }

    public void testReasonWhyInvalidSocketsPerVM3() {
        this.helpTestReasonWhyInvalid("socketsPerVM", "-3", false);
    }

    public void testReasonWhyInvalidSocketsPerVM4() {
        this.helpTestReasonWhyInvalid("socketsPerVM", "5.6", false);
    }

    public void testReasonWhyInvalidStickyConnections1() {
        this.helpTestReasonWhyInvalid("stickyConnections", null, true);
    }

    public void testReasonWhyInvalidStickyConnections2() {
        this.helpTestReasonWhyInvalid("stickyConnections", STD_PARTIAL_MODE, true);
    }

    public void testReasonWhyInvalidStickyConnections3() {
        this.helpTestReasonWhyInvalid("stickyConnections", "YES", false);
    }

    public void helpTestAlternateServer(String altServers, boolean valid) {
        block3: {
            this.dataSource.setAlternateServers(altServers);
            try {
                this.dataSource.buildURL();
                if (!valid) {
                    TestTeiidDataSource.fail((String)"expected exception");
                }
            }
            catch (TeiidSQLException e) {
                if (!valid) break block3;
                throw new RuntimeException(e);
            }
        }
    }

    public void testReasonWhyInvalidAlternateServers1() {
        this.helpTestAlternateServer(null, true);
    }

    public void testReasonWhyInvalidAlternateServers2() {
        this.helpTestAlternateServer("", true);
    }

    public void testReasonWhyInvalidAlternateServers3() {
        this.helpTestAlternateServer("server", true);
    }

    public void testReasonWhyInvalidAlternateServers4() {
        this.helpTestAlternateServer("server:100", true);
    }

    public void testReasonWhyInvalidAlternateServers5() {
        this.helpTestAlternateServer("server:port", false);
    }

    public void testReasonWhyInvalidAlternateServers6() {
        this.helpTestAlternateServer("server:100:1", false);
    }

    public void testReasonWhyInvalidAlternateServers7() {
        this.helpTestAlternateServer("server:100:abc", false);
    }

    public void testReasonWhyInvalidAlternateServers8() {
        this.helpTestAlternateServer("server:abc:100", false);
    }

    public void testReasonWhyInvalidAlternateServers9() {
        this.helpTestAlternateServer(":100", false);
    }

    public void testReasonWhyInvalidAlternateServers10() {
        this.helpTestAlternateServer(":abc", false);
    }

    public void testReasonWhyInvalidAlternateServers11() {
        this.helpTestAlternateServer("server1:100,server2", true);
    }

    public void testReasonWhyInvalidAlternateServers12() {
        this.helpTestAlternateServer("server1:100,server2:101", true);
    }

    public void testReasonWhyInvalidAlternateServers13() {
        this.helpTestAlternateServer("server1:100,", true);
    }

    public void testReasonWhyInvalidAlternateServers14() {
        this.helpTestAlternateServer("server1:100,server2:abc", false);
    }

    public void testReasonWhyInvalidAlternateServers15() {
        this.helpTestAlternateServer("server1:100,server2:101:abc", false);
    }

    public void testReasonWhyInvalidAlternateServers16() {
        this.helpTestAlternateServer("server1,server2:100", true);
    }

    public void testReasonWhyInvalidAlternateServers17() {
        this.helpTestAlternateServer("server1,server2", true);
    }

    public void testReasonWhyInvalidAlternateServers18() {
        this.helpTestAlternateServer(",server2:100", false);
    }

    public void testReasonWhyInvalidAlternateServers19() {
        this.helpTestAlternateServer("server1,server2,server3,server4:500", true);
    }

    public void testBuildingURL1() {
        String serverName = "hostName";
        String vdbName = "vdbName";
        String vdbVersion = "1.2.3";
        int portNumber = 7001;
        String transactionAutoWrap = null;
        String partialMode = "true";
        boolean secure = false;
        this.helpTestBuildingURL("vdbName", "1.2.3", "hostName", 7001, null, transactionAutoWrap, "true", 500, false, false, "jdbc:teiid:vdbName@mm://hostname:7001;fetchSize=500;ApplicationName=JDBC;VirtualDatabaseVersion=1.2.3;partialResultsMode=true;VirtualDatabaseName=vdbName");
    }

    public void testBuildingIPv6() {
        String serverName = "3ffe:ffff:0100:f101::1";
        String vdbName = "vdbName";
        String vdbVersion = "1";
        int portNumber = 7001;
        String transactionAutoWrap = null;
        String partialMode = "true";
        boolean secure = false;
        this.helpTestBuildingURL("vdbName", "1", "3ffe:ffff:0100:f101::1", 7001, null, transactionAutoWrap, "true", 500, false, false, "jdbc:teiid:vdbName@mm://[3ffe:ffff:0100:f101::1]:7001;fetchSize=500;ApplicationName=JDBC;VirtualDatabaseVersion=1;partialResultsMode=true;VirtualDatabaseName=vdbName");
    }

    public void testBuildingIPv6WithBrackets() {
        String serverName = "[3ffe:ffff:0100:f101::1]";
        String vdbName = "vdbName";
        String vdbVersion = "1";
        int portNumber = 7001;
        String transactionAutoWrap = null;
        String partialMode = "true";
        boolean secure = false;
        this.helpTestBuildingURL("vdbName", "1", "[3ffe:ffff:0100:f101::1]", 7001, null, transactionAutoWrap, "true", 500, false, false, "jdbc:teiid:vdbName@mm://[3ffe:ffff:0100:f101::1]:7001;fetchSize=500;ApplicationName=JDBC;VirtualDatabaseVersion=1;partialResultsMode=true;VirtualDatabaseName=vdbName");
    }

    public void testBuildingIPv6Alternate() {
        String serverName = "3ffe:ffff:0100:f101::1";
        String vdbName = "vdbName";
        String vdbVersion = "1";
        int portNumber = 7001;
        String transactionAutoWrap = null;
        String partialMode = "true";
        boolean secure = false;
        String alternates = "[::1],127.0.0.1:1234";
        this.helpTestBuildingURL("vdbName", "1", "3ffe:ffff:0100:f101::1", 7001, "[::1],127.0.0.1:1234", transactionAutoWrap, "true", 500, false, false, "jdbc:teiid:vdbName@mm://[3ffe:ffff:0100:f101::1]:7001,[::1]:7001,127.0.0.1:1234;fetchSize=500;ApplicationName=JDBC;VirtualDatabaseVersion=1;partialResultsMode=true;VirtualDatabaseName=vdbName");
    }

    public void testBuildingURL2() {
        String serverName = "hostName";
        String vdbName = "vdbName";
        String vdbVersion = "";
        int portNumber = 7001;
        String transactionAutoWrap = STD_TXN_WRAP;
        String partialMode = STD_PARTIAL_MODE;
        boolean secure = false;
        this.helpTestBuildingURL("vdbName", "", "hostName", 7001, null, STD_TXN_WRAP, STD_PARTIAL_MODE, -1, false, false, "jdbc:teiid:vdbName@mm://hostname:7001;ApplicationName=JDBC;partialResultsMode=false;autoCommitTxn=DETECT;VirtualDatabaseName=vdbName");
    }

    public void testBuildURL3() {
        String serverName = "hostName";
        String vdbName = "vdbName";
        String vdbVersion = "";
        int portNumber = 7001;
        String transactionAutoWrap = STD_TXN_WRAP;
        String partialMode = STD_PARTIAL_MODE;
        boolean secure = false;
        this.helpTestBuildingURL("vdbName", "", "hostName", 7001, null, STD_TXN_WRAP, STD_PARTIAL_MODE, -1, true, false, "jdbc:teiid:vdbName@mm://hostname:7001;ApplicationName=JDBC;SHOWPLAN=ON;partialResultsMode=false;autoCommitTxn=DETECT;VirtualDatabaseName=vdbName");
    }

    public void testBuildURL4() {
        String serverName = "hostName";
        String vdbName = "vdbName";
        String vdbVersion = "";
        int portNumber = 7001;
        String transactionAutoWrap = STD_TXN_WRAP;
        String partialMode = STD_PARTIAL_MODE;
        boolean secure = true;
        this.helpTestBuildingURL("vdbName", "", "hostName", 7001, null, STD_TXN_WRAP, STD_PARTIAL_MODE, -1, true, true, "jdbc:teiid:vdbName@mms://hostname:7001;ApplicationName=JDBC;SHOWPLAN=ON;partialResultsMode=false;autoCommitTxn=DETECT;VirtualDatabaseName=vdbName");
    }

    public void testBuildURL5() {
        String serverName = "hostName";
        String vdbName = "vdbName";
        String vdbVersion = "";
        int portNumber = 7001;
        String alternateServers = "hostName:7002,hostName2:7001,hostName2:7002";
        String transactionAutoWrap = STD_TXN_WRAP;
        String partialMode = STD_PARTIAL_MODE;
        boolean secure = false;
        this.helpTestBuildingURL("vdbName", "", "hostName", 7001, "hostName:7002,hostName2:7001,hostName2:7002", STD_TXN_WRAP, STD_PARTIAL_MODE, -1, true, false, "jdbc:teiid:vdbName@mm://hostName:7001,hostName:7002,hostName2:7001,hostName2:7002;ApplicationName=JDBC;SHOWPLAN=ON;partialResultsMode=false;autoCommitTxn=DETECT;VirtualDatabaseName=vdbName");
    }

    public void testBuildURL6() {
        String serverName = "hostName";
        String vdbName = "vdbName";
        String vdbVersion = "";
        int portNumber = 7001;
        String alternateServers = "hostName:7002,hostName2:7001,hostName2:7002";
        String transactionAutoWrap = STD_TXN_WRAP;
        String partialMode = STD_PARTIAL_MODE;
        boolean secure = true;
        this.helpTestBuildingURL("vdbName", "", "hostName", 7001, "hostName:7002,hostName2:7001,hostName2:7002", STD_TXN_WRAP, STD_PARTIAL_MODE, -1, true, true, "jdbc:teiid:vdbName@mms://hostName:7001,hostName:7002,hostName2:7001,hostName2:7002;ApplicationName=JDBC;SHOWPLAN=ON;partialResultsMode=false;autoCommitTxn=DETECT;VirtualDatabaseName=vdbName");
    }

    public void testBuildURL7() {
        String serverName = "hostName";
        String vdbName = "vdbName";
        String vdbVersion = "";
        int portNumber = 7001;
        String alternateServers = "hostName:7002,hostName2,hostName2:7002";
        String transactionAutoWrap = STD_TXN_WRAP;
        String partialMode = STD_PARTIAL_MODE;
        boolean secure = false;
        this.helpTestBuildingURL("vdbName", "", "hostName", 7001, "hostName:7002,hostName2,hostName2:7002", STD_TXN_WRAP, STD_PARTIAL_MODE, -1, true, false, "jdbc:teiid:vdbName@mm://hostName:7001,hostName:7002,hostName2:7001,hostName2:7002;ApplicationName=JDBC;SHOWPLAN=ON;partialResultsMode=false;autoCommitTxn=DETECT;VirtualDatabaseName=vdbName");
    }

    public void testBuildURL8() {
        String serverName = "hostName";
        String vdbName = "vdbName";
        String vdbVersion = "1.2.3";
        int portNumber = 7001;
        String transactionAutoWrap = null;
        String partialMode = "true";
        boolean secure = false;
        this.helpTestBuildingURL2("vdbName", "1.2.3", "hostName", 7001, null, transactionAutoWrap, "true", 500, false, false, false, "jdbc:teiid:vdbName@mm://hostname:7001;fetchSize=500;ApplicationName=JDBC;VirtualDatabaseVersion=1.2.3;partialResultsMode=true;useJDBC4ColumnNameAndLabelSemantics=false;VirtualDatabaseName=vdbName");
    }

    public void testBuildURL_AdditionalProperties() throws TeiidSQLException {
        TeiidDataSource ds = new TeiidDataSource();
        ds.setAdditionalProperties("foo=bar;a=b");
        ds.setServerName("hostName");
        ds.setDatabaseName("vdbName");
        ds.setPortNumber(1);
        TestTeiidDataSource.assertEquals((String)"jdbc:teiid:vdbName@mm://hostname:1;fetchSize=2048;ApplicationName=JDBC;a=b;VirtualDatabaseName=vdbName;foo=bar", (String)ds.buildURL().getJDBCURL());
    }

    public void testInvalidDataSource() {
        String serverName = "hostName";
        String vdbName = "vdbName";
        String vdbVersion = "";
        int portNumber = -1;
        String dataSourceName = null;
        String transactionAutoWrap = null;
        String configFile = UnitTestUtil.getTestDataPath() + "/config.txt";
        try {
            this.helpTestConnection("vdbName", "", "hostName", -1, null, null, null, dataSourceName, transactionAutoWrap, STD_PARTIAL_MODE, configFile);
            TestTeiidDataSource.fail((String)"Unexpectedly able to connect");
        }
        catch (SQLException e) {
            // empty catch block
        }
    }

    public void testInvalidDataSource2() {
        String serverName = "hostName";
        String vdbName = "vdbName";
        String vdbVersion = "";
        int portNumber = 31000;
        String alternateServers = "hostName:-1";
        String dataSourceName = null;
        String transactionAutoWrap = null;
        String configFile = UnitTestUtil.getTestDataPath() + "/config.txt";
        try {
            this.helpTestConnection("vdbName", "", "hostName", 31000, "hostName:-1", null, null, dataSourceName, transactionAutoWrap, STD_PARTIAL_MODE, configFile);
            TestTeiidDataSource.fail((String)"Unexpectedly able to connect");
        }
        catch (SQLException e) {
            // empty catch block
        }
    }
}

