/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.teiid.client.metadata.ResultsMetadataConstants;
import org.teiid.core.types.JDBCSQLTypeInfo;
import org.teiid.jdbc.MetadataProvider;
import org.teiid.jdbc.WrapperImpl;

public class ResultSetMetaDataImpl
extends WrapperImpl
implements ResultSetMetaData {
    private MetadataProvider provider;
    private boolean useJDBC4ColumnNameAndLabelSemantics = true;

    public ResultSetMetaDataImpl(MetadataProvider provider, String supportBackwardsCompatibility) {
        this.provider = provider;
        if (supportBackwardsCompatibility != null) {
            this.useJDBC4ColumnNameAndLabelSemantics = Boolean.parseBoolean(supportBackwardsCompatibility);
        }
    }

    private int adjustColumn(int index) {
        return index - 1;
    }

    public String getVirtualDatabaseName(int index) throws SQLException {
        return this.provider.getStringValue(this.adjustColumn(index), ResultsMetadataConstants.VIRTUAL_DATABASE_NAME);
    }

    public String getVirtualDatabaseVersion(int index) throws SQLException {
        return this.provider.getStringValue(this.adjustColumn(index), ResultsMetadataConstants.VIRTUAL_DATABASE_VERSION);
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.provider.getColumnCount();
    }

    @Override
    public boolean isAutoIncrement(int index) throws SQLException {
        return this.provider.getBooleanValue(this.adjustColumn(index), ResultsMetadataConstants.AUTO_INCREMENTING);
    }

    @Override
    public boolean isCaseSensitive(int index) throws SQLException {
        return this.provider.getBooleanValue(this.adjustColumn(index), ResultsMetadataConstants.CASE_SENSITIVE);
    }

    @Override
    public boolean isSearchable(int index) throws SQLException {
        Integer searchable = (Integer)this.provider.getValue(this.adjustColumn(index), ResultsMetadataConstants.SEARCHABLE);
        return !ResultsMetadataConstants.SEARCH_TYPES.UNSEARCHABLE.equals(searchable);
    }

    @Override
    public boolean isCurrency(int index) throws SQLException {
        return this.provider.getBooleanValue(this.adjustColumn(index), ResultsMetadataConstants.CURRENCY);
    }

    @Override
    public int isNullable(int index) throws SQLException {
        Object nullable = this.provider.getValue(this.adjustColumn(index), ResultsMetadataConstants.NULLABLE);
        if (nullable.equals(ResultsMetadataConstants.NULL_TYPES.NULLABLE)) {
            return 1;
        }
        if (nullable.equals(ResultsMetadataConstants.NULL_TYPES.NOT_NULL)) {
            return 0;
        }
        return 2;
    }

    @Override
    public boolean isSigned(int index) throws SQLException {
        return this.provider.getBooleanValue(this.adjustColumn(index), ResultsMetadataConstants.SIGNED);
    }

    @Override
    public int getColumnDisplaySize(int index) throws SQLException {
        return this.provider.getIntValue(this.adjustColumn(index), ResultsMetadataConstants.DISPLAY_SIZE);
    }

    @Override
    public String getColumnLabel(int index) throws SQLException {
        String result = this.provider.getStringValue(this.adjustColumn(index), ResultsMetadataConstants.ELEMENT_LABEL);
        if (result != null) {
            return result;
        }
        return this.getColumnName(index);
    }

    @Override
    public String getColumnName(int index) throws SQLException {
        String result;
        if (!this.useJDBC4ColumnNameAndLabelSemantics && (result = this.provider.getStringValue(this.adjustColumn(index), ResultsMetadataConstants.ELEMENT_LABEL)) != null) {
            return result;
        }
        return this.provider.getStringValue(this.adjustColumn(index), ResultsMetadataConstants.ELEMENT_NAME);
    }

    @Override
    public String getSchemaName(int index) throws SQLException {
        int dotIndex;
        String name = this.provider.getStringValue(this.adjustColumn(index), ResultsMetadataConstants.GROUP_NAME);
        if (name != null && (dotIndex = name.indexOf(46)) != -1) {
            return name.substring(0, dotIndex);
        }
        return null;
    }

    @Override
    public int getPrecision(int index) throws SQLException {
        return this.provider.getIntValue(this.adjustColumn(index), ResultsMetadataConstants.PRECISION);
    }

    @Override
    public int getScale(int index) throws SQLException {
        return this.provider.getIntValue(this.adjustColumn(index), ResultsMetadataConstants.SCALE);
    }

    @Override
    public String getTableName(int index) throws SQLException {
        int dotIndex;
        String name = this.provider.getStringValue(this.adjustColumn(index), ResultsMetadataConstants.GROUP_NAME);
        if (name != null && (dotIndex = name.indexOf(46)) != -1) {
            return name.substring(dotIndex + 1);
        }
        return name;
    }

    @Override
    public String getCatalogName(int index) throws SQLException {
        return this.provider.getStringValue(this.adjustColumn(index), ResultsMetadataConstants.VIRTUAL_DATABASE_NAME);
    }

    @Override
    public int getColumnType(int index) throws SQLException {
        String runtimeTypeName = this.getColumnTypeName(index);
        return JDBCSQLTypeInfo.getSQLType((String)runtimeTypeName);
    }

    @Override
    public String getColumnTypeName(int index) throws SQLException {
        return this.provider.getStringValue(this.adjustColumn(index), ResultsMetadataConstants.DATA_TYPE);
    }

    @Override
    public boolean isReadOnly(int index) throws SQLException {
        return !this.provider.getBooleanValue(this.adjustColumn(index), ResultsMetadataConstants.WRITABLE);
    }

    @Override
    public boolean isWritable(int index) throws SQLException {
        return this.provider.getBooleanValue(this.adjustColumn(index), ResultsMetadataConstants.WRITABLE);
    }

    @Override
    public boolean isDefinitelyWritable(int index) throws SQLException {
        return this.provider.getBooleanValue(this.adjustColumn(index), ResultsMetadataConstants.WRITABLE);
    }

    @Override
    public String getColumnClassName(int index) throws SQLException {
        return JDBCSQLTypeInfo.getJavaClassName((int)this.getColumnType(index));
    }
}

