/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.sql.SQLException;
import java.util.Properties;
import junit.framework.TestCase;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.teiid.client.DQP;
import org.teiid.client.security.LogonResult;
import org.teiid.client.security.SessionToken;
import org.teiid.client.util.ResultsFuture;
import org.teiid.client.xa.XATransactionException;
import org.teiid.client.xa.XidImpl;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.TeiidDriver;
import org.teiid.net.ServerConnection;

public class TestConnection
extends TestCase {
    protected static final String STD_DATABASE_NAME = "QT_Ora9DS";
    protected static final int STD_DATABASE_VERSION = 1;
    static String serverUrl = "jdbc:teiid:QT_Ora9DS@mm://localhost:7001;version=1;user=metamatrixadmin;password=mm";

    public TestConnection(String name) {
        super(name);
    }

    public static ConnectionImpl getMMConnection() {
        return TestConnection.getMMConnection(serverUrl);
    }

    public static ConnectionImpl getMMConnection(String url) {
        ServerConnection mock = (ServerConnection)Mockito.mock(ServerConnection.class);
        DQP dqp = (DQP)Mockito.mock(DQP.class);
        try {
            Mockito.stub((Object)dqp.start((XidImpl)Mockito.anyObject(), Mockito.anyInt(), Mockito.anyInt())).toAnswer(new Answer(){

                public Object answer(InvocationOnMock invocation) throws Throwable {
                    return ResultsFuture.NULL_FUTURE;
                }
            });
            Mockito.stub((Object)dqp.rollback((XidImpl)Mockito.anyObject())).toAnswer(new Answer(){

                public Object answer(InvocationOnMock invocation) throws Throwable {
                    return ResultsFuture.NULL_FUTURE;
                }
            });
            Mockito.stub((Object)dqp.rollback()).toAnswer(new Answer(){

                public Object answer(InvocationOnMock invocation) throws Throwable {
                    return ResultsFuture.NULL_FUTURE;
                }
            });
        }
        catch (XATransactionException e) {
            throw new RuntimeException(e);
        }
        Properties props = new Properties();
        try {
            new InnerDriver(url).parseUrl(props);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        Mockito.stub((Object)mock.getService(DQP.class)).toReturn((Object)dqp);
        Mockito.stub((Object)mock.getLogonResult()).toReturn((Object)new LogonResult(new SessionToken(1L, "admin"), STD_DATABASE_NAME, 1, "fake"));
        return new ConnectionImpl(mock, props, url);
    }

    public void testGetMetaData() throws Exception {
        TestConnection.assertNotNull((Object)TestConnection.getMMConnection().getMetaData());
    }

    public void testGetSchema() throws Exception {
        TestConnection.assertEquals((String)"Actual schema is not equql to the expected one. ", (String)STD_DATABASE_NAME, (String)TestConnection.getMMConnection().getVDBName());
    }

    public void testNativeSql() throws Exception {
        String sql = "SELECT * FROM BQT1.SmallA";
        TestConnection.assertEquals((String)"Actual schema is not equql to the expected one. ", (String)sql, (String)TestConnection.getMMConnection().nativeSQL(sql));
    }

    public void testGetUserName2() throws Exception {
        TestConnection.assertEquals((String)"Actual userName is not equal to the expected one. ", (String)"admin", (String)TestConnection.getMMConnection().getUserName());
    }

    public void testIsReadOnly() throws Exception {
        TestConnection.assertEquals((boolean)false, (boolean)TestConnection.getMMConnection().isReadOnly());
    }

    public void testSetReadOnly1() throws Exception {
        ConnectionImpl conn = TestConnection.getMMConnection();
        conn.setReadOnly(true);
        TestConnection.assertEquals((boolean)true, (boolean)conn.isReadOnly());
    }

    public void testSetReadOnly2() throws Exception {
        ConnectionImpl conn = TestConnection.getMMConnection();
        conn.setAutoCommit(false);
        try {
            conn.setReadOnly(true);
            TestConnection.fail((String)"Error Expected");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void testDefaultSpec() throws Exception {
        TestConnection.assertEquals((String)"true", (String)(TestConnection.getMMConnection().getExecutionProperties().getProperty("useJDBC4ColumnNameAndLabelSemantics") == null ? "true" : "false"));
    }

    public void testTurnOnSpec() throws Exception {
        TestConnection.assertEquals((String)"true", (String)TestConnection.getMMConnection(serverUrl + ";useJDBC4ColumnNameAndLabelSemantics=true").getExecutionProperties().getProperty("useJDBC4ColumnNameAndLabelSemantics"));
    }

    public void testTurnOffSpec() throws Exception {
        TestConnection.assertEquals((String)"false", (String)TestConnection.getMMConnection(serverUrl + ";useJDBC4ColumnNameAndLabelSemantics=false").getExecutionProperties().getProperty("useJDBC4ColumnNameAndLabelSemantics"));
    }

    static class InnerDriver
    extends TeiidDriver {
        String iurl = null;

        public InnerDriver(String url) {
            this.iurl = url;
        }

        public void parseUrl(Properties props) throws SQLException {
            TeiidDriver.parseURL((String)this.iurl, (Properties)props);
        }
    }
}

