/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.sql.SQLException;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.client.ProcedureErrorInstructionException;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.jdbc.TeiidSQLException;
import org.teiid.net.CommunicationException;
import org.teiid.net.ConnectionException;

public class TestSQLException {
    @Test
    public void testMMSQLException() {
        TeiidSQLException e = new TeiidSQLException();
        String sqlState = e.getSQLState();
        Throwable cause = e.getCause();
        int errorCode = e.getErrorCode();
        Throwable nestedException = e.getCause();
        SQLException nextException = e.getNextException();
        Assert.assertTrue((String)("Expected MMSQLException.getSQLState() to return <null> but got \"" + sqlState + "\" instead."), (sqlState == null ? 1 : 0) != 0);
        Assert.assertTrue((String)("Expected MMSQLException.getCause() to return <null> but got [" + (cause != null ? cause.getClass().getName() : "<unknown>") + "] instead."), (cause == null ? 1 : 0) != 0);
        Assert.assertTrue((String)("Expected MMSQLException.getErrorCode() to return [0] but got [" + errorCode + "] instead."), (errorCode == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Expected MMSQLException.getNestedException() to return <null> but got [" + (nestedException != null ? nestedException.getClass().getName() : "<unknown>") + "] instead."), (nestedException == null ? 1 : 0) != 0);
        Assert.assertTrue((String)("Expected MMSQLException.getNextException() to return <null> but got a SQLException with message \"" + (nextException != null ? nextException.getMessage() : "") + "\" instead."), (nextException == null ? 1 : 0) != 0);
    }

    @Test
    public void testCreateThrowable_01() {
        this.testCreateThrowable((Throwable)new CommunicationException("A test MM Communication Exception"), "08S01");
        this.testCreateThrowable(new ConnectException("A test connection attempt exception"), "08001");
        this.testCreateThrowable((Throwable)new ConnectionException("A test MM Connection Exception"), "08001");
        this.testCreateThrowable(new IOException("A test Generic java.io.IOException"), "08S01");
        this.testCreateThrowable(new MalformedURLException("A test java.net.MalformedURLException"), "08001");
        this.testCreateThrowable((Throwable)new TeiidException("A test Generic MM Core Exception"), "38000");
        this.testCreateThrowable((Throwable)new TeiidException("A test MM Exception"), "38000");
        this.testCreateThrowable(new TeiidProcessingException("A test Generic MM Query Processing Exception"), "50000");
        this.testCreateThrowable((Throwable)new TeiidRuntimeException("A test MM Runtime Exception"), "38000");
        this.testCreateThrowable((Throwable)new TeiidSQLException("A test Generic MM SQL Exception"), "38000");
        this.testCreateThrowable(new NoRouteToHostException("A test java.net.NoRouteToHostException"), "08001");
        this.testCreateThrowable(new NullPointerException("A test NPE"), "38000");
        this.testCreateThrowable((Throwable)new ProcedureErrorInstructionException("A test SQL Procedure Error exception"), "50001");
        this.testCreateThrowable(new SocketTimeoutException("A test socket timeout exception"), "08S01");
        this.testCreateThrowable(new UnknownHostException("A test connection attempt exception"), "08001");
    }

    @Test
    public void testCreateThrowable_02() {
        this.testCreateThrowable((Throwable)new CommunicationException((Throwable)new ConnectException("A test java.net.ConnectException"), "Test Communication Exception with a ConnectException in it"), "08001");
        this.testCreateThrowable((Throwable)new CommunicationException((Throwable)new SocketException("A test java.net.SocketException"), "Test Communication Exception with a SocketException in it"), "08S01");
        this.testCreateThrowable((Throwable)new TeiidException((Throwable)new SocketTimeoutException("A test java.net.SocketTimeoutException"), "Test MetaMatrixException with a SocketTimeoutException in it"), "08S01");
    }

    @Test
    public void testCreateThrowable3() {
        TeiidSQLException e = this.testCreateThrowable((Throwable)new TeiidException((Throwable)new SocketTimeoutException("A test MM Invalid Session Exception"), "Test MetaMatrixRuntimeException with a InvalidSessionException in it"), "08S01");
        TeiidSQLException e1 = TeiidSQLException.create((Throwable)e, (String)"new message");
        Assert.assertEquals((Object)"new message", (Object)e1.getMessage());
        this.testCreateThrowable(((TeiidSQLException)e1.getCause()).getCause(), "08S01");
    }

    private TeiidSQLException testCreateThrowable(Throwable ecause, String esqlState) {
        TeiidSQLException e = TeiidSQLException.create((Throwable)ecause);
        if (ecause.getClass() == TeiidSQLException.class) {
            ecause = null;
        }
        String sqlState = e.getSQLState();
        Throwable cause = e.getCause();
        int errorCode = e.getErrorCode();
        Throwable nestedException = e.getCause();
        SQLException nextException = e.getNextException();
        Assert.assertEquals((Object)esqlState, (Object)sqlState);
        Assert.assertEquals((Object)ecause, (Object)cause);
        Assert.assertEquals((long)0L, (long)errorCode);
        Assert.assertEquals((Object)nestedException, (Object)ecause);
        Assert.assertNull((Object)nextException);
        return e;
    }

    @Test
    public void testCreate() {
        TeiidSQLException exception = TeiidSQLException.create((Throwable)new Exception());
        Assert.assertEquals((Object)exception.getMessage(), (Object)Exception.class.getName());
        Assert.assertNotNull((Object)exception.getSQLState());
        Assert.assertEquals((Object)exception.getSQLState(), (Object)"38000");
        Assert.assertEquals((Object)exception, (Object)TeiidSQLException.create((Throwable)exception));
    }

    @Test
    public void testCreateFromSQLException() {
        SQLException sqlexception = new SQLException("foo", "21");
        SQLException nested = new SQLException("bar");
        sqlexception.setNextException(nested);
        String message = "top level message";
        TeiidSQLException exception = TeiidSQLException.create((Throwable)sqlexception, (String)message);
        Assert.assertEquals((Object)exception.getMessage(), (Object)message);
        Assert.assertEquals((Object)exception.getSQLState(), (Object)sqlexception.getSQLState());
        Assert.assertEquals((Object)exception.getNextException().getMessage(), (Object)sqlexception.getMessage());
        Assert.assertEquals((Object)exception.getNextException().getNextException().getMessage(), (Object)nested.getMessage());
    }

    @Test
    public void testCodeAsVendorCode() {
        TeiidException sqlexception = new TeiidException((BundleUtil.Event)Event.TEIID21, "foo");
        String message = "top level message";
        TeiidSQLException exception = TeiidSQLException.create((Throwable)sqlexception, (String)message);
        Assert.assertEquals((Object)sqlexception.getCode(), (Object)exception.getTeiidCode());
        Assert.assertEquals((long)21L, (long)exception.getErrorCode());
    }

    public static enum Event implements BundleUtil.Event
    {
        TEIID21;

    }
}

