/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.client.BatchSerializer;
import org.teiid.core.types.ArrayImpl;
import org.teiid.core.types.BinaryType;
import org.teiid.core.util.TimestampWithTimezone;
import org.teiid.query.unittest.TimestampUtil;

public class TestBatchSerializer {
    private static final String[] sampleBatchTypes = new String[]{"bigdecimal", "biginteger", "boolean", "byte", "char", "date", "double", "float", "integer", "long", "short", "string", "time", "timestamp", "object", "varbinary"};

    private static void helpTestSerialization(String[] types, List<?>[] batch, byte version) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(byteStream);
        List<List<?>> batchList = Arrays.asList(batch);
        BatchSerializer.writeBatch((ObjectOutput)out, (String[])types, batchList, (byte)version);
        out.flush();
        byte[] bytes = byteStream.toByteArray();
        ByteArrayInputStream bytesIn = new ByteArrayInputStream(bytes);
        ObjectInputStream in = new ObjectInputStream(bytesIn);
        List newBatch = BatchSerializer.readBatch((ObjectInput)in, (String[])types);
        out.close();
        in.close();
        Assert.assertTrue((boolean)((Object)batchList).equals(newBatch));
    }

    private static String sampleString(int length) {
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = (char)i;
        }
        return new String(chars);
    }

    private static List<?>[] sampleBatchWithNulls(int rows) {
        List[] batch = new List[rows];
        for (int i = 0; i < rows; ++i) {
            Date d = new Date();
            int mod = i % 16;
            Object[] objectArray = new Object[16];
            objectArray[0] = mod == 0 ? null : new BigDecimal("" + i);
            Object object = objectArray[1] = mod == 1 ? null : new BigInteger(Integer.toString(i));
            objectArray[2] = mod == 2 ? null : (i % 2 == 0 ? Boolean.FALSE : Boolean.TRUE);
            objectArray[3] = mod == 3 ? null : new Byte((byte)i);
            objectArray[4] = mod == 4 ? null : new Character((char)i);
            objectArray[5] = mod == 5 ? null : TimestampWithTimezone.createDate((Date)d);
            objectArray[6] = mod == 6 ? null : new Double(i);
            objectArray[7] = mod == 7 ? null : new Float(i);
            objectArray[8] = mod == 8 ? null : new Integer(i);
            objectArray[9] = mod == 9 ? null : new Long(i);
            objectArray[10] = mod == 10 ? null : new Short((short)i);
            objectArray[11] = mod == 11 ? null : TestBatchSerializer.sampleString(i);
            objectArray[12] = mod == 12 ? null : TimestampWithTimezone.createTime((Date)d);
            objectArray[13] = mod == 13 ? null : TimestampWithTimezone.createTimestamp((Date)d);
            objectArray[14] = mod == 14 ? null : TimestampWithTimezone.createTimestamp((Date)d);
            objectArray[15] = mod == 15 ? null : new BinaryType(new byte[]{(byte)i});
            Object[] data = objectArray;
            batch[i] = Arrays.asList(data);
        }
        return batch;
    }

    @Test
    public void testSerializeBasicTypes() throws Exception {
        TestBatchSerializer.helpTestSerialization(sampleBatchTypes, TestBatchSerializer.sampleBatchWithNulls(1), (byte)2);
        TestBatchSerializer.helpTestSerialization(sampleBatchTypes, TestBatchSerializer.sampleBatchWithNulls(8), (byte)2);
        TestBatchSerializer.helpTestSerialization(sampleBatchTypes, TestBatchSerializer.sampleBatchWithNulls(17), (byte)2);
        TestBatchSerializer.helpTestSerialization(sampleBatchTypes, TestBatchSerializer.sampleBatchWithNulls(120), (byte)2);
        TestBatchSerializer.helpTestSerialization(sampleBatchTypes, TestBatchSerializer.sampleBatchWithNulls(833), (byte)2);
        TestBatchSerializer.helpTestSerialization(sampleBatchTypes, TestBatchSerializer.sampleBatchWithNulls(4096), (byte)2);
    }

    @Test
    public void testSerializeLargeStrings() throws Exception {
        List<Object> row = Arrays.asList(TestBatchSerializer.sampleString(66666));
        TestBatchSerializer.helpTestSerialization(new String[]{"string"}, new List[]{row}, (byte)2);
    }

    @Test
    public void testSerializeNoData() throws Exception {
        TestBatchSerializer.helpTestSerialization(sampleBatchTypes, new List[0], (byte)2);
    }

    @Test
    public void testSerializeDatatypeMismatch() throws Exception {
        try {
            TestBatchSerializer.helpTestSerialization(new String[]{"double"}, new List[]{Arrays.asList("Hello!")}, (byte)2);
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)"TEIID20001 The modeled datatype double for column 0 doesn't match the runtime type \"java.lang.String\". Please ensure that the column's modeled datatype matches the expected data.", (Object)e.getMessage());
        }
    }

    @Test(expected=IOException.class)
    public void testOutOfRangeDate() throws Exception {
        TestBatchSerializer.helpTestSerialization(new String[]{"date"}, new List[]{Arrays.asList(TimestampUtil.createDate((int)-2, (int)0, (int)1))}, (byte)1);
    }

    @Test
    public void testStringArray() throws IOException, ClassNotFoundException {
        TestBatchSerializer.helpTestSerialization(new String[]{"long", "string[]"}, new List[]{Arrays.asList(1L, new ArrayImpl((Object[])new String[]{"a", "b"}))}, (byte)2);
    }
}

