/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.client.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.SQLException;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.client.util.ExceptionHolder;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.ReflectionHelper;
import org.teiid.core.util.UnitTestUtil;

public class TestExceptionHolder {
    @Test
    public void testDeserializationUnknownException() throws Exception {
        URLClassLoader cl = new URLClassLoader(new URL[]{UnitTestUtil.getTestDataFile((String)"test.jar").toURI().toURL()});
        Object obj = ReflectionHelper.create((String)"test.Test", null, (ClassLoader)cl);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(new ExceptionHolder((Throwable)((Object)new BadException(obj))));
        oos.flush();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
        ExceptionHolder holder = (ExceptionHolder)ois.readObject();
        Assert.assertTrue((boolean)(holder.getException() instanceof BadException));
        Assert.assertEquals((Object)"Remote org.teiid.client.util.TestExceptionHolder$BadException: null", (Object)holder.getException().getMessage());
    }

    @Test
    public void testDeserializationUnknownChildException() throws Exception {
        URLClassLoader cl = new URLClassLoader(new URL[]{UnitTestUtil.getTestDataFile((String)"test.jar").toURI().toURL()});
        Exception obj = (Exception)ReflectionHelper.create((String)"test.UnknownException", null, (ClassLoader)cl);
        obj.initCause(new SQLException("something bad happended"));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(new ExceptionHolder((Throwable)((Object)new BadException2(obj, "I have foreign exception embedded in me"))));
        oos.flush();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
        ExceptionHolder holder = (ExceptionHolder)ois.readObject();
        Throwable e = holder.getException();
        Assert.assertTrue((boolean)(e instanceof BadException2));
        Assert.assertEquals((Object)"Remote org.teiid.client.util.TestExceptionHolder$BadException2: I have foreign exception embedded in me", (Object)e.getMessage());
        e = e.getCause();
        Assert.assertTrue((boolean)(e instanceof TeiidRuntimeException));
        e = e.getCause();
        Assert.assertTrue((boolean)(e instanceof SQLException));
        Assert.assertEquals((Object)"Remote java.sql.SQLException: something bad happended", (Object)e.getMessage());
    }

    @Test
    public void testSQLExceptionChain() throws Exception {
        URLClassLoader cl = new URLClassLoader(new URL[]{UnitTestUtil.getTestDataFile((String)"test.jar").toURI().toURL()});
        Exception obj = (Exception)ReflectionHelper.create((String)"test.UnknownException", null, (ClassLoader)cl);
        SQLException se = new SQLException("something bad happended");
        se.initCause(obj);
        SQLException se1 = new SQLException("something else bad happended");
        se1.initCause(obj);
        se.setNextException(se1);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(new ExceptionHolder((Throwable)se, false));
        oos.flush();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
        ExceptionHolder holder = (ExceptionHolder)ois.readObject();
        Throwable e = holder.getException();
        Assert.assertTrue((boolean)(e instanceof SQLException));
        Assert.assertEquals((Object)"Remote java.sql.SQLException: something bad happended", (Object)e.getMessage());
        Assert.assertTrue((boolean)(e.getCause() instanceof TeiidRuntimeException));
        e = ((SQLException)e).getNextException();
        Assert.assertTrue((boolean)(e instanceof SQLException));
        Assert.assertEquals((Object)"Remote java.sql.SQLException: something else bad happended", (Object)e.getMessage());
    }

    @Test
    public void testDeserializationUnknownChildException2() throws Exception {
        URLClassLoader cl = new URLClassLoader(new URL[]{UnitTestUtil.getTestDataFile((String)"test.jar").toURI().toURL()});
        ArrayList<String> args = new ArrayList<String>();
        args.add("Unknown Exception");
        Exception obj = (Exception)ReflectionHelper.create((String)"test.UnknownException", args, (ClassLoader)cl);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(new ExceptionHolder((Throwable)obj));
        oos.flush();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
        ExceptionHolder holder = (ExceptionHolder)ois.readObject();
        Throwable e = holder.getException();
        Assert.assertTrue((boolean)(e instanceof TeiidRuntimeException));
        Assert.assertEquals((Object)"Remote test.UnknownException: Unknown Exception", (Object)e.getMessage());
    }

    @Test
    public void testDeserializationNotSerializable() throws Exception {
        TeiidException ex = new TeiidException(){
            NotSerializable ns = new NotSerializable();
        };
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(new ExceptionHolder((Throwable)ex));
        oos.flush();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
        ExceptionHolder holder = (ExceptionHolder)ois.readObject();
        Throwable e = holder.getException();
        Assert.assertTrue((boolean)(e instanceof TeiidException));
    }

    private static class NotSerializable {
        private NotSerializable() {
        }
    }

    public static class BadException2
    extends TeiidProcessingException {
        public BadException2(String msg) {
            super(msg);
        }

        public BadException2(Throwable e, String msg) {
            super(e, msg);
        }
    }

    public static class BadException
    extends TeiidProcessingException {
        private Object obj;

        public BadException(String msg) {
            super(msg);
        }

        public BadException(Object obj) {
            this.obj = obj;
        }
    }
}

