/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.net.URLEncoder;
import java.util.Properties;
import junit.framework.TestCase;
import org.teiid.jdbc.JDBCURL;

public class TestJDBCURL
extends TestCase {
    public final void testCredentials() throws Exception {
        String credentials = URLEncoder.encode("defaultToLogon,(system=BQT1 SQL Server 2000 Simple Cap,user=xyz,password=xyz)", "UTF-8");
        JDBCURL url = new JDBCURL("jdbc:teiid:QT_sqls2kds@mm://slwxp136:43100;credentials=" + credentials);
        Properties p = url.getProperties();
        TestJDBCURL.assertEquals((String)"defaultToLogon,(system=BQT1 SQL Server 2000 Simple Cap,user=xyz,password=xyz)", (String)p.getProperty("credentials"));
    }

    public void testJDBCURLWithProperties() {
        String URL = "jdbc:teiid:bqt@mm://localhost:12345;version=1;user=%25xyz;password=***;logLevel=1;configFile=testdata/bqt/dqp_stmt_e2e.xmi;disableLocalTxn=true;autoFailover=false";
        Properties expectedProperties = new Properties();
        expectedProperties.setProperty("version", "1");
        expectedProperties.setProperty("user", "%xyz");
        expectedProperties.setProperty("password", "***");
        expectedProperties.setProperty("logLevel", "1");
        expectedProperties.setProperty("configFile", "testdata/bqt/dqp_stmt_e2e.xmi");
        expectedProperties.setProperty("disableLocalTxn", "true");
        expectedProperties.setProperty("autoFailover", "false");
        JDBCURL url = new JDBCURL(URL);
        TestJDBCURL.assertEquals((String)"bqt", (String)url.getVDBName());
        TestJDBCURL.assertEquals((String)"mm://localhost:12345", (String)url.getConnectionURL());
        TestJDBCURL.assertEquals((Object)expectedProperties, (Object)url.getProperties());
        TestJDBCURL.assertTrue((boolean)url.getJDBCURL().contains("user=%25xyz"));
    }

    public void testJDBCURLWithoutProperties() {
        String URL = "jdbc:teiid:bqt@mm://localhost:12345";
        JDBCURL url = new JDBCURL(URL);
        TestJDBCURL.assertEquals((String)"bqt", (String)url.getVDBName());
        TestJDBCURL.assertEquals((String)"mm://localhost:12345", (String)url.getConnectionURL());
        TestJDBCURL.assertEquals((Object)new Properties(), (Object)url.getProperties());
    }

    public void testCaseConversion() {
        String URL = "jdbc:teiid:bqt@mm://localhost:12345;VERSION=1;user=xyz;password=***;configFile=testdata/bqt/dqp_stmt_e2e.xmi";
        Properties expectedProperties = new Properties();
        expectedProperties.setProperty("version", "1");
        expectedProperties.setProperty("user", "xyz");
        expectedProperties.setProperty("password", "***");
        expectedProperties.setProperty("configFile", "testdata/bqt/dqp_stmt_e2e.xmi");
        JDBCURL url = new JDBCURL(URL);
        TestJDBCURL.assertEquals((String)"bqt", (String)url.getVDBName());
        TestJDBCURL.assertEquals((String)"mm://localhost:12345", (String)url.getConnectionURL());
        TestJDBCURL.assertEquals((Object)expectedProperties, (Object)url.getProperties());
    }

    public void testWithExtraSemicolons() {
        String URL = "jdbc:teiid:bqt@mm://localhost:12345;version=1;user=xyz;password=***;logLevel=1;;;configFile=testdata/bqt/dqp_stmt_e2e.xmi;;";
        Properties expectedProperties = new Properties();
        expectedProperties.setProperty("version", "1");
        expectedProperties.setProperty("user", "xyz");
        expectedProperties.setProperty("password", "***");
        expectedProperties.setProperty("logLevel", "1");
        expectedProperties.setProperty("configFile", "testdata/bqt/dqp_stmt_e2e.xmi");
        JDBCURL url = new JDBCURL(URL);
        TestJDBCURL.assertEquals((String)"bqt", (String)url.getVDBName());
        TestJDBCURL.assertEquals((String)"mm://localhost:12345", (String)url.getConnectionURL());
        TestJDBCURL.assertEquals((Object)expectedProperties, (Object)url.getProperties());
    }

    public void testWithWhitespace() {
        String URL = "jdbc:teiid:bqt@mm://localhost:12345; version =1;user= xyz ;password=***; logLevel = 1 ; configFile=testdata/bqt/dqp_stmt_e2e.xmi ;";
        Properties expectedProperties = new Properties();
        expectedProperties.setProperty("version", "1");
        expectedProperties.setProperty("user", "xyz");
        expectedProperties.setProperty("password", "***");
        expectedProperties.setProperty("logLevel", "1");
        expectedProperties.setProperty("configFile", "testdata/bqt/dqp_stmt_e2e.xmi");
        JDBCURL url = new JDBCURL(URL);
        TestJDBCURL.assertEquals((String)"bqt", (String)url.getVDBName());
        TestJDBCURL.assertEquals((String)"mm://localhost:12345", (String)url.getConnectionURL());
        TestJDBCURL.assertEquals((Object)expectedProperties, (Object)url.getProperties());
    }

    public void testNoPropertyValue() {
        String URL = "jdbc:teiid:bqt@mm://localhost:12345;version=1;user=xyz;password=***;logLevel=;configFile=";
        Properties expectedProperties = new Properties();
        expectedProperties.setProperty("version", "1");
        expectedProperties.setProperty("user", "xyz");
        expectedProperties.setProperty("password", "***");
        expectedProperties.setProperty("logLevel", "");
        expectedProperties.setProperty("configFile", "");
        JDBCURL url = new JDBCURL(URL);
        TestJDBCURL.assertEquals((String)"bqt", (String)url.getVDBName());
        TestJDBCURL.assertEquals((String)"mm://localhost:12345", (String)url.getConnectionURL());
        TestJDBCURL.assertEquals((Object)expectedProperties, (Object)url.getProperties());
    }

    public void testInvalidProtocol() {
        String URL = "jdbc:monkeymatrix:bqt@mm://localhost:12345;version=1;user=xyz;password=***;logLevel=1";
        try {
            new JDBCURL(URL);
            TestJDBCURL.fail((String)"Illegal argument should have failed.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNoVDBName() {
        String URL = "jdbc:teiid:@mm://localhost:12345;version=1;user=xyz;password=***;logLevel=1";
        try {
            new JDBCURL(URL);
            TestJDBCURL.fail((String)"Illegal argument should have failed.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNoAtSignInURL() {
        String URL = "jdbc:teiid:bqt!mm://localhost:12345;version=1;user=xyz;password=***;logLevel=1";
        try {
            new JDBCURL(URL);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMoreThanOneAtSign() {
        String URL = "jdbc:teiid:bqt@mm://localhost:12345;version=1;user=xy@;password=***;logLevel=1";
        try {
            new JDBCURL(URL);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNoEqualsInProperty() {
        String URL = "jdbc:teiid:bqt@mm://localhost:12345;version=1;user=xyz;password***;logLevel=1";
        try {
            new JDBCURL(URL);
            TestJDBCURL.fail((String)"Illegal argument should have failed.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMoreThanOneEqualsInProperty() {
        String URL = "jdbc:teiid:bqt@mm://localhost:12345;version=1;user=xyz;password==***;logLevel=1";
        try {
            new JDBCURL(URL);
            TestJDBCURL.fail((String)"Illegal argument should have failed.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        URL = "jdbc:teiid:bqt@mm://localhost:12345;version=1;user=xyz;password=***=;logLevel=1";
        try {
            new JDBCURL(URL);
            TestJDBCURL.fail((String)"Illegal argument should have failed.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        URL = "jdbc:teiid:bqt@mm://localhost:12345;version=1;user=xyz;=password=***;logLevel=1";
        try {
            new JDBCURL(URL);
            TestJDBCURL.fail((String)"Illegal argument should have failed.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNoKeyInProperty() {
        String URL = "jdbc:teiid:bqt@mm://localhost:12345;version=1;user=xyz;=***;logLevel=1";
        try {
            new JDBCURL(URL);
            TestJDBCURL.fail((String)"Illegal argument should have failed.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor() {
        JDBCURL url = new JDBCURL("myVDB", "mm://myhost:12345", null);
        TestJDBCURL.assertEquals((String)"jdbc:teiid:myVDB@mm://myhost:12345", (String)url.getJDBCURL());
        Properties props = new Properties();
        props.setProperty("user", "myuser");
        props.setProperty("password", "mypassword");
        props.put("ClieNTtOKeN", new Integer(1));
        url = new JDBCURL("myVDB", "mm://myhost:12345", props);
        TestJDBCURL.assertEquals((String)"jdbc:teiid:myVDB@mm://myhost:12345;user=myuser;password=mypassword", (String)url.getJDBCURL());
    }

    public void testConstructor_Exception() {
        try {
            new JDBCURL(null, "myhost", null);
            TestJDBCURL.fail((String)"Should have failed.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            new JDBCURL("  ", "myhost", null);
            TestJDBCURL.fail((String)"Should have failed.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            new JDBCURL("myVDB", "  ", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testNormalize() {
        Properties props = new Properties();
        props.setProperty("UsEr", "myuser");
        props.setProperty("pAssWOrD", "mypassword");
        props.put("ClieNTtOKeN", new Integer(1));
        JDBCURL.normalizeProperties((Properties)props);
        TestJDBCURL.assertEquals((String)"myuser", (String)props.getProperty("user"));
        TestJDBCURL.assertEquals((String)"mypassword", (String)props.getProperty("password"));
    }

    public final void testEncodedPropertyProperties() throws Exception {
        String password = "=@#^&*()+!%$^%@#_-)_~{}||\\`':;,./<>?password has = & %";
        Properties props = new Properties();
        props.setProperty("UsEr", "foo");
        props.setProperty("PASswoRd", password);
        JDBCURL.normalizeProperties((Properties)props);
        TestJDBCURL.assertEquals((String)password, (String)props.getProperty("password"));
        TestJDBCURL.assertEquals((String)"foo", (String)props.getProperty("user"));
    }

    public final void testEncodedPropertyInURL() throws Exception {
        String password = "=@#^&*()+!%$^%@#_-)_~{}||\\`':;,./<>?password has = & %";
        String encPassword = URLEncoder.encode(password, "UTF-8");
        JDBCURL url = new JDBCURL("jdbc:teiid:QT_sqls2kds@mm://slwxp136:43100;PASswoRd=" + encPassword);
        Properties p = url.getProperties();
        TestJDBCURL.assertEquals((String)password, (String)p.getProperty("password"));
    }

    public void testGetServerURL_NoProperties() {
        String result = new JDBCURL("jdbc:teiid:designtimecatalog@mm://slwxp172:44401;user=ddifranco;password=mm").getConnectionURL();
        TestJDBCURL.assertEquals((String)"mm://slwxp172:44401", (String)result);
    }

    public void testGetServerURL_Properties() {
        String result = new JDBCURL("jdbc:teiid:designtimecatalog@mm://slwxp172:44401;user=ddifranco;password=mm").getConnectionURL();
        TestJDBCURL.assertEquals((String)"mm://slwxp172:44401", (String)result);
    }

    public void testGetServerURL_PasswordProperties() throws Exception {
        String result = null;
        String srcURL = "jdbc:teiid:designtimecatalog@mm://slwxp172:44401;user=ddifranco;password=";
        String password = null;
        String tgtURL = "mm://slwxp172:44401";
        for (char ch = ' '; ch <= '~'; ch = (char)((char)(ch + 1))) {
            if (ch == 59 || ch == 61 || ch == 37) continue;
            password = ch + "mm";
            result = new JDBCURL(srcURL + URLEncoder.encode(password, "UTF-8")).getConnectionURL();
            TestJDBCURL.assertEquals((String)("Failed to obtain correct ServerURL when using password " + password), (String)tgtURL, (String)result);
        }
    }

    public void testGetServerURL_2Servers() {
        String result = new JDBCURL("jdbc:teiid:designtimecatalog@mm://slwxp172:44401,slabc123:12345;user=ddifranco;password=mm").getConnectionURL();
        TestJDBCURL.assertEquals((String)"mm://slwxp172:44401,slabc123:12345", (String)result);
    }

    public void testBuildEmbeedURL() {
        JDBCURL url = new JDBCURL("vdb", "/home/foo/deploy.properties", new Properties());
        TestJDBCURL.assertEquals((String)"jdbc:teiid:vdb@/home/foo/deploy.properties", (String)url.getJDBCURL());
        Properties p = new Properties();
        p.setProperty("user", "test");
        p.setProperty("password", "pass");
        p.setProperty("autoFailover", "true");
        p.setProperty("any", "thing");
        url = new JDBCURL("vdb", "/home/foo/deploy.properties", p);
        TestJDBCURL.assertTrue((boolean)url.getJDBCURL().startsWith("jdbc:teiid:vdb@/home/foo/deploy.properties;user=test;"));
        TestJDBCURL.assertTrue((url.getJDBCURL().indexOf("any=thing") != -1 ? 1 : 0) != 0);
        TestJDBCURL.assertTrue((url.getJDBCURL().indexOf("password=pass") != -1 ? 1 : 0) != 0);
        TestJDBCURL.assertTrue((url.getJDBCURL().indexOf("autoFailover=true") != -1 ? 1 : 0) != 0);
    }
}

