/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.net.MalformedURLException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.XAConnection;
import org.teiid.jdbc.BaseDataSource;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.JDBCPlugin;
import org.teiid.jdbc.JDBCURL;
import org.teiid.jdbc.TeiidDriver;
import org.teiid.jdbc.TeiidSQLException;
import org.teiid.jdbc.XAConnectionImpl;
import org.teiid.net.TeiidURL;

public class TeiidDataSource
extends BaseDataSource {
    private static final long serialVersionUID = -5170316154373144878L;
    private int portNumber;
    private String serverName;
    private boolean secure = false;
    private String alternateServers;
    private String autoFailover;
    private String discoveryStrategy;
    private boolean passthroughAuthentication = false;
    private String jaasName;
    private String kerberosServicePrincipleName;
    private boolean encryptRequests;
    private final TeiidDriver driver;
    private boolean loadBalance = true;

    public TeiidDataSource() {
        this.driver = new TeiidDriver();
    }

    TeiidDataSource(TeiidDriver driver) {
        this.driver = driver;
    }

    @Override
    protected Properties buildProperties(String userName, String password) {
        Properties props = super.buildProperties(userName, password);
        if (this.getAutoFailover() != null) {
            props.setProperty("autoFailover", this.getAutoFailover());
        }
        if (this.getDiscoveryStrategy() != null) {
            props.setProperty("discoveryStategy", this.getDiscoveryStrategy());
        }
        if (this.encryptRequests) {
            props.setProperty("encryptRequests", Boolean.TRUE.toString());
        }
        if (this.getLoginTimeout() > 0) {
            props.setProperty("loginTimeout", String.valueOf(this.getLoginTimeout()));
        }
        if (this.getJaasName() != null) {
            props.setProperty("jaasName", this.getJaasName());
        }
        if (this.getKerberosServicePrincipleName() != null) {
            props.setProperty("kerberosServicePrincipleName", this.getKerberosServicePrincipleName());
        }
        return props;
    }

    protected String buildServerURL() throws TeiidSQLException {
        if (this.serverName == null) {
            return null;
        }
        if (this.alternateServers == null || this.alternateServers.length() == 0) {
            return new TeiidURL(this.serverName, this.portNumber, this.secure).getAppServerURL();
        }
        String serverURL = this.secure ? "mms://" : "mm://";
        serverURL = this.serverName.indexOf(58) != -1 && !this.serverName.startsWith("[") ? serverURL + "[" + this.serverName + "]" : serverURL + this.serverName;
        serverURL = serverURL + ":" + this.portNumber;
        String[] as = this.alternateServers.split(",");
        for (int i = 0; i < as.length; ++i) {
            String server = as[i].trim();
            if (server.startsWith("[") && server.endsWith("]")) {
                String msg = TeiidDataSource.reasonWhyInvalidServerName(server.substring(1, server.length() - 1));
                if (msg != null) {
                    throw this.createConnectionError(JDBCPlugin.Util.getString("MMDataSource.alternateServer_is_invalid", new Object[]{msg}));
                }
                serverURL = serverURL + "," + as[i] + ":" + this.portNumber;
                continue;
            }
            String[] serverParts = server.split(":", 2);
            String msg = TeiidDataSource.reasonWhyInvalidServerName(serverParts[0]);
            if (msg != null) {
                throw this.createConnectionError(JDBCPlugin.Util.getString("MMDataSource.alternateServer_is_invalid", new Object[]{msg}));
            }
            serverURL = serverURL + "," + serverParts[0] + ":";
            if (serverParts.length > 1) {
                try {
                    TeiidURL.validatePort(serverParts[1]);
                }
                catch (MalformedURLException e) {
                    throw this.createConnectionError(JDBCPlugin.Util.getString("MMDataSource.alternateServer_is_invalid", new Object[]{e.getMessage()}));
                }
                serverURL = serverURL + serverParts[1];
                continue;
            }
            serverURL = serverURL + this.portNumber;
        }
        try {
            return new TeiidURL(serverURL).getAppServerURL();
        }
        catch (MalformedURLException e) {
            throw TeiidSQLException.create(e);
        }
    }

    protected JDBCURL buildURL() throws TeiidSQLException {
        return new JDBCURL(this.getDatabaseName(), this.buildServerURL(), this.buildProperties(this.getUser(), this.getPassword()));
    }

    @Override
    protected void validateProperties(String userName, String password) throws SQLException {
        super.validateProperties(userName, password);
        String reason = TeiidDataSource.reasonWhyInvalidPortNumber(this.portNumber);
        if (reason != null) {
            throw this.createConnectionError(reason);
        }
        reason = TeiidDataSource.reasonWhyInvalidServerName(this.serverName);
        if (reason != null) {
            throw this.createConnectionError(reason);
        }
    }

    private TeiidSQLException createConnectionError(String reason) {
        String msg = JDBCPlugin.Util.getString("MMDataSource.Err_connecting", new Object[]{reason});
        return new TeiidSQLException(msg);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(null, null);
    }

    @Override
    public Connection getConnection(String userName, String password) throws SQLException {
        if (this.getServerName() == null) {
            super.validateProperties(userName, password);
            Properties props = this.buildEmbeddedProperties(userName, password);
            String url = new JDBCURL(this.getDatabaseName(), null, null).getJDBCURL();
            return this.driver.connect(url, props);
        }
        this.validateProperties(userName, password);
        Properties props = this.buildProperties(userName, password);
        return this.driver.connect(new JDBCURL(this.getDatabaseName(), this.buildServerURL(), null).getJDBCURL(), props);
    }

    private Properties buildEmbeddedProperties(String userName, String password) {
        Properties props = this.buildProperties(userName, password);
        props.setProperty("PassthroughAuthentication", Boolean.toString(this.passthroughAuthentication));
        return props;
    }

    public String toString() {
        try {
            return this.buildURL().getJDBCURL();
        }
        catch (TeiidSQLException e) {
            return e.getMessage();
        }
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public String getServerName() {
        return this.serverName;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public String getAlternateServers() {
        if (this.alternateServers != null && this.alternateServers.length() < 1) {
            return null;
        }
        return this.alternateServers;
    }

    public void setPortNumber(int portNumber) {
        this.portNumber = portNumber;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public void setAlternateServers(String servers) {
        this.alternateServers = servers;
        if (this.alternateServers != null && this.alternateServers.length() < 1) {
            this.alternateServers = null;
        }
    }

    public static String reasonWhyInvalidPortNumber(int portNumber) {
        return TeiidURL.validatePort(portNumber);
    }

    public static String reasonWhyInvalidServerName(String serverName) {
        if (serverName == null || serverName.trim().length() == 0) {
            return JDBCPlugin.Util.getString("MMDataSource.Server_name_required");
        }
        return null;
    }

    public static String reasonWhyInvalidSocketsPerVM(String socketsPerVM) {
        if (socketsPerVM != null) {
            int value = -1;
            try {
                value = Integer.parseInt(socketsPerVM);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (value <= 0) {
                return JDBCPlugin.Util.getString("MMDataSource.Sockets_per_vm_invalid");
            }
        }
        return null;
    }

    public static String reasonWhyInvalidStickyConnections(String stickyConnections) {
        if (stickyConnections != null && !stickyConnections.equalsIgnoreCase("true") && !stickyConnections.equalsIgnoreCase("false")) {
            return JDBCPlugin.Util.getString("MMDataSource.Sticky_connections_invalid");
        }
        return null;
    }

    public String getAutoFailover() {
        return this.autoFailover;
    }

    public void setAutoFailover(String autoFailover) {
        this.autoFailover = autoFailover;
    }

    public String getDiscoveryStrategy() {
        return this.discoveryStrategy;
    }

    public void setDiscoveryStrategy(String discoveryStrategy) {
        this.discoveryStrategy = discoveryStrategy;
    }

    public boolean isPassthroughAuthentication() {
        return this.passthroughAuthentication;
    }

    public boolean getPassthroughAuthentication() {
        return this.passthroughAuthentication;
    }

    public void setPassthroughAuthentication(boolean passthroughAuthentication) {
        this.passthroughAuthentication = passthroughAuthentication;
    }

    public String getJaasName() {
        return this.jaasName;
    }

    public void setJaasName(String jaasApplicationName) {
        this.jaasName = jaasApplicationName;
    }

    public String getKerberosServicePrincipleName() {
        return this.kerberosServicePrincipleName;
    }

    public void setKerberosServicePrincipleName(String kerberosServerName) {
        this.kerberosServicePrincipleName = kerberosServerName;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return TeiidDriver.logger;
    }

    public void setEncryptRequests(boolean encryptRequests) {
        this.encryptRequests = encryptRequests;
    }

    public boolean isEncryptRequests() {
        return this.encryptRequests;
    }

    public boolean getEncryptRequests() {
        return this.encryptRequests;
    }

    public boolean isLoadBalance() {
        return this.loadBalance;
    }

    public boolean getLoadBalance() {
        return this.loadBalance;
    }

    public void setLoadBalance(boolean loadBalance) {
        this.loadBalance = loadBalance;
    }

    @Override
    public XAConnection getXAConnection(String userName, String password) throws SQLException {
        XAConnectionImpl result = new XAConnectionImpl((ConnectionImpl)this.getConnection(userName, password));
        result.setLoadBalance(this.loadBalance);
        return result;
    }
}

