/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.cdk;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryParserException;
import com.metamatrix.api.exception.query.QueryResolverException;
import com.metamatrix.api.exception.query.QueryValidatorException;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.relational.AliasGenerator;
import com.metamatrix.query.parser.QueryParser;
import com.metamatrix.query.resolver.QueryResolver;
import com.metamatrix.query.rewriter.QueryRewriter;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.lang.Select;
import com.metamatrix.query.sql.symbol.AllSymbol;
import java.util.ArrayList;
import java.util.List;
import org.teiid.connector.language.ICommand;
import org.teiid.connector.language.ILanguageFactory;
import org.teiid.dqp.internal.datamgr.language.LanguageBridgeFactory;
import org.teiid.dqp.internal.datamgr.language.LanguageFactoryImpl;

public class CommandBuilder {
    private QueryMetadataInterface metadata;

    public static ILanguageFactory getLanuageFactory() {
        return LanguageFactoryImpl.INSTANCE;
    }

    public CommandBuilder(QueryMetadataInterface metadata) {
        this.metadata = metadata;
    }

    public ICommand getCommand(String queryString) {
        return this.getCommand(queryString, false, false);
    }

    public ICommand getCommand(String queryString, boolean generateAliases, boolean supportsGroupAlias) {
        Command command = null;
        try {
            command = QueryParser.getQueryParser().parseCommand(queryString);
            QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)this.metadata);
            command = QueryRewriter.rewrite((Command)command, null, (QueryMetadataInterface)this.metadata, null);
            this.expandAllSymbol(command);
            if (generateAliases) {
                command.acceptVisitor((LanguageVisitor)new AliasGenerator(supportsGroupAlias));
            }
            ICommand result = new LanguageBridgeFactory(this.metadata).translate(command);
            return result;
        }
        catch (QueryParserException e) {
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
        catch (QueryResolverException e) {
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
        catch (MetaMatrixComponentException e) {
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
        catch (QueryValidatorException e) {
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
    }

    protected void expandAllSymbol(Command command) {
        if (command instanceof Query) {
            Query query = (Query)command;
            Select select = query.getSelect();
            List originalSymbols = select.getSymbols();
            ArrayList expandedSymbols = new ArrayList();
            for (Object next : originalSymbols) {
                if (next instanceof AllSymbol) {
                    AllSymbol allSymbol = (AllSymbol)next;
                    expandedSymbols.addAll(allSymbol.getElementSymbols());
                    continue;
                }
                expandedSymbols.add(next);
            }
            select.setSymbols(expandedSymbols);
        }
    }
}

