/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.cdk;

import com.metamatrix.cdk.CdkPlugin;
import com.metamatrix.cdk.IConnectorHost;
import com.metamatrix.cdk.QueryCommandTarget;
import com.metamatrix.cdk.api.ConnectorHost;
import com.metamatrix.cdk.file.XMLConfigReaderWriter;
import com.metamatrix.common.config.api.ConfigurationObjectEditor;
import com.metamatrix.common.config.api.ConnectorArchive;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.ConnectorBindingType;
import com.metamatrix.common.config.api.ExtensionModule;
import com.metamatrix.common.config.model.BasicConfigurationObjectEditor;
import com.metamatrix.common.config.model.BasicConnectorArchive;
import com.metamatrix.common.config.model.BasicExtensionModule;
import com.metamatrix.common.config.xml.XMLConfigurationImportExportUtility;
import com.metamatrix.common.util.ByteArrayHelper;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.commandshell.ConnectorResultUtility;
import com.metamatrix.core.factory.ComponentLoader;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.core.util.StringUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.teiid.connector.api.Connector;
import org.teiid.connector.api.ConnectorException;
import org.teiid.connector.language.ICommand;
import org.teiid.connector.language.IProcedure;
import org.teiid.connector.language.IQuery;

public class ConnectorShellCommandTarget
extends QueryCommandTarget {
    private static final String MM_JAR_PROTOCOL = "extensionjar";
    private static final String CONNECTOR_CLASSPATH = "ConnectorClassPath";
    private static final String CONNECTOR_CLASS_NAME = "ConnectorClass";
    private IConnectorHost connectorHost;
    private Properties connectorProperties = null;
    private Connector connector;
    private String vdbFileName;
    private String connectorClassName = null;
    private URLClassLoader connectorClassLoader = null;

    public ConnectorShellCommandTarget() {
    }

    public ConnectorShellCommandTarget(IConnectorHost connectorHost) {
        this.connectorHost = connectorHost;
    }

    @Override
    protected String execute(String query) {
        try {
            ICommand command = this.getConnectorHost().getCommand(query);
            String[] columnNames = null;
            if (command instanceof IQuery) {
                IQuery iquery = (IQuery)command;
                columnNames = iquery.getColumnNames();
            } else if (!(command instanceof IProcedure)) {
                columnNames = new String[]{"count"};
            }
            List results = this.getConnectorHost().executeCommand(command);
            return ConnectorResultUtility.resultsToString(results, columnNames);
        }
        catch (ConnectorException e) {
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
    }

    @Override
    protected Set getMethodsToIgnore() {
        HashSet<String> result = new HashSet<String>();
        result.addAll(Arrays.asList("runRep", "setUsePreparedStatement"));
        return result;
    }

    public void loadFromScript(String configurationScriptFileName) {
        ComponentLoader loader = new ComponentLoader(this.getClass().getClassLoader(), configurationScriptFileName);
        this.connectorHost = (IConnectorHost)loader.load("ConnectorHost");
    }

    public void load(String connectorClassName, String vdbFileName) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        if (this.connectorClassLoader == null) {
            Class.forName(connectorClassName);
            this.connectorProperties = new Properties();
        } else {
            this.connectorClassLoader.loadClass(connectorClassName).newInstance();
        }
        this.vdbFileName = vdbFileName;
        this.connectorClassName = connectorClassName;
        this.connectorHost = null;
    }

    public void start() throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        if (this.connectorHost == null) {
            if (this.vdbFileName == null) {
                throw new RuntimeException(CdkPlugin.Util.getString("ConnectorShellCommandTarget.Connector_must_be_loaded_before_it_can_be_used._1"));
            }
            this.connector = this.connectorClassLoader == null ? (Connector)Class.forName(this.connectorClassName).newInstance() : (Connector)this.connectorClassLoader.loadClass(this.connectorClassName).newInstance();
            this.connectorHost = new ConnectorHost(this.connector, this.connectorProperties, this.shell.expandFileName(this.vdbFileName));
        }
    }

    public void stop() {
        if (this.connector != null) {
            this.connector.stop();
            this.connector = null;
        }
        this.connectorHost = null;
    }

    public void loadProperties(String propertyFileName) {
        File propertyFile = new File(propertyFileName);
        if (!(propertyFile.exists() && propertyFile.isFile() && propertyFile.canRead())) {
            throw new RuntimeException(CdkPlugin.Util.getString("ConnectorShellCommandTarget.Cannot_read_from_file__{0}_1", new Object[]{propertyFile}));
        }
        try {
            this.connectorProperties = this.loadFromXMLConfig(propertyFile);
            return;
        }
        catch (Exception exception) {
            this.connectorProperties = this.loadFromPropertiesFile(propertyFile);
            return;
        }
    }

    private Properties loadFromXMLConfig(File propertyFile) {
        XMLConfigReaderWriter xmlConfig = new XMLConfigReaderWriter();
        FileInputStream in = null;
        try {
            in = new FileInputStream(propertyFile);
        }
        catch (IOException e) {
            throw new RuntimeException(CdkPlugin.Util.getString("ConnectorShellCommandTarget.Cannot_read_from_file__{0}_1", new Object[]{propertyFile}));
        }
        try {
            ConnectorBinding binding = (ConnectorBinding)xmlConfig.loadConnectorBinding(in)[1];
            Properties properties = binding.getProperties();
            return properties;
        }
        catch (Exception e) {
            throw new RuntimeException(CdkPlugin.Util.getString("ConnectorShellCommandTarget.Could_not_load_XML_configuration_from_file__{0}_1", new Object[]{propertyFile}));
        }
        finally {
            try {
                ((InputStream)in).close();
            }
            catch (Exception e) {}
        }
    }

    private Properties loadFromPropertiesFile(File propertyFile) {
        Properties props = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(propertyFile);
            props.load(in);
            Properties properties = props;
            return properties;
        }
        catch (IOException e) {
            throw new RuntimeException(CdkPlugin.Util.getString("ConnectorShellCommandTarget.Cannot_read_from_file__{0}_1", new Object[]{propertyFile}));
        }
        finally {
            try {
                ((InputStream)in).close();
            }
            catch (Exception e) {}
        }
    }

    public void setFailOnError(boolean failOnError) {
        if (failOnError) {
            this.shell.turnOffExceptionHandling();
        } else {
            this.shell.turnOnExceptionHandling();
        }
    }

    public void setPrintStackOnError(boolean printStackOnError) {
        this.shell.setPrintStackTraceOnException(printStackOnError);
    }

    public void setSecurityContext(String vdbName, String vdbVersion, String userName) {
        this.getConnectorHost().setSecurityContext(vdbName, vdbVersion, userName, null, null);
    }

    public void setBatchSize(int batchSize) {
    }

    public void setProperty(String propertyName, String propertyValue) {
        if (this.connectorHost == null) {
            if (this.connectorProperties == null) {
                this.connectorProperties = new Properties();
            }
        } else {
            throw new RuntimeException(CdkPlugin.Util.getString("ConnectorShellCommandTarget.Cannot_set_connector_properties_after_the_connector_is_started._1"));
        }
        this.connectorProperties.put(propertyName, propertyValue);
    }

    private IConnectorHost getConnectorHost() {
        return this.connectorHost;
    }

    public String getProperties() {
        StringBuffer props = new StringBuffer();
        IConnectorHost host = this.getConnectorHost();
        if (host != null) {
            Properties properties = host.getConnectorEnvironmentProperties();
            this.stringifyProperties(properties, props);
        } else if (this.connectorProperties != null) {
            this.stringifyProperties(this.connectorProperties, props);
        }
        return props.toString();
    }

    public void createTemplate(String filename) {
        File file;
        block23: {
            file = new File(filename);
            if (file.exists()) {
                if (!file.canWrite()) {
                    throw new RuntimeException(CdkPlugin.Util.getString("ConnectorShellCommandTarget.Cannot_write_to_file__{0}_3", new Object[]{file}));
                }
            } else {
                if (file.getParentFile() == null || file.getParentFile().exists()) {
                    try {
                        if (!file.createNewFile()) {
                            throw new RuntimeException(CdkPlugin.Util.getString("ConnectorShellCommandTarget.Cannot_create_file__{0}_4", new Object[]{file}));
                        }
                        break block23;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(CdkPlugin.Util.getString("ConnectorShellCommandTarget.Cannot_create_file__{0}_4", new Object[]{file}));
                    }
                }
                throw new RuntimeException(CdkPlugin.Util.getString("ConnectorShellCommandTarget.Cannot_create_file_{0}_because_directory_{1}_does_not_exist._6", new Object[]{file, file.getParentFile()}));
            }
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(CdkPlugin.Util.getString("ConnectorShellCommandTarget.Cannot_write_to_file__{0}_3", new Object[]{file}));
        }
        InputStream template = this.getClass().getResourceAsStream("Template.cdk");
        int readByte = -1;
        try {
            while ((readByte = template.read()) != -1) {
                out.write(readByte);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(CdkPlugin.Util.getString("ConnectorShellCommandTarget.Cannot_write_to_file__{0}_3", new Object[]{file}));
        }
        finally {
            try {
                template.close();
            }
            catch (Exception e) {}
            try {
                out.close();
            }
            catch (Exception e) {}
        }
    }

    public void createArchive(String fileName, String cdkName, String extDirName) {
        String lcaseCdkName = cdkName.toLowerCase();
        File out = new File(fileName);
        if (out.exists()) {
            throw new RuntimeException(CdkPlugin.Util.getString("ConnectorShellCommandTarget.archive_file_exists", new Object[]{fileName}));
        }
        File cdk = new File(cdkName);
        if (!cdk.exists() || !lcaseCdkName.endsWith(".cdk")) {
            throw new RuntimeException(CdkPlugin.Util.getString("ConnectorShellCommandTarget.bad_cdk_file", new Object[]{cdkName}));
        }
        File extDir = new File(extDirName);
        if (!extDir.exists() || !extDir.isDirectory()) {
            throw new RuntimeException(CdkPlugin.Util.getString("ConnectorShellCommandTarget.bad_extdir", new Object[]{extDirName}));
        }
        File[] extModules = extDir.listFiles();
        if (extModules.length == 0) {
            throw new RuntimeException(CdkPlugin.Util.getString("ConnectorShellCommandTarget.no_ext_modules", new Object[]{extDirName}));
        }
        try {
            BasicConnectorArchive archive = new BasicConnectorArchive();
            XMLConfigurationImportExportUtility util = new XMLConfigurationImportExportUtility();
            ArrayList types = new ArrayList(util.importComponentTypes((InputStream)new FileInputStream(cdk), (ConfigurationObjectEditor)new BasicConfigurationObjectEditor()));
            ConnectorBindingType type = (ConnectorBindingType)types.get(0);
            archive.addConnectorType(type);
            List neededExtensionModules = this.getExtensionJarNames(type);
            for (String extName : neededExtensionModules) {
                File extModule = new File(extDirName, extName);
                BasicExtensionModule ext = new BasicExtensionModule(extModule.getName(), "JAR File", "JAR File", ByteArrayHelper.toByteArray((File)extModule));
                archive.addExtensionModule(type, (ExtensionModule)ext);
            }
            FileOutputStream fout = new FileOutputStream(out);
            util.exportConnectorArchive((OutputStream)fout, (ConnectorArchive)archive, null);
            fout.close();
        }
        catch (Exception e) {
            throw new RuntimeException(CdkPlugin.Util.getString("ConnectorShellCommandTarget.failed_create_archive", new Object[]{e.getMessage()}));
        }
    }

    public void loadArchive(String fileName, String typeName) {
        XMLConfigurationImportExportUtility util = new XMLConfigurationImportExportUtility();
        File archiveFile = new File(fileName);
        if (!archiveFile.exists()) {
            throw new RuntimeException(CdkPlugin.Util.getString("ConnectorShellCommandTarget.bad_archive_file", new Object[]{fileName}));
        }
        try {
            FileInputStream in = new FileInputStream(archiveFile);
            ConnectorArchive archive = util.importConnectorArchive((InputStream)in, (ConfigurationObjectEditor)new BasicConfigurationObjectEditor());
            in.close();
            ConnectorBindingType type = archive.getConnectorTypes()[0];
            ExtensionModule[] extModules = archive.getExtensionModules(type);
            ArrayList<URL> extModuleUrls = new ArrayList<URL>();
            List neededExtensionModules = this.getExtensionJarNames(type);
            for (String extName : neededExtensionModules) {
                for (int j = 0; j < extModules.length; ++j) {
                    if (!extModules[j].getFullName().equalsIgnoreCase(extName)) continue;
                    File file = new File("extensions/" + extModules[j].getFullName());
                    FileUtils.write((byte[])extModules[j].getFileContents(), (File)file.getCanonicalFile());
                    extModuleUrls.add(file.toURL());
                }
            }
            this.connectorClassName = type.getDefaultValue(CONNECTOR_CLASS_NAME);
            URL[] urls = extModuleUrls.toArray(new URL[extModuleUrls.size()]);
            this.connectorClassLoader = new URLClassLoader(urls, this.getClass().getClassLoader());
            this.connectorProperties = new Properties();
            Properties props = type.getDefaultPropertyValues();
            for (String string : props.keySet()) {
                String value;
                if (string.equals(CONNECTOR_CLASS_NAME) || string.equals(CONNECTOR_CLASSPATH) || (value = type.getDefaultValue(string)) == null) continue;
                this.setProperty(string, type.getDefaultValue(string));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(CdkPlugin.Util.getString("ConnectorShellCommandTarget.failed_load_archive", new Object[]{e.getMessage()}));
        }
    }

    private List getExtensionJarNames(ConnectorBindingType type) {
        ArrayList<String> modules = new ArrayList<String>();
        String classPath = type.getDefaultValue(CONNECTOR_CLASSPATH);
        StringTokenizer st = new StringTokenizer(classPath, ";");
        while (st.hasMoreTokens()) {
            String path = st.nextToken();
            int idx = path.indexOf(MM_JAR_PROTOCOL);
            if (idx == -1) continue;
            String jarFile = path.substring(idx + MM_JAR_PROTOCOL.length() + 1);
            modules.add(jarFile);
        }
        return modules;
    }

    private void stringifyProperties(Properties props, StringBuffer buf) {
        TreeSet<Object> sortedNames = new TreeSet<Object>(props.keySet());
        Object var4_4 = null;
        for (String string : sortedNames) {
            buf.append(string).append("=").append(props.getProperty(string)).append(StringUtilities.LINE_SEPARATOR);
        }
    }
}

