/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.cdk.api;

import com.metamatrix.cdk.IConnectorHost;
import com.metamatrix.cdk.api.EnvironmentUtility;
import com.metamatrix.cdk.api.SysLogger;
import com.metamatrix.cdk.api.TranslationUtility;
import com.metamatrix.common.application.ApplicationEnvironment;
import com.metamatrix.common.application.ApplicationService;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.metadata.runtime.VDBMetadataFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.teiid.connector.api.Connection;
import org.teiid.connector.api.Connector;
import org.teiid.connector.api.ConnectorEnvironment;
import org.teiid.connector.api.ConnectorException;
import org.teiid.connector.api.ConnectorLogger;
import org.teiid.connector.api.DataNotAvailableException;
import org.teiid.connector.api.Execution;
import org.teiid.connector.api.ExecutionContext;
import org.teiid.connector.api.ResultSetExecution;
import org.teiid.connector.api.UpdateExecution;
import org.teiid.connector.language.ICommand;
import org.teiid.connector.metadata.runtime.RuntimeMetadata;
import org.teiid.dqp.internal.datamgr.impl.ConnectorEnvironmentImpl;
import org.teiid.dqp.internal.datamgr.impl.ExecutionContextImpl;
import org.teiid.dqp.internal.datamgr.language.BatchedUpdatesImpl;

public class ConnectorHost
implements IConnectorHost {
    private Connector connector;
    private TranslationUtility util;
    private ConnectorEnvironment connectorEnvironment;
    private ApplicationEnvironment applicationEnvironment;
    private ExecutionContext executionContext;
    private Properties connectorEnvironmentProperties;
    private boolean connectorStarted = false;

    public ConnectorHost(Connector connector, Properties connectorEnvironmentProperties, String vdbFileName) {
        this(connector, connectorEnvironmentProperties, vdbFileName, true);
    }

    public ConnectorHost(Connector connector, Properties connectorEnvironmentProperties, String vdbFileName, boolean showLog) {
        this.initialize(connector, connectorEnvironmentProperties, new TranslationUtility(VDBMetadataFactory.getVDBMetadata((String)vdbFileName)), showLog);
    }

    public ConnectorHost(Connector connector, Properties connectorEnvironmentProperties, TranslationUtility util) {
        this.initialize(connector, connectorEnvironmentProperties, util, true);
    }

    public ConnectorHost(Connector connector, Properties connectorEnvironmentProperties, TranslationUtility util, boolean showLog) {
        this.initialize(connector, connectorEnvironmentProperties, util, showLog);
    }

    private void initialize(Connector connector, Properties connectorEnvironmentProperties, TranslationUtility util, boolean showLog) {
        this.connector = connector;
        this.util = util;
        this.applicationEnvironment = new ApplicationEnvironment();
        this.connectorEnvironment = new ConnectorEnvironmentImpl(connectorEnvironmentProperties, (ConnectorLogger)new SysLogger(showLog), this.applicationEnvironment);
        this.connectorEnvironmentProperties = PropertiesUtils.clone((Properties)connectorEnvironmentProperties);
    }

    public void startConnectorIfNeeded() throws ConnectorException {
        if (!this.connectorStarted) {
            this.startConnector();
        }
    }

    private void startConnector() throws ConnectorException {
        this.connector.start(this.connectorEnvironment);
        this.connectorStarted = true;
    }

    @Override
    public Properties getConnectorEnvironmentProperties() {
        return PropertiesUtils.clone((Properties)this.connectorEnvironmentProperties);
    }

    public void addResourceToConnectorEnvironment(String resourceName, Object resource) {
        this.applicationEnvironment.bindService(resourceName, (ApplicationService)resource);
    }

    @Override
    public void setSecurityContext(String vdbName, String vdbVersion, String userName, Serializable trustedPayload) {
        this.setSecurityContext(vdbName, vdbVersion, userName, trustedPayload, null);
    }

    @Override
    public void setSecurityContext(String vdbName, String vdbVersion, String userName, Serializable trustedPayload, Serializable executionPayload) {
        this.executionContext = new ExecutionContextImpl(vdbName, vdbVersion, userName, trustedPayload, executionPayload, "Connection", "Connector<CDK>", "Request", "1", "0");
    }

    public void setExecutionContext(ExecutionContext context) {
        this.executionContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List executeCommand(String query) throws ConnectorException {
        this.startConnectorIfNeeded();
        Connection connection = null;
        try {
            connection = this.getConnection();
            ICommand command = this.getCommand(query);
            RuntimeMetadata runtimeMetadata = this.getRuntimeMetadata();
            List list = this.executeCommand(connection, command, runtimeMetadata);
            return list;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List executeCommand(ICommand command) throws ConnectorException {
        this.startConnectorIfNeeded();
        Connection connection = null;
        try {
            connection = this.getConnection();
            RuntimeMetadata runtimeMetadata = this.getRuntimeMetadata();
            List list = this.executeCommand(connection, command, runtimeMetadata);
            return list;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    private List executeCommand(Connection connection, ICommand command, RuntimeMetadata runtimeMetadata) throws ConnectorException {
        ExecutionContext execContext = EnvironmentUtility.createExecutionContext("100", "1");
        Execution exec = connection.createExecution(command, execContext, runtimeMetadata);
        exec.execute();
        List<List> results = this.readResultsFromExecution(exec);
        exec.close();
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatchedUpdates(String[] updates) throws ConnectorException {
        this.startConnectorIfNeeded();
        Connection connection = null;
        try {
            connection = this.getConnection();
            RuntimeMetadata runtimeMetadata = this.getRuntimeMetadata();
            ICommand[] commands = new ICommand[updates.length];
            for (int i = 0; i < updates.length; ++i) {
                commands[i] = this.getCommand(updates[i]);
            }
            int[] nArray = this.executeBatchedUpdates(connection, commands, runtimeMetadata);
            return nArray;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    public int[] executeBatchedUpdates(Connection connection, ICommand[] commands, RuntimeMetadata runtimeMetadata) throws ConnectorException {
        List result = this.executeCommand(connection, (ICommand)new BatchedUpdatesImpl(Arrays.asList(commands)), runtimeMetadata);
        int[] counts = new int[result.size()];
        for (int i = 0; i < counts.length; ++i) {
            counts[i] = (Integer)((List)result.get(i)).get(0);
        }
        return counts;
    }

    private List<List> readResultsFromExecution(Execution execution) throws ConnectorException {
        ArrayList<List> results = new ArrayList<List>();
        while (true) {
            try {
                if (execution instanceof ResultSetExecution) {
                    ResultSetExecution rs = (ResultSetExecution)execution;
                    List result = null;
                    while ((result = rs.next()) != null) {
                        results.add(result);
                    }
                } else {
                    UpdateExecution rs = (UpdateExecution)execution;
                    int[] result = rs.getUpdateCounts();
                    for (int i = 0; i < result.length; ++i) {
                        results.add(Arrays.asList(result[i]));
                    }
                }
                break;
            }
            catch (DataNotAvailableException e) {
                try {
                    Thread.sleep(e.getRetryDelay());
                }
                catch (InterruptedException e1) {
                    throw new ConnectorException((Throwable)e1);
                }
            }
        }
        return results;
    }

    private RuntimeMetadata getRuntimeMetadata() {
        return this.util.createRuntimeMetadata();
    }

    @Override
    public ICommand getCommand(String query) {
        return this.util.parseCommand(query);
    }

    private Connection getConnection() throws ConnectorException {
        Connection connection = this.connector.getConnection(this.executionContext);
        return connection;
    }
}

