/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.cdk.api;

import com.metamatrix.cdk.api.SysLogger;
import java.io.Serializable;
import java.util.Properties;
import org.teiid.connector.api.ConnectorEnvironment;
import org.teiid.connector.api.ConnectorLogger;
import org.teiid.connector.api.ExecutionContext;
import org.teiid.dqp.internal.datamgr.impl.ConnectorEnvironmentImpl;
import org.teiid.dqp.internal.datamgr.impl.ExecutionContextImpl;

public class EnvironmentUtility {
    private EnvironmentUtility() {
    }

    public static ConnectorLogger createStdoutLogger(int logLevel) {
        SysLogger logger = new SysLogger();
        logger.setLevel(logLevel);
        return logger;
    }

    public static ConnectorEnvironment createEnvironment(Properties props, ConnectorLogger logger) {
        if (props.getProperty("ConnectorBindingName") == null) {
            props.setProperty("ConnectorBindingName", "test");
        }
        return new ConnectorEnvironmentImpl(props, logger, null);
    }

    public static ConnectorEnvironment createEnvironment(Properties props) {
        return EnvironmentUtility.createEnvironment(props, true);
    }

    public static ConnectorEnvironment createEnvironment(Properties props, boolean stdoutLog) {
        return EnvironmentUtility.createEnvironment(props, (ConnectorLogger)(stdoutLog ? EnvironmentUtility.createStdoutLogger(3) : new SysLogger(false)));
    }

    public static ExecutionContext createSecurityContext(String user) {
        return new ExecutionContextImpl("vdb", "1", user, null, null, "Connection", "ConnectorID<CDK>", "Request", "1", "0");
    }

    public static ExecutionContext createSecurityContext(String vdbName, String vdbVersion, String user, Serializable trustedToken) {
        return new ExecutionContextImpl(vdbName, vdbVersion, user, trustedToken, null, "Connection", "ConnectorID<CDK>", "Request", "1", "0");
    }

    public static ExecutionContext createExecutionContext(String requestID, String partID) {
        return new ExecutionContextImpl("vdb", "1", "user", null, null, "Connection", "ConnectorID<CDK>", requestID, partID, "0");
    }

    public static ExecutionContext createExecutionContext(String vdbName, String vdbVersion, String user, Serializable trustedToken, Serializable executionPayload, String connectionID, String connectorID, String requestID, String partID, boolean useResultSetCache) {
        return new ExecutionContextImpl(vdbName, vdbVersion, user, trustedToken, executionPayload, connectionID, connectorID, requestID, partID, "0");
    }
}

