/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.cdk.api;

import java.util.Date;
import org.teiid.connector.api.ConnectorLogger;

public class SysLogger
implements ConnectorLogger {
    public static final int OFF = 0;
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    public static final int INFO = 3;
    public static final int DETAIL = 4;
    public static final int TRACE = 5;
    private int logLevel = 3;

    public SysLogger() {
    }

    public SysLogger(boolean shouldLog) {
        this.logLevel = shouldLog ? 5 : 0;
    }

    protected void log(int level, String message, Throwable error) {
        if (level <= this.logLevel) {
            System.out.println(this.getCurrentTimestampString() + " " + message);
            if (error != null) {
                error.printStackTrace(System.out);
            }
        }
    }

    public int getLevel() {
        return this.logLevel;
    }

    public void setLevel(int level) {
        this.logLevel = level;
    }

    protected Date getCurrentTimestamp() {
        return new Date();
    }

    protected String getCurrentTimestampString() {
        return this.getCurrentTimestamp().toString();
    }

    public void logError(String message) {
        this.log(1, message, null);
    }

    public void logError(String message, Throwable error) {
        this.log(1, message, error);
    }

    public void logWarning(String message) {
        this.log(2, message, null);
    }

    public void logInfo(String message) {
        this.log(3, message, null);
    }

    public void logDetail(String message) {
        this.log(4, message, null);
    }

    public void logTrace(String message) {
        this.log(5, message, null);
    }

    public boolean isDetailEnabled() {
        return 4 <= this.logLevel;
    }

    public boolean isErrorEnabled() {
        return 1 <= this.logLevel;
    }

    public boolean isInfoEnabled() {
        return 3 <= this.logLevel;
    }

    public boolean isTraceEnabled() {
        return 5 <= this.logLevel;
    }

    public boolean isWarningEnabled() {
        return 2 <= this.logLevel;
    }

    public void logDetail(String message, Throwable error) {
        this.log(4, message, error);
    }

    public void logInfo(String message, Throwable error) {
        this.log(3, message, error);
    }

    public void logTrace(String message, Throwable error) {
        this.log(5, message, error);
    }

    public void logWarning(String message, Throwable error) {
        this.log(2, message, error);
    }
}

