/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.cdk.api;

import com.metamatrix.cdk.CommandBuilder;
import com.metamatrix.metadata.runtime.VDBMetadataFactory;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import java.io.IOException;
import java.net.URL;
import org.teiid.connector.language.ICommand;
import org.teiid.connector.metadata.runtime.RuntimeMetadata;
import org.teiid.dqp.internal.datamgr.metadata.RuntimeMetadataImpl;

public class TranslationUtility {
    private QueryMetadataInterface metadata;

    public TranslationUtility(String vdbFile) {
        this.metadata = VDBMetadataFactory.getVDBMetadata((String)vdbFile);
    }

    public TranslationUtility(URL url) {
        try {
            this.metadata = VDBMetadataFactory.getVDBMetadata((URL)url);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public TranslationUtility(QueryMetadataInterface metadata) {
        this.metadata = metadata;
    }

    public ICommand parseCommand(String sql, boolean generateAliases, boolean supportsGroupAliases) {
        CommandBuilder commandBuilder = new CommandBuilder(this.metadata);
        return commandBuilder.getCommand(sql, generateAliases, supportsGroupAliases);
    }

    public ICommand parseCommand(String sql) {
        CommandBuilder commandBuilder = new CommandBuilder(this.metadata);
        return commandBuilder.getCommand(sql);
    }

    public RuntimeMetadata createRuntimeMetadata() {
        return new RuntimeMetadataImpl(this.metadata);
    }
}

