/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.commandshell;

import com.metamatrix.core.CorePlugin;
import com.metamatrix.core.commandshell.CommandTarget;
import com.metamatrix.core.commandshell.ConnectorResultUtility;
import com.metamatrix.core.commandshell.NoScriptFileException;
import com.metamatrix.core.commandshell.ScriptFileNameStack;
import com.metamatrix.core.commandshell.ScriptResultListener;
import com.metamatrix.core.util.StringUtil;
import java.util.Arrays;
import java.util.List;

public class ScriptCommandTarget
extends CommandTarget
implements StringUtil.Constants {
    protected static final String TEST_PREFIX = "test";
    protected int testFailureCount = 0;
    protected int testCount = 0;
    private ScriptFileNameStack scriptFileNames = new ScriptFileNameStack();
    private boolean runningSetUp = false;
    protected static final String SETUP_SCRIPT = "setUp";
    protected StringBuffer testFailureMessage;

    public void setScriptFile(String scriptFileName) {
        this.scriptFileNames.setDefaultScriptFileName(scriptFileName);
    }

    protected boolean hasSetupScript(String fileName) {
        String[] scriptNames = this.shell.getScriptNames(fileName);
        List<String> scriptNameList = Arrays.asList(scriptNames);
        return scriptNameList.contains(SETUP_SCRIPT);
    }

    @Override
    protected void runningScript(String fileName) {
        this.scriptFileNames.usingScriptFile(fileName);
    }

    public String run(String scriptName) {
        if (this.scriptFileNames.hasDefaultScriptFileBeenSet()) {
            return this.runScriptDirect(this.scriptFileNames.getUnexpandedCurrentScriptFileName(), scriptName);
        }
        throw new NoScriptFileException();
    }

    public String runScript(String fileName, String scriptName) {
        return this.runScriptDirect(fileName, scriptName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String runScriptDirect(String originalFileName, String scriptName) {
        String fileName = this.scriptFileNames.expandScriptFileName(originalFileName);
        this.testFailureMessage = new StringBuffer();
        if (!this.runningSetUp && this.hasSetupScript(fileName)) {
            try {
                this.runningSetUp = true;
                this.runScript(fileName, SETUP_SCRIPT, null, null);
            }
            finally {
                this.runningSetUp = false;
            }
        }
        this.runScript(fileName, scriptName, null, this.getScriptResultListener());
        return this.testFailureMessage.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runScript(String fileName, String scriptName, StringBuffer transcript, ScriptResultListener listener) {
        this.scriptFileNames.startingScriptFromFile(fileName);
        try {
            this.shell.runScript(fileName, scriptName, transcript, listener);
        }
        finally {
            this.scriptFileNames.finishedScript();
        }
    }

    private ScriptResultListener getScriptResultListener() {
        return new ScriptResultListener(){

            @Override
            public void scriptResults(String scriptFileName, String scriptName, String expected, String actual) {
                ScriptCommandTarget.this.scriptResults(scriptFileName, scriptName, expected, actual);
            }
        };
    }

    private void scriptResults(String scriptFileName, String scriptName, String expected, String actual) {
        if (!expected.equals(actual)) {
            ++this.testFailureCount;
            String diffString = ConnectorResultUtility.compareResultsStrings(expected, actual);
            this.testFailureMessage.append(CorePlugin.Util.getString("ScriptCommandTarget.Test_{0}.{1}_failed.{2}_2", new Object[]{scriptFileName, scriptName, diffString}));
            this.testFailureMessage.append(NEW_LINE);
        }
    }

    protected void resetTestStatistics() {
        this.testCount = 0;
        this.testFailureCount = 0;
        this.testFailureMessage = new StringBuffer();
    }

    public String runAll() {
        this.resetTestStatistics();
        String fileName = this.scriptFileNames.expandScriptFileName(this.scriptFileNames.getUnexpandedCurrentScriptFileName());
        String[] scriptNames = this.shell.getScriptNames(fileName);
        boolean runSetup = this.hasSetupScript(fileName);
        for (int i = 0; i < scriptNames.length; ++i) {
            if (!scriptNames[i].startsWith(TEST_PREFIX)) continue;
            ++this.testCount;
            if (runSetup) {
                this.runScript(fileName, SETUP_SCRIPT, null, null);
                runSetup = false;
            }
            this.runScript(fileName, scriptNames[i], null, this.getScriptResultListener());
        }
        return this.getTestSummary();
    }

    protected String getTestSummary() {
        return this.testFailureMessage.toString() + CorePlugin.Util.getString("ScriptCommandTarget.Tests_run__{0}_test_failures__{1}_1", new Object[]{new Integer(this.testCount), new Integer(this.testFailureCount)});
    }

    public void runRep(int repCount, String scriptName) {
        for (int i = 0; i < repCount; ++i) {
            this.run(scriptName);
        }
    }

    public void setSilent(boolean silent) {
        this.shell.setSilent(silent);
    }

    protected Object clone() throws CloneNotSupportedException {
        ScriptCommandTarget result = (ScriptCommandTarget)super.clone();
        result.scriptFileNames = (ScriptFileNameStack)this.scriptFileNames.clone();
        return result;
    }
}

