/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.commandshell;

import java.io.File;
import java.util.Stack;

class ScriptFileNameStack
implements Cloneable {
    private String defaultScriptFileName;
    private Stack executingScriptFileName = new Stack();

    ScriptFileNameStack() {
    }

    public void setDefaultScriptFileName(String scriptFileName) {
        this.log("setDefaultScriptFileName", scriptFileName);
        this.defaultScriptFileName = scriptFileName;
    }

    public void usingScriptFile(String scriptFileName) {
        this.log("usingScriptFile", scriptFileName);
        if (!this.hasDefaultScriptFileBeenSet()) {
            this.setDefaultScriptFileName(scriptFileName);
        }
    }

    private void log(String method, String value) {
    }

    public String expandScriptFileName(String scriptFileName) {
        this.log("expandScriptFileName", scriptFileName);
        String result = scriptFileName;
        String parent = this.getParent();
        if (!this.isAbsolute(scriptFileName) && parent != null) {
            result = parent + File.separator + scriptFileName;
        }
        this.log("expandScriptFileName", "result=" + result);
        return result;
    }

    private String getParent() {
        String parent = null;
        if (!this.executingScriptFileName.isEmpty()) {
            parent = new File(this.peek()).getParent();
        }
        return parent;
    }

    public boolean hasDefaultScriptFileBeenSet() {
        return this.defaultScriptFileName != null;
    }

    private String peek() {
        return (String)this.executingScriptFileName.peek();
    }

    private boolean isAbsolute(String fileName) {
        File file = new File(fileName);
        return file.isAbsolute() || fileName.startsWith("\\") || fileName.startsWith("/");
    }

    public String getUnexpandedCurrentScriptFileName() {
        String result = this.getCurrentScriptFileNameDirect();
        this.log("getCurrentScriptFileName", result);
        return result;
    }

    private String getCurrentScriptFileNameDirect() {
        if (this.executingScriptFileName.isEmpty()) {
            return this.defaultScriptFileName;
        }
        return new File(this.peek()).getName();
    }

    public void startingScriptFromFile(String fileName) {
        this.log("startingScriptFromFile", fileName);
        this.executingScriptFileName.push(fileName);
    }

    public void finishedScript() {
        this.log("finishedScript", "");
        this.executingScriptFileName.pop();
    }

    protected Object clone() throws CloneNotSupportedException {
        ScriptFileNameStack result = (ScriptFileNameStack)super.clone();
        this.executingScriptFileName = (Stack)this.executingScriptFileName.clone();
        return result;
    }
}

