/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.factory;

import bsh.EvalError;
import bsh.Interpreter;
import com.metamatrix.cdk.CdkPlugin;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.util.FileUtil;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class ComponentLoader {
    private Interpreter interpreter;

    public ComponentLoader(ClassLoader classLoader, String scriptName) {
        this.init(classLoader, scriptName);
    }

    private void init(ClassLoader classLoader, String scriptName) {
        InputStream scriptStream = classLoader.getResourceAsStream(scriptName);
        if (scriptStream == null) {
            throw new MetaMatrixRuntimeException(CdkPlugin.Util.getString("ComponentLoader.Resource_not_found__{0}_1", new Object[]{scriptName}));
        }
        InputStreamReader scriptReader = new InputStreamReader(scriptStream);
        String script = FileUtil.read((Reader)scriptReader);
        this.interpreter = new Interpreter();
        this.interpreter.setClassLoader(classLoader);
        this.execute(script);
    }

    public void set(String name, Object value) {
        try {
            this.interpreter.set(name, value);
        }
        catch (EvalError e) {
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
    }

    public Object execute(String command) {
        try {
            return this.interpreter.eval(command);
        }
        catch (EvalError e) {
            throw new RuntimeException(e);
        }
    }

    public Object load(String name) {
        return this.execute("load" + name + "()");
    }
}

