/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jdmf.algorithms.classification.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.sf.jdmf.data.input.attribute.AttributeValuePair;
import net.sf.jdmf.data.input.attribute.incidence.AttributeValueIncidence;
import net.sf.jdmf.data.input.attribute.incidence.AttributeValueIncidenceComparator;
import net.sf.jdmf.data.output.Rule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AttributeValuePartitioner {
    private static Log log = LogFactory.getLog(AttributeValuePartitioner.class);

    public List<Rule> partitionValues(String firstAttributeName, String secondAttributeName, List<AttributeValuePair> valuePairs, int minimumMajorityClassExamples) {
        Collections.sort(valuePairs);
        AttributeValueIncidenceComparator incidenceComparator = new AttributeValueIncidenceComparator();
        ArrayList<AttributeValuePair> breakpoints = new ArrayList<AttributeValuePair>();
        ArrayList<AttributeValueIncidence> majorityClassExamples = new ArrayList<AttributeValueIncidence>();
        AttributeValueIncidence valueWithHighestIncidence = null;
        for (AttributeValuePair valuePair : valuePairs) {
            AttributeValueIncidence valueIncidence;
            int valueIncidenceIndex;
            log.debug((Object)("valuePair: " + valuePair.toString()));
            Comparable secondAttributeValue = valuePair.getSecondValue();
            if (valueWithHighestIncidence != null && valueWithHighestIncidence.getCurrentIncidence() >= minimumMajorityClassExamples && !valueWithHighestIncidence.getAttributeValue().equals(secondAttributeValue)) {
                AttributeValuePair lastBreakpoint = (AttributeValuePair)breakpoints.get(breakpoints.size() - 1);
                Comparable finalBreakpointValue = this.calculateBreakpointValue(lastBreakpoint.getFirstValue(), valuePair.getFirstValue());
                lastBreakpoint.setFirstValue(finalBreakpointValue);
                majorityClassExamples.clear();
            }
            if ((valueIncidenceIndex = majorityClassExamples.indexOf(valueIncidence = new AttributeValueIncidence(secondAttributeValue))) >= 0) {
                AttributeValueIncidence currentValueIncidence = (AttributeValueIncidence)majorityClassExamples.get(valueIncidenceIndex);
                currentValueIncidence.checkAttributeValue(secondAttributeValue);
            } else {
                majorityClassExamples.add(valueIncidence);
                valueIncidence.checkAttributeValue(secondAttributeValue);
            }
            valueWithHighestIncidence = Collections.max(majorityClassExamples, incidenceComparator);
            log.debug((Object)("attributeValueWithHighestIncidence: " + valueWithHighestIncidence.toString()));
            Integer highestIncidence = valueWithHighestIncidence.getCurrentIncidence();
            if (!valueIncidence.equals(valueWithHighestIncidence)) continue;
            if (highestIncidence == minimumMajorityClassExamples) {
                AttributeValuePair breakpoint = new AttributeValuePair(valuePair.getFirstValue(), valueWithHighestIncidence.getAttributeValue());
                breakpoints.add(breakpoint);
                continue;
            }
            if (highestIncidence <= minimumMajorityClassExamples) continue;
            AttributeValuePair lastBreakpoint = (AttributeValuePair)breakpoints.get(breakpoints.size() - 1);
            lastBreakpoint.setFirstValue(valuePair.getFirstValue());
        }
        Comparable lastPartitionAttributeValue = this.determineLastPartitionAttributeValue(majorityClassExamples, incidenceComparator);
        log.debug((Object)("lastPartitionAttributeValue=" + lastPartitionAttributeValue));
        this.mergePartitionsWithIdenticalAttributeValue(breakpoints, lastPartitionAttributeValue);
        log.debug((Object)("breakpoints: " + ((Object)breakpoints).toString()));
        ArrayList<Rule> partitioningRules = new ArrayList<Rule>();
        for (int i = 0; i < breakpoints.size(); ++i) {
            Comparable firstAttributeValue = ((AttributeValuePair)breakpoints.get(i)).getFirstValue();
            Comparable secondAttributeValue = ((AttributeValuePair)breakpoints.get(i)).getSecondValue();
            if (i == 0) {
                Rule firstRule = new Rule();
                firstRule.defineIf().attribute(firstAttributeName).isLowerThanOrEqualTo(firstAttributeValue);
                firstRule.defineThen().attribute(secondAttributeName).equals(secondAttributeValue);
                partitioningRules.add(firstRule);
                continue;
            }
            Comparable previousBreakpointAttributeValue = ((AttributeValuePair)breakpoints.get(i - 1)).getFirstValue();
            Rule partitioningRule = new Rule();
            partitioningRule.defineIf().attribute(firstAttributeName).isGreaterThan(previousBreakpointAttributeValue).and(partitioningRule).attribute(firstAttributeName).isLowerThanOrEqualTo(firstAttributeValue);
            partitioningRule.defineThen().attribute(secondAttributeName).equals(secondAttributeValue);
            partitioningRules.add(partitioningRule);
        }
        if (breakpoints.isEmpty()) {
            Rule globalRule = new Rule();
            globalRule.defineThen().attribute(secondAttributeName).equals(lastPartitionAttributeValue);
            partitioningRules.add(globalRule);
        } else {
            Comparable lastBreakpointValue = ((AttributeValuePair)breakpoints.get(breakpoints.size() - 1)).getFirstValue();
            Rule lastRule = new Rule();
            lastRule.defineIf().attribute(firstAttributeName).isGreaterThan(lastBreakpointValue);
            lastRule.defineThen().attribute(secondAttributeName).equals(lastPartitionAttributeValue);
            partitioningRules.add(lastRule);
        }
        return partitioningRules;
    }

    protected void mergePartitionsWithIdenticalAttributeValue(List<AttributeValuePair> breakpoints, Comparable lastPartitionAttributeValue) {
        for (int i = 0; i < breakpoints.size() - 1; ++i) {
            Comparable nextAttributeValue;
            Comparable currentAttributeValue = breakpoints.get(i).getSecondValue();
            if (!currentAttributeValue.equals(nextAttributeValue = breakpoints.get(i + 1).getSecondValue())) continue;
            breakpoints.remove(i);
        }
        if (breakpoints.size() == 1 && breakpoints.get(0).getSecondValue().equals(lastPartitionAttributeValue)) {
            breakpoints.remove(0);
        }
    }

    protected Comparable determineLastPartitionAttributeValue(List<AttributeValueIncidence> majorityClassExamples, AttributeValueIncidenceComparator incidenceComparator) {
        log.debug((Object)("majorityClassExamples.size()=" + majorityClassExamples.size()));
        Collections.sort(majorityClassExamples, incidenceComparator);
        Collections.reverse(majorityClassExamples);
        int valuesWithHighestIncidenceCount = 1;
        for (int i = 0; i < majorityClassExamples.size() - 1 && incidenceComparator.compare(majorityClassExamples.get(i), majorityClassExamples.get(i + 1)) == 0; ++i) {
            ++valuesWithHighestIncidenceCount;
        }
        log.debug((Object)("valuesWithHighestIncidenceCount=" + valuesWithHighestIncidenceCount));
        Random random = new Random();
        AttributeValueIncidence attributeValueIncidence = majorityClassExamples.get(random.nextInt(valuesWithHighestIncidenceCount));
        return attributeValueIncidence.getAttributeValue();
    }

    protected Comparable calculateBreakpointValue(Comparable previousValue, Comparable currentValue) {
        Double firstDouble = (Double)previousValue;
        Double secondDouble = (Double)currentValue;
        return Double.valueOf((firstDouble + secondDouble) / 2.0);
    }
}

