/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jdmf.data.input.attribute;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import net.sf.jdmf.data.input.attribute.Attribute;
import net.sf.jdmf.data.input.attribute.AttributeValuePair;
import net.sf.jdmf.data.input.attribute.Instance;
import net.sf.jdmf.data.output.clustering.Cluster;

public class AttributeConverter {
    public List<Instance> convertToInstances(List<Attribute> attributes) {
        ArrayList<Instance> instances = new ArrayList<Instance>();
        int firstAttributeValuesCount = attributes.get(0).getValues().size();
        for (int i = 0; i < firstAttributeValuesCount; ++i) {
            Instance instance = new Instance();
            for (Attribute attribute : attributes) {
                List<Comparable> attributeValues = attribute.getValues();
                instance.addAttributeValue(attribute.getName(), attributeValues.get(i));
            }
            instances.add(instance);
        }
        return instances;
    }

    public List<Attribute> convertToAttributes(List<Cluster> clusters, List<String> attributeNameOrder) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (String attributeName : attributeNameOrder) {
            Attribute attribute = new Attribute();
            attribute.setName(attributeName);
            attributes.add(attribute);
        }
        Attribute clusterDecision = new Attribute();
        clusterDecision.setName("CLUSTER");
        attributes.add(clusterDecision);
        for (Cluster cluster : clusters) {
            for (Vector<Double> point : cluster.getPoints()) {
                for (int i = 0; i < attributeNameOrder.size(); ++i) {
                    ((Attribute)attributes.get(i)).addValue(point.get(i));
                }
                ((Attribute)attributes.get(attributeNameOrder.size())).addValue((Comparable)((Object)cluster.getName()));
            }
        }
        return attributes;
    }

    public List<AttributeValuePair> convertToValuePairs(Attribute firstAttribute, Attribute secondAttribute) {
        ArrayList<AttributeValuePair> attributeValuePairs = new ArrayList<AttributeValuePair>();
        Iterator<Comparable> firstAttributeValuesIterator = firstAttribute.getValues().iterator();
        Iterator<Comparable> secondAttributeValuesIterator = secondAttribute.getValues().iterator();
        while (firstAttributeValuesIterator.hasNext()) {
            Comparable firstAttributeValue = firstAttributeValuesIterator.next();
            Comparable secondAttributeValue = secondAttributeValuesIterator.next();
            AttributeValuePair attributeValuePair = new AttributeValuePair(firstAttributeValue, secondAttributeValue);
            attributeValuePairs.add(attributeValuePair);
        }
        return attributeValuePairs;
    }

    public List<Vector<Double>> convertToPoints(List<Attribute> attributes) {
        ArrayList<Vector<Double>> points = new ArrayList<Vector<Double>>();
        Attribute firstAttribute = attributes.get(0);
        for (int i = 0; i < firstAttribute.getValues().size(); ++i) {
            points.add(new Vector());
        }
        for (Attribute attribute : attributes) {
            List<Comparable> attributeValues = attribute.getValues();
            for (int i = 0; i < attributeValues.size(); ++i) {
                ((Vector)points.get(i)).add((Double)attributeValues.get(i));
            }
        }
        return points;
    }

    public List<Comparable> groupFirstAttributeValuesBySecondAttributeValue(String firstAttributeName, String secondAttributeName, Comparable selectedValue, List<Instance> instances) {
        ArrayList<Comparable> groupedValues = new ArrayList<Comparable>();
        for (Instance instance : instances) {
            Comparable secondAttributeValue = instance.getValue(secondAttributeName);
            if (!secondAttributeValue.equals(selectedValue)) continue;
            groupedValues.add(instance.getValue(firstAttributeName));
        }
        return groupedValues;
    }
}

