/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jdmf.data.output;

import net.sf.jdmf.data.input.attribute.Instance;
import net.sf.jdmf.data.operators.EqualityOperator;
import net.sf.jdmf.data.output.Evaluable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Item
implements Evaluable {
    private static Log log = LogFactory.getLog(Item.class);
    private String attributeName;
    private Comparable attributeValue;
    private EqualityOperator equalityOperator;

    public Item() {
    }

    public Item(String attributeName, Comparable attributeValue, EqualityOperator equalityOperator) {
        this.attributeName = attributeName;
        this.attributeValue = attributeValue;
        this.equalityOperator = equalityOperator;
    }

    @Override
    public boolean evaluate(Instance instance) {
        log.debug((Object)("left: " + instance.getValue(this.attributeName)));
        log.debug((Object)("right: " + this.attributeValue));
        return this.equalityOperator.evaluate(instance.getValue(this.attributeName), this.attributeValue);
    }

    public String toString() {
        String output = this.attributeName;
        output = output + " ";
        output = output + this.equalityOperator.toString();
        output = output + " ";
        output = output + this.attributeValue.toString();
        return output;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public Comparable getAttributeValue() {
        return this.attributeValue;
    }

    public void setAttributeValue(Comparable attributeValue) {
        this.attributeValue = attributeValue;
    }

    public EqualityOperator getEqualityOperator() {
        return this.equalityOperator;
    }

    public void setEqualityOperator(EqualityOperator equalityOperator) {
        this.equalityOperator = equalityOperator;
    }
}

